/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.rv;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;

class UOI1MethodVisitor
extends MethodVisitor {
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    UOI1MethodVisitor(MethodMutatorFactory factory, MutationContext context, MethodVisitor delegateMethodVisitor) {
        super(589824, delegateMethodVisitor);
        this.factory = factory;
        this.context = context;
    }

    private boolean shouldMutate(String description) {
        if (this.context.getClassInfo().isEnum()) {
            return false;
        }
        MutationIdentifier newId = this.context.registerMutation(this.factory, description);
        return this.context.shouldMutate(newId);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, var);
        switch (opcode) {
            case 21: {
                if (!this.shouldMutate("Incremented (a++) integer local variable number " + var)) break;
                this.mv.visitIincInsn(var, 1);
                break;
            }
            case 23: {
                if (!this.shouldMutate("Incremented (a++) float local variable number " + var)) break;
                this.mv.visitInsn(89);
                this.mv.visitInsn(12);
                this.mv.visitInsn(98);
                this.mv.visitVarInsn(56, var);
                break;
            }
            case 22: {
                if (!this.shouldMutate("Incremented (a++) long local variable number " + var)) break;
                this.mv.visitInsn(92);
                this.mv.visitInsn(10);
                this.mv.visitInsn(97);
                this.mv.visitVarInsn(55, var);
                break;
            }
            case 24: {
                if (!this.shouldMutate("Incremented (a++) double local variable number " + var)) break;
                this.mv.visitInsn(92);
                this.mv.visitInsn(15);
                this.mv.visitInsn(99);
                this.mv.visitVarInsn(57, var);
                break;
            }
        }
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 46: {
                if (this.shouldMutate("Incremented (a++) integer array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(96);
                    this.mv.visitInsn(79);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 48: {
                if (this.shouldMutate("Incremented (a++) float array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(12);
                    this.mv.visitInsn(98);
                    this.mv.visitInsn(81);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 47: {
                if (this.shouldMutate("Incremented (a++) long array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(94);
                    this.mv.visitInsn(10);
                    this.mv.visitInsn(97);
                    this.mv.visitInsn(80);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 49: {
                if (this.shouldMutate("Incremented (a++) double array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(94);
                    this.mv.visitInsn(15);
                    this.mv.visitInsn(99);
                    this.mv.visitInsn(82);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 51: {
                if (this.shouldMutate("Incremented (a++) byte array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(96);
                    this.mv.visitInsn(145);
                    this.mv.visitInsn(84);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            case 53: {
                if (this.shouldMutate("Incremented (a++) short array field")) {
                    this.mv.visitInsn(92);
                    this.mv.visitInsn(opcode);
                    this.mv.visitInsn(91);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(96);
                    this.mv.visitInsn(147);
                    this.mv.visitInsn(86);
                    break;
                }
                this.mv.visitInsn(opcode);
                break;
            }
            default: {
                this.mv.visitInsn(opcode);
            }
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 180) {
            if (desc.equals("I") && this.shouldMutate("Incremented (a++) integer field " + name)) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(90);
                this.mv.visitInsn(4);
                this.mv.visitInsn(96);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("F") && this.shouldMutate("Incremented (a++) float field " + name)) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(90);
                this.mv.visitInsn(12);
                this.mv.visitInsn(98);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("J") && this.shouldMutate("Incremented (a++) long field " + name)) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(93);
                this.mv.visitInsn(10);
                this.mv.visitInsn(97);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("D") && this.shouldMutate("Incremented (a++) double field " + name)) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(93);
                this.mv.visitInsn(15);
                this.mv.visitInsn(99);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("B") && this.shouldMutate("Incremented (a++) byte field " + name)) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(90);
                this.mv.visitInsn(4);
                this.mv.visitInsn(96);
                this.mv.visitInsn(145);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
            if (desc.equals("S") && this.shouldMutate("Incremented (a++) short field " + name)) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(90);
                this.mv.visitInsn(4);
                this.mv.visitInsn(96);
                this.mv.visitInsn(147);
                this.mv.visitFieldInsn(181, owner, name, desc);
                return;
            }
        }
        if (opcode == 178) {
            if (desc.equals("I") && this.shouldMutate("Incremented (a++) static integer field " + name)) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(89);
                this.mv.visitInsn(4);
                this.mv.visitInsn(96);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("F") && this.shouldMutate("Incremented (a++) static float field " + name)) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(89);
                this.mv.visitInsn(12);
                this.mv.visitInsn(98);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("J") && this.shouldMutate("Incremented (a++) static long field " + name)) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(92);
                this.mv.visitInsn(10);
                this.mv.visitInsn(97);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("D") && this.shouldMutate("Incremented (a++) static double field " + name)) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(92);
                this.mv.visitInsn(15);
                this.mv.visitInsn(99);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("B") && this.shouldMutate("Incremented (a++) static byte field " + name)) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(89);
                this.mv.visitInsn(4);
                this.mv.visitInsn(96);
                this.mv.visitInsn(145);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
            if (desc.equals("S") && this.shouldMutate("Incremented (a++) static short field " + name)) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                this.mv.visitInsn(89);
                this.mv.visitInsn(4);
                this.mv.visitInsn(96);
                this.mv.visitInsn(147);
                this.mv.visitFieldInsn(179, owner, name, desc);
                return;
            }
        }
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }
}

