/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F3;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.Mutant;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.execute.CheckTestHasFailedResultListener;
import org.pitest.mutationtest.execute.Reporter;
import org.pitest.mutationtest.execute.TimeOutDecoratedTestSource;
import org.pitest.mutationtest.mocksupport.JavassistInterceptor;
import org.pitest.testapi.Description;
import org.pitest.testapi.TestResult;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.execute.Container;
import org.pitest.testapi.execute.ExitingResultCollector;
import org.pitest.testapi.execute.MultipleTestGroup;
import org.pitest.testapi.execute.Pitest;
import org.pitest.testapi.execute.containers.ConcreteResultCollector;
import org.pitest.testapi.execute.containers.UnContainer;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

public class MutationTestWorker {
    private static final Logger LOG = Log.getLogger();
    private static final boolean DEBUG = LOG.isLoggable(Level.FINE);
    private final Mutater mutater;
    private final ClassLoader loader;
    private final F3<ClassName, ClassLoader, byte[], Boolean> hotswap;
    private final boolean fullMutationMatrix;

    public MutationTestWorker(F3<ClassName, ClassLoader, byte[], Boolean> hotswap, Mutater mutater, ClassLoader loader, boolean fullMutationMatrix) {
        this.loader = loader;
        this.mutater = mutater;
        this.hotswap = hotswap;
        this.fullMutationMatrix = fullMutationMatrix;
    }

    protected void run(Collection<MutationDetails> range, Reporter r, TimeOutDecoratedTestSource testSource) throws IOException {
        for (MutationDetails mutation : range) {
            if (DEBUG) {
                LOG.fine("Running mutation " + mutation);
            }
            long t0 = System.currentTimeMillis();
            this.processMutation(r, testSource, mutation);
            if (!DEBUG) continue;
            LOG.fine("processed mutation in " + (System.currentTimeMillis() - t0) + " ms.");
        }
    }

    private void processMutation(Reporter r, TimeOutDecoratedTestSource testSource, MutationDetails mutationDetails) throws IOException {
        MutationIdentifier mutationId = mutationDetails.getId();
        Mutant mutatedClass = this.mutater.getMutation(mutationId);
        JavassistInterceptor.setMutant(mutatedClass);
        if (DEBUG) {
            LOG.fine("mutating method " + mutatedClass.getDetails().getMethod());
        }
        List<TestUnit> relevantTests = testSource.translateTests(mutationDetails.getTestsInOrder());
        r.describe(mutationId);
        MutationStatusTestPair mutationDetected = this.handleMutation(mutationDetails, mutatedClass, relevantTests);
        r.report(mutationId, mutationDetected);
        if (DEBUG) {
            LOG.fine("Mutation " + mutationId + " detected = " + mutationDetected);
        }
    }

    private MutationStatusTestPair handleMutation(MutationDetails mutationId, Mutant mutatedClass, List<TestUnit> relevantTests) {
        MutationStatusTestPair mutationDetected;
        if (relevantTests == null || relevantTests.isEmpty()) {
            LOG.info("No test coverage for mutation  " + mutationId + " in " + mutatedClass.getDetails().getMethod());
            mutationDetected = MutationStatusTestPair.notAnalysed(0, DetectionStatus.RUN_ERROR);
        } else {
            mutationDetected = this.handleCoveredMutation(mutationId, mutatedClass, relevantTests);
        }
        return mutationDetected;
    }

    private MutationStatusTestPair handleCoveredMutation(MutationDetails mutationId, Mutant mutatedClass, List<TestUnit> relevantTests) {
        MutationStatusTestPair mutationDetected;
        if (DEBUG) {
            LOG.fine("" + relevantTests.size() + " relevant test for " + mutatedClass.getDetails().getMethod());
        }
        Container c = MutationTestWorker.createNewContainer();
        long t0 = System.currentTimeMillis();
        if (this.hotswap.apply(mutationId.getClassName(), this.loader, mutatedClass.getBytes()).booleanValue()) {
            if (DEBUG) {
                LOG.fine("replaced class with mutant in " + (System.currentTimeMillis() - t0) + " ms");
            }
            mutationDetected = this.doTestsDetectMutation(c, relevantTests);
        } else {
            LOG.warning("Mutation " + mutationId + " was not viable ");
            mutationDetected = MutationStatusTestPair.notAnalysed(0, DetectionStatus.NON_VIABLE);
        }
        return mutationDetected;
    }

    private static Container createNewContainer() {
        return new UnContainer(){

            @Override
            public List<TestResult> execute(TestUnit group) {
                ArrayList<TestResult> results = new ArrayList<TestResult>();
                ExitingResultCollector rc = new ExitingResultCollector(new ConcreteResultCollector(results));
                group.execute(rc);
                return results;
            }
        };
    }

    public String toString() {
        return "MutationTestWorker [mutater=" + this.mutater + ", loader=" + this.loader + ", hotswap=" + this.hotswap + "]";
    }

    private MutationStatusTestPair doTestsDetectMutation(Container c, List<TestUnit> tests) {
        try {
            CheckTestHasFailedResultListener listener = new CheckTestHasFailedResultListener(this.fullMutationMatrix);
            Pitest pit = new Pitest(listener);
            if (this.fullMutationMatrix) {
                pit.run(c, tests);
            } else {
                pit.run(c, this.createEarlyExitTestGroup(tests));
            }
            return this.createStatusTestPair(listener);
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private MutationStatusTestPair createStatusTestPair(CheckTestHasFailedResultListener listener) {
        List<String> failingTests = listener.getFailingTests().stream().map(Description::getQualifiedName).collect(Collectors.toList());
        List<String> succeedingTests = listener.getSucceedingTests().stream().map(Description::getQualifiedName).collect(Collectors.toList());
        return new MutationStatusTestPair(listener.getNumberOfTestsRun(), listener.status(), failingTests, succeedingTests);
    }

    private List<TestUnit> createEarlyExitTestGroup(List<TestUnit> tests) {
        return Collections.singletonList(new MultipleTestGroup(tests));
    }
}

