/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.execute.MutationTimeoutDecorator;
import org.pitest.mutationtest.execute.Reporter;
import org.pitest.mutationtest.execute.TimeOutSystemExitSideEffect;
import org.pitest.testapi.TestUnit;

public class TimeOutDecoratedTestSource {
    private final Map<String, TestUnit> allTests = new HashMap<String, TestUnit>();
    private final TimeoutLengthStrategy timeoutStrategy;
    private final Reporter r;

    public TimeOutDecoratedTestSource(TimeoutLengthStrategy timeoutStrategy, List<TestUnit> allTests, Reporter r) {
        this.timeoutStrategy = timeoutStrategy;
        this.mapTests(allTests);
        this.r = r;
    }

    private void mapTests(List<TestUnit> tests) {
        for (TestUnit each : tests) {
            this.allTests.put(each.getDescription().getQualifiedName(), each);
        }
    }

    public List<TestUnit> translateTests(List<TestInfo> testsInOrder) {
        return testsInOrder.stream().flatMap(this.testToTestUnit()).collect(Collectors.toList());
    }

    private Function<TestInfo, Stream<TestUnit>> testToTestUnit() {
        return a -> {
            TestUnit tu = this.allTests.get(a.getName());
            if (tu != null) {
                return Stream.of(new MutationTimeoutDecorator(tu, new TimeOutSystemExitSideEffect(this.r), this.timeoutStrategy, a.getTime()));
            }
            return Stream.empty();
        };
    }
}

