/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

public class CSVReportListener
implements MutationResultListener {
    private final Writer out;

    public CSVReportListener(ResultOutputStrategy outputStrategy) {
        this(outputStrategy.createWriterForFile("mutations.csv"));
    }

    public CSVReportListener(Writer out) {
        this.out = out;
    }

    private String createKillingTestDesc(Optional<String> killingTest) {
        return killingTest.orElse("none");
    }

    private String makeCsv(Object ... os) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 != os.length; ++i2) {
            sb.append(os[i2].toString());
            if (i2 == os.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public void runStart() {
    }

    @Override
    public void runEnd() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    @Override
    public void handleMutationResult(ClassMutationResults metaData) {
        try {
            for (MutationResult mutation : metaData.getMutations()) {
                this.out.write(this.makeCsv(new Object[]{mutation.getDetails().getFilename(), mutation.getDetails().getClassName().asJavaName(), mutation.getDetails().getMutator(), mutation.getDetails().getMethod(), mutation.getDetails().getLineNumber(), mutation.getStatus(), this.createKillingTestDesc(mutation.getKillingTest())}) + System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }
}

