/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import org.pitest.sequence.Context;

@FunctionalInterface
public interface Match<T> {
    public boolean test(Context<T> var1, T var2);

    public static <T> Match<T> always() {
        return (c, t) -> true;
    }

    public static <T> Match<T> never() {
        return (c, t) -> false;
    }

    public static <T> Match<T> isEqual(Object targetRef) {
        return (c, t) -> targetRef.equals(t);
    }

    default public Match<T> and(Match<T> other) {
        return (c, t) -> this.test(c, t) && other.test(c, t);
    }

    default public Match<T> negate() {
        return (c, t) -> !this.test(c, t);
    }

    default public Match<T> or(Match<T> other) {
        return (c, t) -> this.test(c, t) || other.test(c, t);
    }
}

