/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi;

import java.io.Serializable;
import java.util.Objects;

public final class Description
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String testClass;
    private final String name;

    public Description(String name) {
        this(name, (String)null);
    }

    public Description(String name, Class<?> testClass) {
        this(name, testClass.getName());
    }

    public Description(String name, String testClass) {
        this.testClass = this.internIfNotNull(testClass);
        this.name = name;
    }

    private String internIfNotNull(String string) {
        if (string == null) {
            return null;
        }
        return string.intern();
    }

    public String getFirstTestClass() {
        return this.testClass;
    }

    public String getQualifiedName() {
        if (this.testClass != null && !this.testClass.equals(this.getName())) {
            return this.getFirstTestClass() + "." + this.getName();
        }
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.testClass, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Description other = (Description)obj;
        return Objects.equals(this.testClass, other.testClass) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "Description [testClass=" + this.testClass + ", name=" + this.name + "]";
    }
}

