/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.pitest.util.Unchecked;

public class SafeDataOutputStream {
    private final DataOutputStream dos;

    public SafeDataOutputStream(OutputStream os) {
        this.dos = new DataOutputStream(os);
    }

    public void writeInt(int value) {
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeString(String str) {
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        this.writeBytes(data);
    }

    public void writeBytes(byte[] data) {
        try {
            this.dos.writeInt(data.length);
            this.dos.write(data);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public <T extends Serializable> void write(T value) {
        try {
            this.writeBytes(this.toByteArray(value));
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void flush() {
        try {
            this.dos.flush();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void close() {
        try {
            this.dos.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeByte(byte b) {
        try {
            this.dos.writeByte(b);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeBoolean(boolean b) {
        try {
            this.dos.writeBoolean(b);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void writeLong(long l) {
        try {
            this.dos.writeLong(l);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private byte[] toByteArray(Serializable value) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(value);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

