/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public abstract class StreamUtil {
    public static byte[] streamToByteArray(InputStream in) throws IOException {
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            StreamUtil.copy(in, result);
            byte[] byArray = result.toByteArray();
            return byArray;
        }
    }

    public static InputStream copyStream(InputStream in) throws IOException {
        byte[] bs = StreamUtil.streamToByteArray(in);
        return new ByteArrayInputStream(bs);
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        Thread.interrupted();
        ReadableByteChannel src = Channels.newChannel(input);
        WritableByteChannel dest = Channels.newChannel(output);
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }
}

