/*
 * Decompiled with CFR 0.152.
 */
package spoon.metamodel;

import java.util.function.Predicate;
import spoon.SpoonException;
import spoon.reflect.declaration.CtMethod;

public enum MMMethodKind {
    GET(-1, false, 1, m -> m.getParameters().isEmpty() && (m.getSimpleName().startsWith("get") || m.getSimpleName().startsWith("is"))),
    SET(0, false, 1, m -> m.getParameters().size() == 1 && m.getSimpleName().startsWith("set")),
    ADD_FIRST(0, true, 10, m -> {
        if (m.getParameters().size() == 1 && (m.getSimpleName().startsWith("add") || m.getSimpleName().startsWith("insert"))) {
            return m.getSimpleName().endsWith("AtTop") || m.getSimpleName().endsWith("Begin");
        }
        return false;
    }),
    ADD_LAST(0, true, 1, m -> {
        if (m.getParameters().size() == 1) {
            return m.getSimpleName().startsWith("add") || m.getSimpleName().startsWith("insert");
        }
        return false;
    }),
    ADD_ON(1, true, 1, m -> {
        if (m.getParameters().size() == 2 && "int".equals(m.getParameters().get(0).getType().getSimpleName())) {
            return m.getSimpleName().startsWith("add") || m.getSimpleName().startsWith("insert");
        }
        return false;
    }),
    REMOVE(0, true, 1, m -> m.getParameters().size() == 1 && m.getSimpleName().startsWith("remove")),
    GET_BY(-1, true, 1, m -> m.getSimpleName().startsWith("get") && m.getParameters().size() == 1 && m.getParameters().get(0).getType().getQualifiedName().equals(String.class.getName())),
    OTHER(-2, false, 0, m -> true);

    private final Predicate<CtMethod<?>> detector;
    private final int level;
    private final boolean multi;
    private final int valueParameterIndex;

    private MMMethodKind(int valueParameterIndex, boolean multi, int level, Predicate<CtMethod<?>> detector) {
        this.multi = multi;
        this.level = level;
        this.detector = detector;
        this.valueParameterIndex = valueParameterIndex;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public static MMMethodKind kindOf(CtMethod<?> method) {
        MMMethodKind result = OTHER;
        for (MMMethodKind k : MMMethodKind.values()) {
            if (!k.detector.test(method) || result.level > k.level) continue;
            if (result.level == k.level && k != OTHER) {
                throw new SpoonException("Ambiguous method kinds " + result.name() + " X " + k.name() + " for method " + method.getSignature());
            }
            result = k;
        }
        return result;
    }
}

