/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import spoon.SpoonException;
import spoon.pattern.ConflictResolutionMode;
import spoon.pattern.InlinedStatementConfigurator;
import spoon.pattern.Pattern;
import spoon.pattern.PatternParameterConfigurator;
import spoon.pattern.internal.ValueConvertor;
import spoon.pattern.internal.ValueConvertorImpl;
import spoon.pattern.internal.node.ElementNode;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.AbstractParameterInfo;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.QueryFactory;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtFunction;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryable;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.Experimental;

@Experimental
public class PatternBuilder {
    public static final String TARGET_TYPE = "targetType";
    private final List<CtElement> patternModel;
    protected final ListOfNodes patternNodes;
    private final Map<CtElement, RootNode> patternElementToSubstRequests = new IdentityHashMap<CtElement, RootNode>();
    private final Set<RootNode> explicitNodes = Collections.newSetFromMap(new IdentityHashMap());
    private CtTypeReference<?> templateTypeRef;
    private final Map<String, AbstractParameterInfo> parameterInfos = new HashMap<String, AbstractParameterInfo>();
    CtQueryable patternQuery;
    private ValueConvertor valueConvertor;
    private boolean addGeneratedBy = false;
    private boolean autoSimplifySubstitutions = false;
    private boolean built = false;

    public static PatternBuilder create(List<? extends CtElement> patternModel) {
        return new PatternBuilder(patternModel);
    }

    public static PatternBuilder create(CtElement ... elems) {
        return new PatternBuilder(Arrays.asList(elems));
    }

    protected PatternBuilder(List<? extends CtElement> template) {
        if (template == null) {
            throw new SpoonException("Cannot create a Pattern from an null model");
        }
        this.templateTypeRef = this.getDeclaringTypeRef(template);
        this.patternModel = Collections.unmodifiableList(new ArrayList<CtElement>(template));
        this.valueConvertor = new ValueConvertorImpl();
        this.patternNodes = ElementNode.create(this.patternModel, this.patternElementToSubstRequests);
        this.patternQuery = new PatternQuery(this.getFactory().Query(), this.patternModel);
        if (this.templateTypeRef != null) {
            this.configurePatternParameters(pb -> pb.parameter(TARGET_TYPE).byType(this.templateTypeRef).setValueType(CtTypeReference.class));
        }
    }

    private CtTypeReference<?> getDeclaringTypeRef(List<? extends CtElement> template) {
        CtType<?> type = null;
        for (CtElement ctElement : template) {
            CtType t;
            if (ctElement instanceof CtType) {
                t = (CtType)ctElement;
                type = this.mergeType(type, t);
            }
            if ((t = ctElement.getParent(CtType.class)) == null) continue;
            type = this.mergeType(type, t);
        }
        return type == null ? null : type.getReference();
    }

    private CtType<?> mergeType(CtType<?> type, CtType t) {
        if (type == null) {
            return t;
        }
        if (type == t) {
            return type;
        }
        if (type.hasParent(t)) {
            return t;
        }
        if (t.hasParent(type)) {
            return type;
        }
        throw new SpoonException("The pattern on nested types are not supported.");
    }

    RootNode getOptionalPatternNode(CtElement element, CtRole ... roles) {
        return this.getPatternNode(true, element, roles);
    }

    RootNode getPatternNode(CtElement element, CtRole ... roles) {
        return this.getPatternNode(false, element, roles);
    }

    private RootNode getPatternNode(boolean optional, CtElement element, CtRole ... roles) {
        RootNode node = this.patternElementToSubstRequests.get(element);
        for (CtRole role : roles) {
            if (node instanceof ElementNode) {
                ElementNode elementNode = (ElementNode)node;
                if ((node = elementNode.getNodeOfRole(role)) != null) continue;
                if (optional) {
                    return null;
                }
                throw new SpoonException("The role " + (Object)((Object)role) + " resolved to null Node");
            }
            if (optional) {
                return null;
            }
            throw new SpoonException("The role " + (Object)((Object)role) + " can't be resolved on Node of class " + node.getClass());
        }
        if (node == null) {
            if (optional) {
                return null;
            }
            throw new SpoonException("There is no Node for element");
        }
        return node;
    }

    void modifyNodeOfElement(CtElement element, ConflictResolutionMode conflictMode, Function<RootNode, RootNode> elementNodeChanger) {
        RootNode oldNode = this.patternElementToSubstRequests.get(element);
        RootNode newNode = elementNodeChanger.apply(oldNode);
        if (newNode == null) {
            throw new SpoonException("Removing of Node is not supported");
        }
        this.handleConflict(conflictMode, oldNode, newNode, tobeUsedNode -> {
            if (!this.patternNodes.replaceNode(oldNode, (RootNode)tobeUsedNode)) {
                if (conflictMode == ConflictResolutionMode.KEEP_OLD_NODE) {
                    return;
                }
                throw new SpoonException("Old node was not found");
            }
            this.patternElementToSubstRequests.put(element, (RootNode)tobeUsedNode);
        });
    }

    void modifyNodeOfAttributeOfElement(CtElement element, CtRole role, ConflictResolutionMode conflictMode, Function<RootNode, RootNode> elementNodeChanger) {
        this.modifyNodeOfElement(element, conflictMode, node -> {
            if (node instanceof ElementNode) {
                ElementNode elementNode = (ElementNode)node;
                RootNode oldAttrNode = elementNode.getNodeOfRole(role);
                RootNode newAttrNode = (RootNode)elementNodeChanger.apply(oldAttrNode);
                if (newAttrNode == null) {
                    throw new SpoonException("Removing of Node is not supported");
                }
                this.handleConflict(conflictMode, oldAttrNode, newAttrNode, tobeUsedNode -> elementNode.setNodeOfRole(role, (RootNode)tobeUsedNode));
                return node;
            }
            if (conflictMode == ConflictResolutionMode.KEEP_OLD_NODE) {
                return node;
            }
            throw new SpoonException("The Node of atttribute of element cannot be set because element has a Node of class: " + node.getClass().getName());
        });
    }

    private void handleConflict(ConflictResolutionMode conflictMode, RootNode oldNode, RootNode newNode, Consumer<RootNode> applyNewNode) {
        if (oldNode != newNode) {
            if (conflictMode == ConflictResolutionMode.APPEND) {
                if (!(oldNode instanceof ListOfNodes)) {
                    oldNode = new ListOfNodes(new ArrayList<RootNode>(Arrays.asList(oldNode)));
                }
                if (newNode instanceof ListOfNodes) {
                    ((ListOfNodes)oldNode).getNodes().addAll(((ListOfNodes)newNode).getNodes());
                } else {
                    ((ListOfNodes)oldNode).getNodes().add(newNode);
                }
                this.explicitNodes.add(oldNode);
                this.explicitNodes.add(newNode);
                applyNewNode.accept(oldNode);
                return;
            }
            if (this.explicitNodes.contains(oldNode)) {
                if (conflictMode == ConflictResolutionMode.FAIL) {
                    throw new SpoonException("Can't replace once assigned Node " + oldNode + " by a " + newNode);
                }
                if (conflictMode == ConflictResolutionMode.KEEP_OLD_NODE) {
                    return;
                }
            }
            this.explicitNodes.remove(oldNode);
            this.explicitNodes.add(newNode);
            applyNewNode.accept(newNode);
        }
    }

    void setNodeOfElement(CtElement element, RootNode node, ConflictResolutionMode conflictMode) {
        this.modifyNodeOfElement(element, conflictMode, oldNode -> node);
    }

    void setNodeOfAttributeOfElement(CtElement element, CtRole role, RootNode node, ConflictResolutionMode conflictMode) {
        this.modifyNodeOfAttributeOfElement(element, role, conflictMode, oldAttrNode -> node);
    }

    boolean isInModel(CtElement element) {
        if (element != null) {
            for (CtElement patternElement : this.patternModel) {
                if (element != patternElement && !element.hasParent(patternElement)) continue;
                return true;
            }
        }
        return false;
    }

    public Pattern build() {
        if (this.built) {
            throw new SpoonException("The Pattern may be built only once");
        }
        this.built = true;
        this.patternElementToSubstRequests.clear();
        return new Pattern(this.getFactory(), new ListOfNodes(this.patternNodes.getNodes())).setAddGeneratedBy(this.isAddGeneratedBy());
    }

    static List<? extends CtElement> bodyToStatements(CtStatement statementOrBlock) {
        if (statementOrBlock instanceof CtBlock) {
            return ((CtBlock)statementOrBlock).getStatements();
        }
        return Collections.singletonList(statementOrBlock);
    }

    ValueConvertor getDefaultValueConvertor() {
        return this.valueConvertor;
    }

    PatternBuilder setDefaultValueConvertor(ValueConvertor valueConvertor) {
        this.valueConvertor = valueConvertor;
        return this;
    }

    public PatternBuilder configurePatternParameters() {
        this.configurePatternParameters(pb -> {
            pb.setConflictResolutionMode(ConflictResolutionMode.KEEP_OLD_NODE);
            pb.queryModel().filterChildren(new TypeFilter<CtVariableReference>(CtVariableReference.class)).forEach(varRef -> {
                CtElement var = varRef.getDeclaration();
                if (var == null || !this.isInModel(var)) {
                    ParameterInfo parameter = pb.parameter(varRef.getSimpleName()).getCurrentParameter();
                    pb.addSubstitutionRequest(parameter, (CtElement)varRef);
                }
            });
        });
        return this;
    }

    public PatternBuilder configurePatternParameters(Consumer<PatternParameterConfigurator> parametersBuilder) {
        PatternParameterConfigurator pb = new PatternParameterConfigurator(this, this.parameterInfos);
        parametersBuilder.accept(pb);
        return this;
    }

    PatternBuilder configureLocalParameters(Consumer<PatternParameterConfigurator> parametersBuilder) {
        PatternParameterConfigurator pb = new PatternParameterConfigurator(this, new HashMap<String, AbstractParameterInfo>());
        parametersBuilder.accept(pb);
        return this;
    }

    public PatternBuilder configureInlineStatements(Consumer<InlinedStatementConfigurator> consumer) {
        InlinedStatementConfigurator sb = new InlinedStatementConfigurator(this);
        consumer.accept(sb);
        return this;
    }

    static String getLocalTypeRefBySimpleName(CtType<?> templateType, String typeSimpleName) {
        Object type = templateType.getNestedType(typeSimpleName);
        if (type != null) {
            return type.getQualifiedName();
        }
        type = templateType.getPackage().getType(typeSimpleName);
        if (type != null) {
            return type.getQualifiedName();
        }
        HashSet typeQNames = new HashSet();
        templateType.filterChildren(ref -> typeSimpleName.equals(ref.getSimpleName())).forEach(ref -> typeQNames.add(ref.getQualifiedName()));
        if (typeQNames.size() > 1) {
            throw new SpoonException("The type parameter " + typeSimpleName + " is ambiguous. It matches multiple types: " + typeQNames);
        }
        if (typeQNames.size() == 1) {
            return (String)typeQNames.iterator().next();
        }
        return null;
    }

    AbstractParameterInfo getParameterInfo(String parameterName) {
        return this.parameterInfos.get(parameterName);
    }

    protected Factory getFactory() {
        if (this.templateTypeRef != null) {
            return this.templateTypeRef.getFactory();
        }
        if (!this.patternModel.isEmpty()) {
            return this.patternModel.get(0).getFactory();
        }
        throw new SpoonException("PatternBuilder has no CtElement to provide a Factory");
    }

    List<CtElement> getPatternModel() {
        return this.patternModel;
    }

    void forEachNodeOfParameter(ParameterInfo parameter, Consumer<RootNode> consumer) {
        this.patternNodes.forEachParameterInfo((paramInfo, vr) -> {
            if (paramInfo == parameter) {
                consumer.accept((RootNode)vr);
            }
        });
    }

    private boolean isAddGeneratedBy() {
        return this.addGeneratedBy;
    }

    public PatternBuilder setAddGeneratedBy(boolean addGeneratedBy) {
        this.addGeneratedBy = addGeneratedBy;
        return this;
    }

    public boolean isAutoSimplifySubstitutions() {
        return this.autoSimplifySubstitutions;
    }

    public PatternBuilder setAutoSimplifySubstitutions(boolean autoSimplifySubstitutions) {
        this.autoSimplifySubstitutions = autoSimplifySubstitutions;
        return this;
    }

    CtTypeReference<?> getTemplateTypeRef() {
        return this.templateTypeRef;
    }

    static class PatternQuery
    implements CtQueryable {
        private final QueryFactory queryFactory;
        private final List<CtElement> modelElements;

        PatternQuery(QueryFactory queryFactory, List<CtElement> modelElements) {
            this.queryFactory = queryFactory;
            this.modelElements = modelElements;
        }

        @Override
        public <R extends CtElement> CtQuery filterChildren(Filter<R> filter) {
            return this.queryFactory.createQuery(this.modelElements).filterChildren(filter);
        }

        @Override
        public <I, R> CtQuery map(CtFunction<I, R> function) {
            return this.queryFactory.createQuery(this.modelElements).map(function);
        }

        @Override
        public <I> CtQuery map(CtConsumableFunction<I> queryStep) {
            return this.queryFactory.createQuery(this.modelElements).map(queryStep);
        }
    }
}

