/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import spoon.SpoonException;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.visitor.Filter;
import spoon.support.Experimental;

@Experimental
public class PatternBuilderHelper {
    private final CtType<?> patternType;
    private CtType<?> clonedPatternType;
    private List<CtElement> elements = null;

    public PatternBuilderHelper(CtType<?> templateTemplate) {
        this.patternType = templateTemplate;
    }

    private CtType<?> getClonedPatternType() {
        if (this.clonedPatternType == null) {
            this.clonedPatternType = this.patternType.clone();
            if (this.patternType.isParentInitialized()) {
                this.clonedPatternType.setParent(this.patternType.getParent());
            }
            this.setElements(Collections.singletonList(this.clonedPatternType));
        }
        return this.clonedPatternType;
    }

    public PatternBuilderHelper setTypeMember(String typeMemberName) {
        this.setTypeMember((CtTypeMember tm) -> typeMemberName.equals(tm.getSimpleName()));
        return this;
    }

    private PatternBuilderHelper setTypeMember(Filter<CtTypeMember> filter) {
        this.setElements(this.getByFilter(filter));
        return this;
    }

    public PatternBuilderHelper setBodyOfMethod(String methodName) {
        this.setBodyOfMethod((CtMethod<?> tm) -> methodName.equals(tm.getSimpleName()));
        return this;
    }

    private void setBodyOfMethod(Filter<CtMethod<?>> filter) {
        CtStatement body = this.getOneByFilter(filter).getBody();
        this.setElements(body.getStatements());
    }

    public PatternBuilderHelper setReturnExpressionOfMethod(String methodName) {
        this.setReturnExpressionOfMethod((CtMethod<?> tm) -> methodName.equals(tm.getSimpleName()));
        return this;
    }

    private void setReturnExpressionOfMethod(Filter<CtMethod<?>> filter) {
        CtMethod<?> method = this.getOneByFilter(filter);
        CtStatement body = method.getBody();
        if (body.getStatements().size() != 1) {
            throw new SpoonException("The body of " + method.getSignature() + " must contain exactly one statement. But there is:\n" + body.toString());
        }
        CtStatement firstStatement = body.getStatements().get(0);
        if (!(firstStatement instanceof CtReturn)) {
            throw new SpoonException("The body of " + method.getSignature() + " must contain return statement. But there is:\n" + body.toString());
        }
        this.setElements(Collections.singletonList(((CtReturn)firstStatement).getReturnedExpression()));
    }

    private <T extends CtElement> List<T> getByFilter(Filter<T> filter) {
        List elements = this.patternType.filterChildren(filter).list();
        if (elements == null || elements.isEmpty()) {
            throw new SpoonException("Element not found in " + this.patternType.getShortRepresentation());
        }
        return elements;
    }

    private <T extends CtElement> T getOneByFilter(Filter<T> filter) {
        List<T> elements = this.getByFilter(filter);
        if (elements.size() != 1) {
            throw new SpoonException("Only one element must be selected, but there are: " + elements);
        }
        return (T)((CtElement)elements.get(0));
    }

    public PatternBuilderHelper keepTypeMembers(Filter<? super CtElement> filter) {
        for (CtTypeMember ctTypeMember : new ArrayList<CtTypeMember>(this.getClonedPatternType().getTypeMembers())) {
            if (filter.matches(ctTypeMember)) continue;
            ctTypeMember.delete();
        }
        return this;
    }

    public PatternBuilderHelper removeSuperClass() {
        this.getClonedPatternType().setSuperclass(null);
        return this;
    }

    public List<CtElement> getPatternElements() {
        return this.elements;
    }

    private void setElements(List<? extends CtElement> template) {
        this.elements = template;
    }
}

