/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal;

import java.util.List;
import java.util.Map;
import spoon.pattern.Generator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtComment;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.util.ImmutableMap;
import spoon.support.util.ImmutableMapImpl;

public class DefaultGenerator
implements Generator {
    protected final Factory factory;
    private boolean addGeneratedBy = false;
    private ListOfNodes nodes;

    public DefaultGenerator(Factory factory, ListOfNodes nodes) {
        this.nodes = nodes;
        this.factory = factory;
    }

    public <T> T generateSingleTarget(RootNode node, ImmutableMap parameters, Class<T> expectedType) {
        ResultHolder.Single<T> result = new ResultHolder.Single<T>(expectedType);
        this.generateTargets(node, result, parameters);
        return result.getResult();
    }

    public <T> List<T> generateTargets(RootNode node, ImmutableMap parameters, Class<T> expectedType) {
        ResultHolder.Multiple<T> result = new ResultHolder.Multiple<T>(expectedType);
        this.generateTargets(node, result, parameters);
        return result.getResult();
    }

    public <T> void generateTargets(RootNode node, ResultHolder<T> result, ImmutableMap parameters) {
        node.generateTargets(this, result, parameters);
        if (node.isSimplifyGenerated()) {
            result.mapEachResult(element -> {
                if (element instanceof CtCodeElement) {
                    CtCodeElement code = (CtCodeElement)element;
                    try {
                        code = code.partiallyEvaluate();
                        if (result.getRequiredClass().isInstance(code)) {
                            return code;
                        }
                    }
                    catch (SpoonClassNotFoundException e) {
                        this.getFactory().getEnvironment().debugMessage("Partial evaluation was skipped because of: " + e.getMessage());
                    }
                }
                return element;
            });
        }
    }

    public <T> void getValueAs(ParameterInfo parameterInfo, ResultHolder<T> result, ImmutableMap parameters) {
        parameterInfo.getValueAs(this.factory, result, parameters);
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    public DefaultGenerator setAddGeneratedBy(boolean addGeneratedBy) {
        this.addGeneratedBy = addGeneratedBy;
        return this;
    }

    public void applyGeneratedBy(CtElement generatedElement, String genBy) {
        if (this.isAddGeneratedBy() && generatedElement instanceof CtTypeMember && genBy != null) {
            this.addGeneratedByComment(generatedElement, genBy);
        }
    }

    public String getGeneratedByComment(CtElement ele) {
        CtType<?> mainType;
        CompilationUnit cu;
        SourcePosition pos = ele.getPosition();
        if (pos != null && pos.isValidPosition() && (cu = pos.getCompilationUnit()) != null && (mainType = cu.getMainType()) != null) {
            StringBuilder result = new StringBuilder();
            result.append("Generated by ");
            result.append(mainType.getQualifiedName());
            this.appendInnerTypedElements(result, mainType, ele);
            result.append('(');
            result.append(mainType.getSimpleName());
            result.append(".java:");
            result.append(pos.getLine());
            result.append(')');
            return result.toString();
        }
        return null;
    }

    private void appendInnerTypedElements(StringBuilder result, CtType<?> mainType, CtElement ele) {
        CtTypeMember typeMember = this.getFirst(ele, CtTypeMember.class);
        if (typeMember != null && !this.isMainType(typeMember, mainType)) {
            if (typeMember.isParentInitialized()) {
                this.appendInnerTypedElements(result, mainType, typeMember.getParent());
            }
            if (typeMember instanceof CtType) {
                result.append('$');
            } else {
                result.append('#');
            }
            result.append(typeMember.getSimpleName());
        }
    }

    private boolean isMainType(CtTypeMember tm, CtType<?> mainType) {
        if (tm instanceof CtType) {
            return mainType.getQualifiedName().equals(((CtType)tm).getQualifiedName());
        }
        return false;
    }

    private <T extends CtElement> T getFirst(CtElement ele, Class<T> clazz) {
        if (ele != null) {
            if (clazz.isAssignableFrom(ele.getClass())) {
                return (T)ele;
            }
            if (ele.isParentInitialized()) {
                return this.getFirst(ele.getParent(), clazz);
            }
        }
        return null;
    }

    private void addGeneratedByComment(CtElement ele, String generatedBy) {
        if (generatedBy == null) {
            return;
        }
        String EOL = System.getProperty("line.separator");
        CtComment comment = this.getJavaDoc(ele);
        String content = comment.getContent();
        if (!content.trim().isEmpty()) {
            content = content + EOL + EOL;
        }
        content = content + generatedBy;
        comment.setContent(content);
    }

    private CtComment getJavaDoc(CtElement ele) {
        for (CtComment comment : ele.getComments()) {
            if (comment.getCommentType() != CtComment.CommentType.JAVADOC) continue;
            return comment;
        }
        CtComment c = ele.getFactory().Code().createComment("", CtComment.CommentType.JAVADOC);
        ele.addComment(c);
        return c;
    }

    @Override
    public <T extends CtElement> List<T> generate(Class<T> valueType, ImmutableMap params) {
        return this.setAddGeneratedBy(this.isAddGeneratedBy()).generateTargets((RootNode)this.nodes, params, valueType);
    }

    @Override
    public <T extends CtElement> List<T> generate(Class<T> valueType, Map<String, Object> params) {
        return this.generate(valueType, new ImmutableMapImpl(params));
    }

    @Override
    public <T extends CtType<?>> T generateType(String typeQualifiedName, Map<String, Object> params) {
        CtTypeReference newTypeRef = this.factory.Type().createReference(typeQualifiedName);
        CtPackage ownerPackage = newTypeRef.getFactory().Package().getOrCreate(newTypeRef.getPackage().getQualifiedName());
        return this.createType(ownerPackage, newTypeRef.getSimpleName(), params);
    }

    private <T extends CtType<?>> T createType(CtPackage ownerPackage, String typeSimpleName, Map<String, Object> params) {
        List<CtType> types = this.generate(CtType.class, new ImmutableMapImpl(params, "targetType", ownerPackage.getFactory().Type().createReference(DefaultGenerator.getQualifiedName(ownerPackage, typeSimpleName))));
        CtType result = null;
        for (CtType type : types) {
            ownerPackage.addType(type);
            if (!type.getSimpleName().equals(typeSimpleName)) continue;
            result = type;
        }
        return (T)result;
    }

    @Override
    public <T extends CtTypeMember> List<T> addToType(Class<T> valueType, Map<String, Object> params, CtType<?> targetType) {
        List<T> results = this.generate(valueType, new ImmutableMapImpl(params, "targetType", targetType.getReference()));
        for (CtTypeMember result : results) {
            if (!(result instanceof CtTypeMember)) continue;
            targetType.addTypeMember(result);
        }
        return results;
    }

    private static String getQualifiedName(CtPackage pckg, String simpleName) {
        if (pckg.isUnnamedPackage()) {
            return simpleName;
        }
        return pckg.getQualifiedName() + "." + simpleName;
    }

    public boolean isAddGeneratedBy() {
        return this.addGeneratedBy;
    }
}

