/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.matcher;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.SpoonException;
import spoon.pattern.Match;
import spoon.pattern.internal.matcher.TobeMatched;
import spoon.pattern.internal.node.ListOfNodes;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.support.util.ImmutableMapImpl;

public class MatchingScanner
extends EarlyTerminatingScanner<Void> {
    private final ListOfNodes pattern;
    private CtConsumer<? super Match> matchConsumer;

    public MatchingScanner(ListOfNodes pattern, CtConsumer<? super Match> matchConsumer) {
        this.pattern = pattern;
        this.matchConsumer = matchConsumer;
    }

    @Override
    public void scan(CtRole role, CtElement element) {
        if (this.searchMatchInList(role, Collections.singletonList(element), false) == 0) {
            super.scan(role, element);
        }
    }

    @Override
    public void scan(CtRole role, Collection<? extends CtElement> elements) {
        if (elements == null) {
            return;
        }
        if (elements instanceof List) {
            this.searchMatchInList(role, (List)elements, true);
        } else if (elements instanceof Set) {
            this.searchMatchInSet(role, (Set)elements);
        } else {
            throw new SpoonException("Unexpected Collection type " + elements.getClass());
        }
    }

    private int searchMatchInList(CtRole role, List<? extends CtElement> list, boolean scanChildren) {
        int matchCount = 0;
        if (!list.isEmpty()) {
            TobeMatched tobeMatched = TobeMatched.create(new ImmutableMapImpl(), ContainerKind.LIST, list);
            while (tobeMatched.hasTargets()) {
                List<?> matchedTargets;
                TobeMatched nextTobeMatched = this.pattern.matchAllWith(tobeMatched);
                if (nextTobeMatched != null && !(matchedTargets = tobeMatched.getMatchedTargets(nextTobeMatched)).isEmpty()) {
                    ++matchCount;
                    this.matchConsumer.accept(new Match(matchedTargets, nextTobeMatched.getParameters()));
                    tobeMatched = nextTobeMatched.copyAndSetParams(new ImmutableMapImpl());
                    continue;
                }
                if (scanChildren) {
                    super.scan(role, tobeMatched.getTargets().get(0));
                }
                tobeMatched = tobeMatched.removeTarget(0);
            }
        }
        return matchCount;
    }

    private void searchMatchInSet(CtRole role, Set<? extends CtElement> set) {
        if (!set.isEmpty()) {
            List<?> matchedTargets;
            TobeMatched nextTobeMatched;
            TobeMatched tobeMatched = TobeMatched.create(new ImmutableMapImpl(), ContainerKind.SET, set);
            while (tobeMatched.hasTargets() && (nextTobeMatched = this.pattern.matchAllWith(tobeMatched)) != null && !(matchedTargets = tobeMatched.getMatchedTargets(nextTobeMatched)).isEmpty()) {
                this.matchConsumer.accept(new Match(matchedTargets, nextTobeMatched.getParameters()));
                tobeMatched = nextTobeMatched;
            }
            for (Object object : tobeMatched.getTargets()) {
                super.scan(role, object);
            }
        }
    }

    @Override
    public void scan(CtRole role, Map<String, ? extends CtElement> elements) {
        super.scan(role, elements);
    }
}

