/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.node;

import java.util.List;
import java.util.function.BiConsumer;
import spoon.pattern.internal.DefaultGenerator;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.matcher.ChainOfMatchersImpl;
import spoon.pattern.internal.matcher.Matchers;
import spoon.pattern.internal.matcher.TobeMatched;
import spoon.pattern.internal.node.AbstractNode;
import spoon.pattern.internal.node.RootNode;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.support.util.ImmutableMap;

public class ListOfNodes
extends AbstractNode {
    protected List<RootNode> nodes;

    public ListOfNodes(List<RootNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public void forEachParameterInfo(BiConsumer<ParameterInfo, RootNode> consumer) {
        for (RootNode node : this.nodes) {
            node.forEachParameterInfo(consumer);
        }
    }

    @Override
    public <T> void generateTargets(DefaultGenerator generator, ResultHolder<T> result, ImmutableMap parameters) {
        for (RootNode node : this.nodes) {
            generator.generateTargets(node, result, parameters);
        }
    }

    @Override
    public TobeMatched matchTargets(TobeMatched targets, Matchers nextMatchers) {
        return ChainOfMatchersImpl.create(this.nodes, nextMatchers).matchAllWith(targets);
    }

    @Override
    public boolean replaceNode(RootNode oldNode, RootNode newNode) {
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            RootNode node = this.nodes.get(i2);
            if (node == oldNode) {
                this.nodes.set(i2, newNode);
                return true;
            }
            if (!node.replaceNode(oldNode, newNode)) continue;
            return true;
        }
        return false;
    }

    public List<RootNode> getNodes() {
        return this.nodes;
    }
}

