/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.parameter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.pattern.Quantifier;
import spoon.pattern.internal.ResultHolder;
import spoon.pattern.internal.ValueConvertor;
import spoon.pattern.internal.parameter.ListParameterInfo;
import spoon.pattern.internal.parameter.MapParameterInfo;
import spoon.pattern.internal.parameter.ParameterInfo;
import spoon.pattern.internal.parameter.SetParameterInfo;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.factory.Factory;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.util.ImmutableMap;

public abstract class AbstractParameterInfo
implements ParameterInfo {
    protected static final Object NO_MERGE = new Object();
    private final AbstractParameterInfo containerItemAccessor;
    private ContainerKind containerKind = null;
    private Boolean repeatable = null;
    private int minOccurrences = 0;
    private int maxOccurrences = Integer.MAX_VALUE;
    private Quantifier matchingStrategy = Quantifier.GREEDY;
    private ValueConvertor valueConvertor;
    private Predicate<Object> matchCondition;
    private Class<?> parameterValueType;

    protected AbstractParameterInfo(ParameterInfo containerItemAccessor) {
        this.containerItemAccessor = (AbstractParameterInfo)containerItemAccessor;
    }

    protected String getContainerName() {
        if (this.containerItemAccessor != null) {
            return this.containerItemAccessor.getPlainName();
        }
        return "";
    }

    @Override
    public final String getName() {
        AbstractParameterInfo cca = this.getContainerKindAccessor(this.getContainerKind(null, null));
        if (cca != null) {
            return cca.getWrappedName(this.getPlainName());
        }
        return this.getPlainName();
    }

    protected abstract String getPlainName();

    protected abstract String getWrappedName(String var1);

    @Override
    public ImmutableMap addValueAs(ImmutableMap parameters, Object value) {
        Class<?> requiredType = this.getParameterValueType();
        if (requiredType != null && value != null && !requiredType.isInstance(value)) {
            return null;
        }
        if (!this.matches(value)) {
            return null;
        }
        Object newContainer = this.addValueToContainer(parameters, existingValue -> this.merge(existingValue, value));
        if (newContainer == NO_MERGE) {
            return null;
        }
        return (ImmutableMap)newContainer;
    }

    protected Object addValueToContainer(Object container, Function<Object, Object> merger) {
        if (this.containerItemAccessor != null) {
            return this.containerItemAccessor.addValueToContainer(container, existingValue -> this.addValueAs(existingValue, merger));
        }
        return this.addValueAs(container, merger);
    }

    protected Object merge(Object existingValue, Object newValue) {
        ContainerKind cc = this.getContainerKind(existingValue, newValue);
        AbstractParameterInfo cca = this.getContainerKindAccessor(cc);
        if (cca == null) {
            return this.mergeSingle(existingValue, newValue);
        }
        return cca.addValueAs(existingValue, (Object existingListItemValue) -> this.mergeSingle(existingListItemValue, newValue));
    }

    protected AbstractParameterInfo getContainerKindAccessor(ContainerKind containerKind) {
        switch (containerKind) {
            case SINGLE: {
                return null;
            }
            case LIST: {
                return new ListParameterInfo(this);
            }
            case SET: {
                return new SetParameterInfo(this);
            }
            case MAP: {
                return new MapParameterInfo(this);
            }
        }
        throw new SpoonException("Unexpected ContainerKind " + (Object)((Object)containerKind));
    }

    protected Object mergeSingle(Object existingValue, Object newValue) {
        if (newValue == null && this.getMinOccurrences() > 0) {
            return NO_MERGE;
        }
        if (existingValue != null) {
            if (existingValue.equals(newValue)) {
                return existingValue;
            }
            if (newValue != null && existingValue.getClass().equals(newValue.getClass()) && newValue instanceof CtTypeReference && ((CtTypeReference)newValue).getTypeErasure().equals(((CtTypeReference)existingValue).getTypeErasure())) {
                return existingValue;
            }
            Launcher.LOGGER.debug("incongruent match on parameter " + this.getName() + " with value " + newValue);
            return NO_MERGE;
        }
        return newValue;
    }

    protected abstract Object addValueAs(Object var1, Function<Object, Object> var2);

    protected <T> T castTo(Object o, Class<T> type) {
        if (o == null) {
            return this.getEmptyContainer();
        }
        if (type.isInstance(o)) {
            return (T)o;
        }
        throw new SpoonException("Cannot access parameter container of type " + o.getClass() + ". It expects " + type);
    }

    protected abstract <T> T getEmptyContainer();

    public <T> AbstractParameterInfo setMatchCondition(Class<T> requiredType, Predicate<T> matchCondition) {
        this.parameterValueType = requiredType;
        this.matchCondition = matchCondition;
        return this;
    }

    protected boolean matches(Object value) {
        if (!(this.parameterValueType == null || value != null && this.parameterValueType.isAssignableFrom(value.getClass()))) {
            return false;
        }
        if (this.matchCondition == null) {
            return true;
        }
        return this.matchCondition.test(value);
    }

    @Override
    public Class<?> getParameterValueType() {
        return this.parameterValueType;
    }

    public AbstractParameterInfo setParameterValueType(Class<?> parameterValueType) {
        this.parameterValueType = parameterValueType;
        return this;
    }

    @Override
    public boolean isMultiple() {
        return this.getContainerKind(null, null) != ContainerKind.SINGLE;
    }

    public AbstractParameterInfo setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
        return this;
    }

    public int getMinOccurrences() {
        return this.minOccurrences;
    }

    public AbstractParameterInfo setMinOccurrences(int minOccurrences) {
        this.minOccurrences = minOccurrences;
        return this;
    }

    public int getMaxOccurrences() {
        return this.isMultiple() ? this.maxOccurrences : Math.min(this.maxOccurrences, 1);
    }

    public void setMaxOccurrences(int maxOccurrences) {
        this.maxOccurrences = maxOccurrences;
    }

    @Override
    public Quantifier getMatchingStrategy() {
        return this.matchingStrategy;
    }

    public void setMatchingStrategy(Quantifier matchingStrategy) {
        this.matchingStrategy = matchingStrategy;
    }

    public ValueConvertor getValueConvertor() {
        if (this.valueConvertor != null) {
            return this.valueConvertor;
        }
        if (this.containerItemAccessor != null) {
            return this.containerItemAccessor.getValueConvertor();
        }
        throw new SpoonException("ValueConvertor is not defined.");
    }

    public AbstractParameterInfo setValueConvertor(ValueConvertor valueConvertor) {
        if (valueConvertor == null) {
            throw new SpoonException("valueConvertor must not be null");
        }
        this.valueConvertor = valueConvertor;
        return this;
    }

    @Override
    public boolean isRepeatable() {
        if (this.repeatable != null) {
            return this.repeatable;
        }
        return this.isMultiple();
    }

    @Override
    public boolean isMandatory(ImmutableMap parameters) {
        int nrOfValues = this.getNumberOfValues(parameters);
        return nrOfValues < this.getMinOccurrences();
    }

    @Override
    public boolean isTryNextMatch(ImmutableMap parameters) {
        int nrOfValues = this.getNumberOfValues(parameters);
        if (this.getContainerKind(parameters) == ContainerKind.SINGLE) {
            return true;
        }
        return nrOfValues < this.getMaxOccurrences();
    }

    private int getNumberOfValues(ImmutableMap parameters) {
        if (!parameters.hasValue(this.getName())) {
            return 0;
        }
        Object value = parameters.getValue(this.getName());
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        return 1;
    }

    public ContainerKind getContainerKind() {
        return this.containerKind;
    }

    public AbstractParameterInfo setContainerKind(ContainerKind containerKind) {
        this.containerKind = containerKind;
        return this;
    }

    protected ContainerKind getContainerKind(ImmutableMap params) {
        return this.getContainerKind(params.getValue(this.getName()), null);
    }

    protected ContainerKind getContainerKind(Object existingValue, Object value) {
        if (this.containerKind != null) {
            return this.containerKind;
        }
        if (existingValue instanceof List) {
            return ContainerKind.LIST;
        }
        if (existingValue instanceof Set) {
            return ContainerKind.SET;
        }
        if (existingValue instanceof Map) {
            return ContainerKind.MAP;
        }
        if (existingValue instanceof ImmutableMap) {
            return ContainerKind.MAP;
        }
        if (existingValue != null) {
            return ContainerKind.SINGLE;
        }
        if (value instanceof List) {
            return ContainerKind.LIST;
        }
        if (value instanceof Set) {
            return ContainerKind.SET;
        }
        if (value instanceof Map.Entry) {
            return ContainerKind.MAP;
        }
        if (value instanceof Map) {
            return ContainerKind.MAP;
        }
        if (value instanceof ImmutableMap) {
            return ContainerKind.MAP;
        }
        return ContainerKind.SINGLE;
    }

    @Override
    public <T> void getValueAs(Factory factory, ResultHolder<T> result, ImmutableMap parameters) {
        List<CtStatement> rawValue = this.getValue(parameters);
        if (this.isMultiple() && rawValue instanceof CtBlock) {
            rawValue = ((CtBlock)((Object)rawValue)).getStatements();
        }
        this.convertValue(factory, result, rawValue);
    }

    protected Object getValue(ImmutableMap parameters) {
        if (this.containerItemAccessor != null) {
            return this.containerItemAccessor.getValue(parameters);
        }
        return parameters;
    }

    protected <T> void convertValue(Factory factory, ResultHolder<T> result, Object rawValue) {
        if (result.isMultiple()) {
            AbstractParameterInfo.forEachItem(rawValue, singleValue -> {
                Object convertedValue = this.convertSingleValue(factory, singleValue, result.getRequiredClass());
                if (convertedValue != null) {
                    result.addResult(convertedValue);
                }
            });
        } else {
            result.addResult(this.convertSingleValue(factory, rawValue, result.getRequiredClass()));
        }
    }

    protected <T> T convertSingleValue(Factory factory, Object value, Class<T> type) {
        ValueConvertor valueConvertor = this.getValueConvertor();
        return valueConvertor.getValueAs(factory, this.getName(), value, type);
    }

    static void forEachItem(Object multipleValues, Consumer<Object> consumer) {
        if (multipleValues instanceof CtStatementList) {
            consumer.accept(multipleValues);
            return;
        }
        if (multipleValues instanceof Iterable) {
            for (Object item : (Iterable)multipleValues) {
                consumer.accept(item);
            }
            return;
        }
        if (multipleValues instanceof Object[]) {
            for (Object item : (Object[])multipleValues) {
                consumer.accept(item);
            }
            return;
        }
        consumer.accept(multipleValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        if (this.getParameterValueType() != null) {
            sb.append(" : ");
            sb.append(this.getParameterValueType().getName());
        }
        return sb.toString();
    }
}

