/*
 * Decompiled with CFR 0.152.
 */
package spoon.pattern.internal.parameter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import spoon.pattern.internal.parameter.AbstractParameterInfo;
import spoon.support.util.ImmutableMap;

public class SetParameterInfo
extends AbstractParameterInfo {
    public SetParameterInfo(AbstractParameterInfo next) {
        super(next);
    }

    @Override
    protected String getPlainName() {
        return this.getWrappedName(this.getContainerName());
    }

    @Override
    protected String getWrappedName(String containerName) {
        return containerName;
    }

    @Override
    protected Object addValueAs(Object container, Function<Object, Object> merger) {
        Set set = this.castTo(container, Set.class);
        Object newValue = merger.apply(null);
        if (newValue == NO_MERGE) {
            return NO_MERGE;
        }
        if (newValue == null) {
            return set;
        }
        if (set.contains(newValue)) {
            return set;
        }
        LinkedHashSet<Object> newSet = new LinkedHashSet<Object>(set.size() + 1);
        newSet.addAll(set);
        if (newValue instanceof Collection) {
            if (!newSet.addAll((Collection)newValue)) {
                return set;
            }
        } else {
            newSet.add(newValue);
        }
        return Collections.unmodifiableSet(newSet);
    }

    protected Set<Object> getEmptyContainer() {
        return Collections.emptySet();
    }

    @Override
    protected Object getValue(ImmutableMap parameters) {
        return this.castTo(super.getValue(parameters), Set.class);
    }

    @Override
    protected <T> T castTo(Object o, Class<T> type) {
        if (o instanceof List) {
            o = new LinkedHashSet((List)((Object)o));
        } else if (o instanceof Object[]) {
            o = new LinkedHashSet<Object>(Arrays.asList((Object[])o));
        }
        return super.castTo(o, type);
    }
}

