/*
 * Decompiled with CFR 0.152.
 */
package spoon.processing;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import spoon.SpoonException;
import spoon.processing.AbstractProcessor;
import spoon.processing.Processor;
import spoon.reflect.declaration.CtElement;

public abstract class AbstractParallelProcessor<E extends CtElement>
extends AbstractProcessor<E> {
    private ExecutorService service;
    private ArrayBlockingQueue<Processor<E>> processorQueue;

    public AbstractParallelProcessor(Iterable<Processor<E>> processors) {
        int processorNumber = (int)StreamSupport.stream(processors.spliterator(), false).count();
        this.processorQueue = new ArrayBlockingQueue(processorNumber);
        processors.forEach(this.processorQueue::add);
        this.service = Executors.newFixedThreadPool(processorNumber);
    }

    public AbstractParallelProcessor(Iterable<Processor<E>> processors, int numberOfProcessors) {
        this.processorQueue = new ArrayBlockingQueue(numberOfProcessors);
        this.service = Executors.newFixedThreadPool(numberOfProcessors);
        Iterator<Processor<E>> it = processors.iterator();
        for (int i2 = 0; i2 < numberOfProcessors; ++i2) {
            if (!it.hasNext()) {
                throw new SpoonException("not enough elements provided, iterable is already empty");
            }
            this.processorQueue.add(it.next());
        }
    }

    public AbstractParallelProcessor(final Consumer<E> processFunction, int numberOfProcessors) {
        this.processorQueue = new ArrayBlockingQueue(numberOfProcessors);
        for (int i2 = 0; i2 < numberOfProcessors; ++i2) {
            this.processorQueue.add(new AbstractProcessor<E>(){

                @Override
                public void process(E element) {
                    processFunction.accept(element);
                }
            });
        }
        this.service = Executors.newFixedThreadPool(numberOfProcessors);
    }

    @Override
    public final void process(E element) {
        try {
            Processor<E> currentProcessor = this.processorQueue.take();
            this.service.execute(() -> {
                try {
                    currentProcessor.process(element);
                    this.processorQueue.put(currentProcessor);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    e.printStackTrace();
                    this.processorQueue.add(currentProcessor);
                }
                catch (Exception e) {
                    this.processorQueue.add(currentProcessor);
                    throw e;
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    @Override
    public void processingDone() {
        this.service.shutdown();
        super.processingDone();
    }
}

