/*
 * Decompiled with CFR 0.152.
 */
package spoon.refactoring;

import java.util.Collection;
import java.util.Iterator;
import spoon.Launcher;
import spoon.refactoring.MethodCallState;
import spoon.refactoring.MethodInvocationSearch;
import spoon.reflect.CtModel;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.sniper.SniperJavaPrettyPrinter;

public class CtDeprecatedRefactoring {
    protected void removeDeprecatedMethods(String inputPath, String resultPath) {
        Launcher spoon = new Launcher();
        spoon.addInputResource(inputPath);
        spoon.setSourceOutputDirectory(resultPath);
        this.doRefactor(spoon);
    }

    protected void removeDeprecatedMethods(String path) {
        this.removeDeprecatedMethods(path, path);
    }

    private void doRefactor(Launcher spoon) {
        MethodInvocationSearch processor = new MethodInvocationSearch();
        spoon.getEnvironment().setPrettyPrinterCreator(() -> new SniperJavaPrettyPrinter(spoon.getEnvironment()));
        CtModel model = spoon.buildModel();
        model.getElements(new TypeFilter<CtField>(CtField.class)).forEach(processor::scan);
        model.getElements(new TypeFilter<CtExecutable>(CtExecutable.class)).forEach(processor::scan);
        Collection<MethodCallState> invocationsOfMethod = processor.getInvocationsOfMethod();
        this.removeUncalledMethods(invocationsOfMethod);
        for (CtExecutable method : model.getElements(new TypeFilter<CtExecutable>(CtExecutable.class))) {
            if (!method.hasAnnotation(Deprecated.class) || !invocationsOfMethod.stream().noneMatch(v -> v.getMethod().equals(method))) continue;
            method.delete();
        }
        spoon.prettyprint();
    }

    private void removeUncalledMethods(Collection<MethodCallState> invocationsOfMethod) {
        boolean changed = false;
        do {
            changed = false;
            Iterator<MethodCallState> iterator = invocationsOfMethod.iterator();
            while (iterator.hasNext()) {
                MethodCallState entry = iterator.next();
                if (!entry.getMethod().hasAnnotation(Deprecated.class)) continue;
                if (entry.checkCallState()) {
                    changed = true;
                    invocationsOfMethod.forEach(v -> v.remove(entry.getMethod()));
                    iterator.remove();
                }
                if (entry.getCallerMethods().size() != 1 || !entry.getCallerMethods().contains(entry.getMethod()) || !entry.getCallerFields().isEmpty()) continue;
                changed = true;
                invocationsOfMethod.forEach(invocation -> invocation.remove(entry.getMethod()));
                iterator.remove();
            }
        } while (changed);
    }
}

