/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import spoon.SpoonException;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;

public class AnnotationFactory
extends TypeFactory {
    public AnnotationFactory(Factory factory) {
        super(factory);
    }

    public <T extends Annotation> CtAnnotationType<?> create(CtPackage owner, String simpleName) {
        CtAnnotationType t = this.factory.Core().createAnnotationType();
        t.setSimpleName(simpleName);
        owner.addType(t);
        return t;
    }

    public CtAnnotationType<?> create(String qualifiedName) {
        return this.create(this.factory.Package().getOrCreate(this.getPackageName(qualifiedName)), this.getSimpleName(qualifiedName));
    }

    public <T extends Annotation> CtType<T> getAnnotationType(String qualifiedName) {
        return this.get(qualifiedName);
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, Class<A> annotationType, String annotationElementName, Object value) {
        return this.annotate(element, this.factory.Type().createReference(annotationType), annotationElementName, value);
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, CtTypeReference<A> annotationType, String annotationElementName, Object value) {
        boolean isArray;
        CtAnnotation<A> annotation = this.annotate(element, annotationType);
        CtAnnotationType ctAnnotationType = (CtAnnotationType)annotation.getAnnotationType().getDeclaration();
        boolean hasAlreadyValue = annotation.getValues().containsKey(annotationElementName);
        if (ctAnnotationType != null) {
            CtMethod e = ctAnnotationType.getMethod(annotationElementName, new CtTypeReference[0]);
            isArray = e.getType() instanceof CtArrayTypeReference;
        } else {
            Method m;
            try {
                m = annotation.getAnnotationType().getActualClass().getMethod(annotationElementName, new Class[0]);
            }
            catch (Exception ex) {
                annotation.addValue(annotationElementName, value);
                return annotation;
            }
            isArray = m.getReturnType().isArray();
        }
        if (!isArray && hasAlreadyValue) {
            throw new SpoonException("cannot assign an array to a non-array annotation element");
        }
        annotation.addValue(annotationElementName, value);
        return annotation;
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, Class<A> annotationType) {
        return this.annotate(element, this.factory.Type().createReference(annotationType));
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, CtTypeReference<A> annotationType) {
        CtAnnotation<A> annotation;
        CtAnnotationType ctAnnotationType = (CtAnnotationType)annotationType.getDeclaration();
        boolean isRepeatable = false;
        if (ctAnnotationType != null) {
            boolean bl = isRepeatable = ctAnnotationType.getAnnotation(this.factory.Type().createReference(Repeatable.class)) != null;
        }
        if ((annotation = element.getAnnotation(annotationType)) == null || isRepeatable) {
            annotation = this.factory.Core().createAnnotation();
            annotation.setAnnotationType(this.factory.Core().clone(annotationType));
            element.addAnnotation(annotation);
        }
        return annotation;
    }
}

