/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.CtModelImpl;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtModuleImpl;

public class ModuleFactory
extends SubFactory {
    public ModuleFactory(Factory factory) {
        super(factory);
    }

    public CtUnnamedModule getUnnamedModule() {
        return (CtUnnamedModule)this.factory.getModel().getUnnamedModule();
    }

    public Collection<CtModule> getAllModules() {
        return this.getUnnamedModule().getAllModules();
    }

    public CtModule getModule(String moduleName) {
        return this.getUnnamedModule().getModule(moduleName);
    }

    public CtModule getOrCreate(String moduleName) {
        if (moduleName == null || moduleName.isEmpty()) {
            return this.getUnnamedModule();
        }
        CtModule ctModule = this.getUnnamedModule().getModule(moduleName);
        if (ctModule == null) {
            ctModule = (CtModule)this.factory.Core().createModule().setSimpleName(moduleName);
            ctModule.setRootPackage(new CtModelImpl.CtRootPackage());
            ctModule.setParent(this.getUnnamedModule());
        }
        return ctModule;
    }

    public CtModuleReference createReference(CtModule module) {
        return (CtModuleReference)this.factory.Core().createModuleReference().setSimpleName(module.getSimpleName());
    }

    public CtModuleRequirement createModuleRequirement(CtModuleReference moduleReference) {
        return this.factory.Core().createModuleRequirement().setModuleReference(moduleReference);
    }

    public CtPackageExport createPackageExport(CtPackageReference ctPackageReference) {
        return this.factory.Core().createPackageExport().setPackageReference(ctPackageReference);
    }

    public CtProvidedService createProvidedService(CtTypeReference typeReference) {
        return this.factory.Core().createProvidedService().setServiceType(typeReference);
    }

    public CtUsedService createUsedService(CtTypeReference typeReference) {
        return this.factory.Core().createUsedService().setServiceType(typeReference);
    }

    public static class CtUnnamedModule
    extends CtModuleImpl {
        final Set<CtModule> allModules = new HashSet<CtModule>();
        final CtElement parent = new CtElementImpl(){

            @Override
            public void accept(CtVisitor visitor) {
            }

            @Override
            public CtElement getParent() throws ParentNotInitializedException {
                return null;
            }

            @Override
            public Factory getFactory() {
                return this.getFactory();
            }
        };

        public CtUnnamedModule() {
            this.setSimpleName("unnamed module");
            this.addModule(this);
        }

        public boolean addModule(CtModule module) {
            return this.allModules.add(module);
        }

        public CtModule getModule(String name) {
            for (CtModule module : this.allModules) {
                if (!module.getSimpleName().equals(name)) continue;
                return module;
            }
            return null;
        }

        public Collection<CtModule> getAllModules() {
            return Collections.unmodifiableCollection(this.allModules);
        }

        @Override
        public <T extends CtNamedElement> T setSimpleName(String name) {
            if (name == null) {
                return (T)this;
            }
            if (name.equals("unnamed module")) {
                return super.setSimpleName(name);
            }
            return (T)this;
        }

        @Override
        public String toString() {
            return "unnamed module";
        }

        @Override
        public void accept(CtVisitor visitor) {
            visitor.visitCtModule(this);
        }

        @Override
        public CtElement getParent() {
            return this.parent;
        }
    }
}

