/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.meta.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.meta.impl.AbstractRoleHandler;
import spoon.reflect.path.CtRole;

abstract class ListHandler<T, V>
extends AbstractRoleHandler<T, List<V>, V> {
    protected ListHandler(CtRole role, Class<T> targetType, Class<?> valueClass) {
        super(role, targetType, valueClass);
    }

    @Override
    public ContainerKind getContainerKind() {
        return ContainerKind.LIST;
    }

    @Override
    protected List<V> castValue(Object value) {
        List list = (List)super.castValue(value);
        this.checkItemsClass(list);
        return list;
    }

    public <W, X> Collection<X> asCollection(W element) {
        return this.asList(element);
    }

    @Override
    public <W, X> List<X> asList(final W e) {
        return new AbstractList<X>(){
            T element;
            {
                this.element = ListHandler.this.castTarget(e);
            }

            @Override
            public Iterator<X> iterator() {
                return ListHandler.this.iterator(this.element);
            }

            @Override
            public int size() {
                return ListHandler.this.size(this.element);
            }

            @Override
            public X get(int index) {
                return ListHandler.this.get(this.element, index);
            }

            @Override
            public X set(int index, X value) {
                return ListHandler.this.set(this.element, index, ListHandler.this.castItemValue(value));
            }

            @Override
            public X remove(int index) {
                return ListHandler.this.remove(this.element, index);
            }

            @Override
            public boolean add(X value) {
                return ListHandler.this.add(this.element, ListHandler.this.castItemValue(value));
            }

            @Override
            public boolean remove(Object value) {
                return ListHandler.this.remove(this.element, value);
            }
        };
    }

    protected boolean remove(T element, Object value) {
        ArrayList values = new ArrayList((Collection)this.getValue(element));
        boolean ret = values.remove(value);
        if (ret) {
            this.setValue(element, values);
        }
        return ret;
    }

    protected V remove(T element, int index) {
        ArrayList values = new ArrayList((Collection)this.getValue(element));
        Object ret = values.remove(index);
        this.setValue(element, values);
        return (V)ret;
    }

    protected boolean add(T element, V value) {
        ArrayList<V> values = new ArrayList<V>((Collection)this.getValue(element));
        boolean ret = values.add(value);
        this.setValue(element, values);
        return ret;
    }

    protected V get(T element, int index) {
        return (V)((List)this.getValue(element)).get(index);
    }

    protected V set(T element, int index, V value) {
        ArrayList<V> values = new ArrayList<V>((Collection)this.getValue(element));
        V ret = values.set(index, value);
        this.setValue(element, values);
        return ret;
    }

    protected int size(T element) {
        return ((List)this.getValue(element)).size();
    }

    protected Iterator<V> iterator(T element) {
        return ((List)this.getValue(element)).iterator();
    }
}

