/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.meta.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.meta.RoleHandler;
import spoon.reflect.meta.impl.ModelRoleHandlers;
import spoon.reflect.path.CtRole;

public class RoleHandlerHelper {
    private static Map<Class<?>, List<RoleHandler>> roleHandlersByClass = new HashMap();
    private static final List<RoleHandler>[] roleHandlers = new List[CtRole.values().length];

    private RoleHandlerHelper() {
    }

    public static RoleHandler getRoleHandler(Class<? extends CtElement> targetClass, CtRole role) {
        RoleHandler rh = RoleHandlerHelper.getOptionalRoleHandler(targetClass, role);
        if (rh == null) {
            throw new SpoonException("The element of class " + targetClass + " does not have CtRole." + role.name());
        }
        return rh;
    }

    public static RoleHandler getOptionalRoleHandler(Class<? extends CtElement> targetClass, CtRole role) {
        List<RoleHandler> handlers = roleHandlers[role.ordinal()];
        for (RoleHandler ctRoleHandler : handlers) {
            if (!ctRoleHandler.getTargetType().isAssignableFrom(targetClass)) continue;
            return ctRoleHandler;
        }
        return null;
    }

    public static List<RoleHandler> getRoleHandlers(Class<? extends CtElement> targetClass) {
        List<RoleHandler> handlers = roleHandlersByClass.get(targetClass);
        if (handlers == null) {
            ArrayList<RoleHandler> modifiableHandlers = new ArrayList<RoleHandler>();
            for (CtRole role : CtRole.values()) {
                RoleHandler roleHandler = RoleHandlerHelper.getOptionalRoleHandler(targetClass, role);
                if (roleHandler == null) continue;
                modifiableHandlers.add(roleHandler);
            }
            handlers = Collections.unmodifiableList(modifiableHandlers);
            roleHandlersByClass.put(targetClass, handlers);
        }
        return handlers;
    }

    public static void forEachRoleHandler(Consumer<RoleHandler> consumer) {
        for (List<RoleHandler> list : roleHandlers) {
            for (RoleHandler roleHandler : list) {
                consumer.accept(roleHandler);
            }
        }
    }

    public static RoleHandler getRoleHandlerWrtParent(CtElement element) {
        if (!element.isParentInitialized()) {
            return null;
        }
        CtElement parent = element.getParent();
        CtRole roleInParent = element.getRoleInParent();
        if (roleInParent == null) {
            return null;
        }
        return RoleHandlerHelper.getRoleHandler(parent.getClass(), roleInParent);
    }

    static {
        for (int i2 = 0; i2 < roleHandlers.length; ++i2) {
            RoleHandlerHelper.roleHandlers[i2] = new ArrayList<RoleHandler>();
        }
        for (RoleHandler rh : ModelRoleHandlers.roleHandlers) {
            roleHandlers[rh.getRole().ordinal()].add(rh);
        }
        Comparator cmp = (a, b) -> a.getTargetType().isAssignableFrom(b.getTargetType()) ? 1 : -1;
        for (RoleHandler rh : ModelRoleHandlers.roleHandlers) {
            roleHandlers[rh.getRole().ordinal()].sort(cmp);
        }
    }
}

