/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.meta.impl;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.meta.impl.AbstractRoleHandler;
import spoon.reflect.path.CtRole;

abstract class SetHandler<T, V>
extends AbstractRoleHandler<T, Set<V>, V> {
    protected SetHandler(CtRole role, Class<T> targetType, Class<?> valueClass) {
        super(role, targetType, valueClass);
    }

    @Override
    public ContainerKind getContainerKind() {
        return ContainerKind.SET;
    }

    @Override
    protected Set<V> castValue(Object value) {
        Set set = (Set)super.castValue(value);
        this.checkItemsClass(set);
        return set;
    }

    public <W, X> Collection<X> asCollection(W element) {
        return this.asSet(element);
    }

    @Override
    public <W, X> Set<X> asSet(final W e) {
        return new AbstractSet<X>(){
            T element;
            {
                this.element = SetHandler.this.castTarget(e);
            }

            @Override
            public Iterator<X> iterator() {
                return SetHandler.this.iterator(this.element);
            }

            @Override
            public int size() {
                return SetHandler.this.size(this.element);
            }

            @Override
            public boolean contains(Object o) {
                return SetHandler.this.contains(this.element, o);
            }

            @Override
            public boolean add(X value) {
                return SetHandler.this.add(this.element, SetHandler.this.castItemValue(value));
            }

            @Override
            public boolean remove(Object value) {
                return SetHandler.this.remove(this.element, value);
            }
        };
    }

    protected boolean remove(T element, Object value) {
        HashSet values = new HashSet((Collection)this.getValue(element));
        boolean ret = values.remove(value);
        if (ret) {
            this.setValue(element, values);
        }
        return false;
    }

    protected boolean add(T element, V value) {
        HashSet<V> values = new HashSet<V>((Collection)this.getValue(element));
        boolean ret = values.add(value);
        if (ret) {
            this.setValue(element, values);
        }
        return ret;
    }

    protected boolean contains(T element, Object o) {
        return ((Set)this.getValue(element)).contains(o);
    }

    protected int size(T element) {
        return ((Set)this.getValue(element)).size();
    }

    protected Iterator<V> iterator(T element) {
        return ((Set)this.getValue(element)).iterator();
    }
}

