/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.meta.impl;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.meta.ContainerKind;
import spoon.reflect.meta.impl.AbstractRoleHandler;
import spoon.reflect.path.CtRole;

abstract class SingleHandler<T, U>
extends AbstractRoleHandler<T, U, U> {
    protected SingleHandler(CtRole role, Class<T> targetType, Class<?> valueClass) {
        super(role, targetType, valueClass);
    }

    @Override
    public ContainerKind getContainerKind() {
        return ContainerKind.SINGLE;
    }

    public <W, X> Collection<X> asCollection(W element) {
        return this.asList(element);
    }

    @Override
    public <W, X> List<X> asList(final W e) {
        return new AbstractList<X>(){
            T element;
            boolean hasValue;
            {
                this.element = SingleHandler.this.castTarget(e);
                this.hasValue = SingleHandler.this.getValue(this.element) != null;
            }

            @Override
            public int size() {
                return this.hasValue ? 1 : 0;
            }

            @Override
            public X get(int index) {
                if (index < 0 || index >= this.size()) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
                }
                return SingleHandler.this.getValue(this.element);
            }

            @Override
            public X set(int index, X value) {
                if (index < 0 || index >= this.size()) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
                }
                Object oldValue = this.get(0);
                SingleHandler.this.setValue(this.element, value);
                return oldValue;
            }

            @Override
            public boolean add(X value) {
                if (this.hasValue) {
                    throw new SpoonException("Single value attribute cannot have more then one value");
                }
                SingleHandler.this.setValue(this.element, value);
                this.hasValue = true;
                return true;
            }

            @Override
            public X remove(int index) {
                if (index < 0 || index >= this.size()) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
                }
                Object oldValue = this.get(0);
                if (oldValue != null) {
                    SingleHandler.this.setValue(this.element, null);
                }
                this.hasValue = false;
                return oldValue;
            }

            @Override
            public boolean remove(Object value) {
                if (!this.hasValue) {
                    return false;
                }
                Object oldValue = this.get(0);
                if (this.equals(oldValue, value)) {
                    if (oldValue != null) {
                        SingleHandler.this.setValue(this.element, null);
                    }
                    this.hasValue = false;
                    return true;
                }
                return false;
            }

            private boolean equals(Object v1, Object v2) {
                if (v1 == v2) {
                    return true;
                }
                if (v1 == null) {
                    return false;
                }
                return v1.equals(v2);
            }
        };
    }

    @Override
    public <W, X> Set<X> asSet(W element) {
        return Collections.singleton(this.getValue(element));
    }
}

