/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.impl.CtPathElement;
import spoon.reflect.visitor.CtScanner;

public abstract class AbstractPathElement<P extends CtElement, T extends CtElement>
implements CtPathElement<P, T> {
    public static final String ARGUMENT_START = "[";
    public static final String ARGUMENT_END = "]";
    public static final String ARGUMENT_NAME_SEPARATOR = "=";
    private Map<String, String> arguments = new TreeMap<String, String>();

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    @Override
    public <C extends CtPathElement<P, T>> C addArgument(String key, String value) {
        this.arguments.put(key, value);
        return (C)this;
    }

    Collection<CtElement> getChildren(CtElement element) {
        final ArrayList<CtElement> elements = new ArrayList<CtElement>();
        if (element != null) {
            element.accept(new CtScanner(){

                @Override
                public void scan(CtElement element) {
                    elements.add(element);
                }
            });
        }
        return elements;
    }

    protected String getParamString() {
        if (this.arguments.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(ARGUMENT_START);
        Iterator<Map.Entry<String, String>> iter = this.arguments.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> value = iter.next();
            builder.append(value.getKey() + ARGUMENT_NAME_SEPARATOR + value.getValue());
            if (!iter.hasNext()) continue;
            builder.append(";");
        }
        return builder.append(ARGUMENT_END).toString();
    }
}

