/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.path.impl.AbstractPathElement;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtInheritanceScanner;

public class CtNamedPathElement
extends AbstractPathElement<CtElement, CtElement> {
    public static final String STRING = ".";
    public static final String WILDCARD = "*";
    public static final String RECURSIVE_WILDCARD = "**";
    private final String pattern;
    private final Pattern rePattern;
    private static Set<String> failingPatterns = new HashSet<String>();

    public CtNamedPathElement(String pattern) {
        this(pattern, true);
    }

    public CtNamedPathElement(String pattern, boolean canBeRegexp) {
        this.pattern = pattern;
        Pattern p = null;
        if (canBeRegexp && this.canBeRegExpPattern(pattern) && !failingPatterns.contains(pattern)) {
            try {
                p = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                failingPatterns.add(pattern);
            }
        }
        this.rePattern = p;
    }

    private boolean canBeRegExpPattern(String str) {
        return !str.contains("()");
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return STRING + this.getPattern() + this.getParamString();
    }

    @Override
    public Collection<CtElement> getElements(Collection<CtElement> roots) {
        ArrayList<CtElement> results = new ArrayList<CtElement>();
        for (CtElement element : roots) {
            results.addAll(this.scanElements(this.getChildren(element)));
        }
        return results;
    }

    public Collection<CtElement> scanElements(Collection<? extends CtElement> roots) {
        NameScanner nameScanner = new NameScanner();
        if (RECURSIVE_WILDCARD.equals(this.pattern)) {
            nameScanner.recurse(roots);
        } else {
            nameScanner.scan(roots);
        }
        return nameScanner.getResults();
    }

    private static String getSignature(CtExecutable exec) {
        String sign = exec.getSignature();
        if (exec instanceof CtConstructor) {
            int idx = sign.indexOf(40);
            return sign.substring(idx);
        }
        return sign;
    }

    private class NameScanner
    extends CtInheritanceScanner {
        private Collection<CtElement> results = new LinkedList<CtElement>();

        NameScanner() {
        }

        @Override
        public void scanCtElement(CtElement e) {
            if (CtNamedPathElement.WILDCARD.equals(CtNamedPathElement.this.pattern) || CtNamedPathElement.RECURSIVE_WILDCARD.equals(CtNamedPathElement.this.pattern)) {
                this.results.add(e);
            } else if (e instanceof CtExecutable && this.matchPattern(CtNamedPathElement.getSignature((CtExecutable)e))) {
                this.results.add(e);
            } else if (e instanceof CtNamedElement && this.matchPattern(((CtNamedElement)e).getSimpleName())) {
                this.results.add(e);
            } else if (e instanceof CtReference && this.matchPattern(((CtReference)e).getSimpleName())) {
                this.results.add(e);
            }
        }

        private boolean matchPattern(String str) {
            if (str.equals(CtNamedPathElement.this.pattern)) {
                return true;
            }
            return CtNamedPathElement.this.rePattern != null && CtNamedPathElement.this.rePattern.matcher(str).matches();
        }

        private void recurse(Collection<? extends CtElement> elements) {
            this.scan(elements);
            for (CtElement ctElement : elements) {
                this.recurse(CtNamedPathElement.this.getChildren(ctElement));
            }
        }

        public Collection<CtElement> getResults() {
            return this.results;
        }
    }
}

