/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;

public class CacheBasedConflictFinder {
    CtType<?> type;
    CtTypeReference<?> typeRef;
    Set<String> cachedFieldNames;
    Set<String> cachedNestedTypeNames;

    CacheBasedConflictFinder(CtType<?> p_type) {
        this.type = p_type;
        this.typeRef = this.type.getReference();
    }

    public boolean hasFieldConflict(String name) {
        if (this.cachedFieldNames == null) {
            Collection<CtFieldReference<?>> allFields = this.type.getAllFields();
            this.cachedFieldNames = new HashSet<String>(allFields.size());
            for (CtFieldReference<?> field : allFields) {
                this.cachedFieldNames.add(field.getSimpleName());
            }
        }
        return this.cachedFieldNames.contains(name);
    }

    public boolean hasNestedTypeConflict(String name) {
        if (this.cachedNestedTypeNames == null) {
            Set<CtType<?>> allTypes = this.type.getNestedTypes();
            this.cachedNestedTypeNames = new HashSet<String>(allTypes.size());
            for (CtType ctType : allTypes) {
                this.cachedNestedTypeNames.add(ctType.getSimpleName());
            }
        }
        return this.cachedNestedTypeNames.contains(name);
    }

    public String getSimpleName() {
        return this.typeRef.getSimpleName();
    }

    public CtPackageReference getPackage() {
        return this.typeRef.getPackage();
    }
}

