/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.visitor.PrinterHelper;
import spoon.support.Internal;

@Internal
public class CommentHelper {
    private static final Pattern LINE_SEPARATORS_RE = Pattern.compile("\\n\\r|\\n|\\r");

    private CommentHelper() {
    }

    public static String printComment(CtComment comment) {
        PrinterHelper ph = new PrinterHelper(comment.getFactory().getEnvironment());
        CommentHelper.printCommentContent(ph, comment, s -> s);
        return ph.toString();
    }

    static void printComment(PrinterHelper printer, CtComment comment) {
        CtComment.CommentType commentType = comment.getCommentType();
        String content = comment.getContent();
        switch (commentType) {
            case FILE: {
                printer.write("/**").writeln();
                break;
            }
            case JAVADOC: {
                printer.write("/**").writeln();
                break;
            }
            case INLINE: {
                printer.write("// ");
                break;
            }
            case BLOCK: {
                printer.write("/* ");
            }
        }
        switch (commentType) {
            case INLINE: {
                printer.write(content);
                break;
            }
            default: {
                CommentHelper.printCommentContent(printer, comment, s -> (" * " + s).replaceAll(" *$", ""));
            }
        }
        switch (commentType) {
            case BLOCK: {
                printer.write(" */");
                break;
            }
            case FILE: {
                printer.write(" */");
                break;
            }
            case JAVADOC: {
                printer.write(" */");
            }
        }
    }

    static void printCommentContent(PrinterHelper printer, CtComment comment, Function<String, String> transfo) {
        String[] lines;
        CtComment.CommentType commentType = comment.getCommentType();
        String content = comment.getContent();
        for (String com : lines = LINE_SEPARATORS_RE.split(content)) {
            if (commentType == CtComment.CommentType.BLOCK) {
                printer.write(com);
                if (lines.length <= 1) continue;
                printer.write("\n");
                continue;
            }
            printer.write(transfo.apply(com)).writeln();
        }
        if (comment instanceof CtJavaDoc) {
            Object tags = null;
            List<CtJavaDocTag> javaDocTags = ((CtJavaDoc)comment).getTags();
            if (javaDocTags != null && !javaDocTags.isEmpty()) {
                printer.write(transfo.apply("")).writeln();
                for (CtJavaDocTag docTag : javaDocTags) {
                    CommentHelper.printJavaDocTag(printer, docTag, transfo);
                }
            }
        }
    }

    static void printJavaDocTag(PrinterHelper printer, CtJavaDocTag docTag, Function<String, String> transfo) {
        printer.write(transfo.apply("@"));
        printer.write(CtJavaDocTag.TagType.UNKNOWN.getName().equalsIgnoreCase(docTag.getType().name()) ? docTag.getRealName() : docTag.getType().getName().toLowerCase());
        printer.write(" ");
        if (docTag.getType().hasParam()) {
            printer.write(docTag.getParam()).writeln();
        }
        String[] tagLines = LINE_SEPARATORS_RE.split(docTag.getContent());
        for (int i2 = 0; i2 < tagLines.length; ++i2) {
            String com = tagLines[i2];
            if (docTag.getType().hasParam()) {
                printer.write(transfo.apply("\t\t"));
            }
            printer.write(com.trim()).writeln();
        }
    }
}

