/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtAbstractBiScanner;

public class CtBiScannerDefault
extends CtAbstractBiScanner {
    protected Deque<CtElement> stack = new ArrayDeque<CtElement>();

    protected void enter(CtElement e) {
    }

    protected void exit(CtElement e) {
    }

    @Override
    public void biScan(CtElement element, CtElement other) {
        if (other == null) {
            return;
        }
        this.stack.push(other);
        try {
            element.accept(this);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void biScan(CtRole role, CtElement element, CtElement other) {
        this.biScan(element, other);
    }

    protected void biScan(CtRole role, Collection<? extends CtElement> elements, Collection<? extends CtElement> others) {
        Iterator<? extends CtElement> firstIt = elements.iterator();
        Iterator<? extends CtElement> secondIt = others.iterator();
        while (firstIt.hasNext() && secondIt.hasNext()) {
            this.biScan(role, firstIt.next(), secondIt.next());
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        CtAnnotation other = (CtAnnotation)this.stack.peek();
        this.enter(annotation);
        this.biScan(CtRole.TYPE, annotation.getType(), other.getType());
        this.biScan(CtRole.COMMENT, annotation.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION_TYPE, annotation.getAnnotationType(), other.getAnnotationType());
        this.biScan(CtRole.ANNOTATION, annotation.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.VALUE, annotation.getValues().values(), other.getValues().values());
        this.exit(annotation);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        CtAnnotationType other = (CtAnnotationType)this.stack.peek();
        this.enter(annotationType);
        this.biScan(CtRole.ANNOTATION, annotationType.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE_MEMBER, annotationType.getTypeMembers(), other.getTypeMembers());
        this.biScan(CtRole.COMMENT, annotationType.getComments(), other.getComments());
        this.exit(annotationType);
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
        CtAnonymousExecutable other = (CtAnonymousExecutable)this.stack.peek();
        this.enter(anonymousExec);
        this.biScan(CtRole.ANNOTATION, anonymousExec.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.BODY, anonymousExec.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, anonymousExec.getComments(), other.getComments());
        this.exit(anonymousExec);
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        CtArrayRead other = (CtArrayRead)this.stack.peek();
        this.enter(arrayRead);
        this.biScan(CtRole.ANNOTATION, arrayRead.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, arrayRead.getType(), other.getType());
        this.biScan(CtRole.CAST, arrayRead.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)arrayRead.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.EXPRESSION, arrayRead.getIndexExpression(), other.getIndexExpression());
        this.biScan(CtRole.COMMENT, arrayRead.getComments(), other.getComments());
        this.exit(arrayRead);
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        CtArrayWrite other = (CtArrayWrite)this.stack.peek();
        this.enter(arrayWrite);
        this.biScan(CtRole.ANNOTATION, arrayWrite.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, arrayWrite.getType(), other.getType());
        this.biScan(CtRole.CAST, arrayWrite.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)arrayWrite.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.EXPRESSION, arrayWrite.getIndexExpression(), other.getIndexExpression());
        this.biScan(CtRole.COMMENT, arrayWrite.getComments(), other.getComments());
        this.exit(arrayWrite);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        CtArrayTypeReference other = (CtArrayTypeReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.PACKAGE_REF, reference.getPackage(), other.getPackage());
        this.biScan(CtRole.DECLARING_TYPE, reference.getDeclaringType(), other.getDeclaringType());
        this.biScan(CtRole.TYPE, reference.getComponentType(), other.getComponentType());
        this.biScan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments(), other.getActualTypeArguments());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        CtAssert other = (CtAssert)this.stack.peek();
        this.enter(asserted);
        this.biScan(CtRole.ANNOTATION, asserted.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CONDITION, asserted.getAssertExpression(), other.getAssertExpression());
        this.biScan(CtRole.EXPRESSION, asserted.getExpression(), other.getExpression());
        this.biScan(CtRole.COMMENT, asserted.getComments(), other.getComments());
        this.exit(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        CtAssignment other = (CtAssignment)this.stack.peek();
        this.enter(assignement);
        this.biScan(CtRole.ANNOTATION, assignement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, assignement.getType(), other.getType());
        this.biScan(CtRole.CAST, assignement.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.ASSIGNED, assignement.getAssigned(), other.getAssigned());
        this.biScan(CtRole.ASSIGNMENT, assignement.getAssignment(), other.getAssignment());
        this.biScan(CtRole.COMMENT, assignement.getComments(), other.getComments());
        this.exit(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        CtBinaryOperator other = (CtBinaryOperator)this.stack.peek();
        this.enter(operator);
        this.biScan(CtRole.ANNOTATION, operator.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, operator.getType(), other.getType());
        this.biScan(CtRole.CAST, operator.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.LEFT_OPERAND, operator.getLeftHandOperand(), other.getLeftHandOperand());
        this.biScan(CtRole.RIGHT_OPERAND, operator.getRightHandOperand(), other.getRightHandOperand());
        this.biScan(CtRole.COMMENT, operator.getComments(), other.getComments());
        this.exit(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        CtBlock other = (CtBlock)this.stack.peek();
        this.enter(block);
        this.biScan(CtRole.ANNOTATION, block.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.STATEMENT, block.getStatements(), other.getStatements());
        this.biScan(CtRole.COMMENT, block.getComments(), other.getComments());
        this.exit(block);
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        CtBreak other = (CtBreak)this.stack.peek();
        this.enter(breakStatement);
        this.biScan(CtRole.ANNOTATION, breakStatement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.COMMENT, breakStatement.getComments(), other.getComments());
        this.exit(breakStatement);
    }

    @Override
    public <S> void visitCtCase(CtCase<S> caseStatement) {
        CtCase other = (CtCase)this.stack.peek();
        this.enter(caseStatement);
        this.biScan(CtRole.ANNOTATION, caseStatement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, caseStatement.getCaseExpressions(), other.getCaseExpressions());
        this.biScan(CtRole.STATEMENT, caseStatement.getStatements(), other.getStatements());
        this.biScan(CtRole.COMMENT, caseStatement.getComments(), other.getComments());
        this.exit(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        CtCatch other = (CtCatch)this.stack.peek();
        this.enter(catchBlock);
        this.biScan(CtRole.ANNOTATION, catchBlock.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.PARAMETER, catchBlock.getParameter(), other.getParameter());
        this.biScan(CtRole.BODY, catchBlock.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, catchBlock.getComments(), other.getComments());
        this.exit(catchBlock);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        CtClass other = (CtClass)this.stack.peek();
        this.enter(ctClass);
        this.biScan(CtRole.ANNOTATION, ctClass.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.SUPER_TYPE, ctClass.getSuperclass(), other.getSuperclass());
        this.biScan(CtRole.INTERFACE, ctClass.getSuperInterfaces(), other.getSuperInterfaces());
        this.biScan(CtRole.TYPE_PARAMETER, ctClass.getFormalCtTypeParameters(), other.getFormalCtTypeParameters());
        this.biScan(CtRole.TYPE_MEMBER, ctClass.getTypeMembers(), other.getTypeMembers());
        this.biScan(CtRole.COMMENT, ctClass.getComments(), other.getComments());
        this.exit(ctClass);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        CtTypeParameter other = (CtTypeParameter)this.stack.peek();
        this.enter(typeParameter);
        this.biScan(CtRole.ANNOTATION, typeParameter.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.SUPER_TYPE, typeParameter.getSuperclass(), other.getSuperclass());
        this.biScan(CtRole.COMMENT, typeParameter.getComments(), other.getComments());
        this.exit(typeParameter);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        CtConditional other = (CtConditional)this.stack.peek();
        this.enter(conditional);
        this.biScan(CtRole.TYPE, conditional.getType(), other.getType());
        this.biScan(CtRole.ANNOTATION, conditional.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CONDITION, conditional.getCondition(), other.getCondition());
        this.biScan(CtRole.THEN, conditional.getThenExpression(), other.getThenExpression());
        this.biScan(CtRole.ELSE, conditional.getElseExpression(), other.getElseExpression());
        this.biScan(CtRole.COMMENT, conditional.getComments(), other.getComments());
        this.biScan(CtRole.CAST, conditional.getTypeCasts(), other.getTypeCasts());
        this.exit(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        CtConstructor other = (CtConstructor)this.stack.peek();
        this.enter(c);
        this.biScan(CtRole.ANNOTATION, c.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.PARAMETER, c.getParameters(), other.getParameters());
        this.biScan(CtRole.THROWN, c.getThrownTypes(), other.getThrownTypes());
        this.biScan(CtRole.TYPE_PARAMETER, c.getFormalCtTypeParameters(), other.getFormalCtTypeParameters());
        this.biScan(CtRole.BODY, c.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, c.getComments(), other.getComments());
        this.exit(c);
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        CtContinue other = (CtContinue)this.stack.peek();
        this.enter(continueStatement);
        this.biScan(CtRole.ANNOTATION, continueStatement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.COMMENT, continueStatement.getComments(), other.getComments());
        this.exit(continueStatement);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        CtDo other = (CtDo)this.stack.peek();
        this.enter(doLoop);
        this.biScan(CtRole.ANNOTATION, doLoop.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, doLoop.getLoopingExpression(), other.getLoopingExpression());
        this.biScan(CtRole.BODY, doLoop.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, doLoop.getComments(), other.getComments());
        this.exit(doLoop);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        CtEnum other = (CtEnum)this.stack.peek();
        this.enter(ctEnum);
        this.biScan(CtRole.ANNOTATION, ctEnum.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.INTERFACE, ctEnum.getSuperInterfaces(), other.getSuperInterfaces());
        this.biScan(CtRole.TYPE_MEMBER, ctEnum.getTypeMembers(), other.getTypeMembers());
        this.biScan(CtRole.VALUE, ctEnum.getEnumValues(), other.getEnumValues());
        this.biScan(CtRole.COMMENT, ctEnum.getComments(), other.getComments());
        this.exit(ctEnum);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        CtExecutableReference other = (CtExecutableReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.DECLARING_TYPE, reference.getDeclaringType(), other.getDeclaringType());
        this.biScan(CtRole.TYPE, reference.getType(), other.getType());
        this.biScan(CtRole.ARGUMENT_TYPE, reference.getParameters(), other.getParameters());
        this.biScan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments(), other.getActualTypeArguments());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.COMMENT, reference.getComments(), other.getComments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        CtField other = (CtField)this.stack.peek();
        this.enter(f);
        this.biScan(CtRole.ANNOTATION, f.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, f.getType(), other.getType());
        this.biScan(CtRole.DEFAULT_EXPRESSION, f.getDefaultExpression(), other.getDefaultExpression());
        this.biScan(CtRole.COMMENT, f.getComments(), other.getComments());
        this.exit(f);
    }

    @Override
    public <T> void visitCtEnumValue(CtEnumValue<T> enumValue) {
        CtEnumValue other = (CtEnumValue)this.stack.peek();
        this.enter(enumValue);
        this.biScan(CtRole.ANNOTATION, enumValue.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, enumValue.getType(), other.getType());
        this.biScan(CtRole.DEFAULT_EXPRESSION, enumValue.getDefaultExpression(), other.getDefaultExpression());
        this.biScan(CtRole.COMMENT, enumValue.getComments(), other.getComments());
        this.exit(enumValue);
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        CtThisAccess other = (CtThisAccess)this.stack.peek();
        this.enter(thisAccess);
        this.biScan(CtRole.COMMENT, thisAccess.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, thisAccess.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, thisAccess.getType(), other.getType());
        this.biScan(CtRole.CAST, thisAccess.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)thisAccess.getTarget(), (CtElement)other.getTarget());
        this.exit(thisAccess);
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        CtAnnotationFieldAccess other = (CtAnnotationFieldAccess)this.stack.peek();
        this.enter(annotationFieldAccess);
        this.biScan(CtRole.COMMENT, annotationFieldAccess.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, annotationFieldAccess.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, annotationFieldAccess.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)annotationFieldAccess.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.VARIABLE, annotationFieldAccess.getVariable(), other.getVariable());
        this.exit(annotationFieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        CtFieldReference other = (CtFieldReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.DECLARING_TYPE, reference.getDeclaringType(), other.getDeclaringType());
        this.biScan(CtRole.TYPE, reference.getType(), other.getType());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.exit(reference);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        CtFor other = (CtFor)this.stack.peek();
        this.enter(forLoop);
        this.biScan(CtRole.ANNOTATION, forLoop.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.FOR_INIT, forLoop.getForInit(), other.getForInit());
        this.biScan(CtRole.EXPRESSION, forLoop.getExpression(), other.getExpression());
        this.biScan(CtRole.FOR_UPDATE, forLoop.getForUpdate(), other.getForUpdate());
        this.biScan(CtRole.BODY, forLoop.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, forLoop.getComments(), other.getComments());
        this.exit(forLoop);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        CtForEach other = (CtForEach)this.stack.peek();
        this.enter(foreach);
        this.biScan(CtRole.ANNOTATION, foreach.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.FOREACH_VARIABLE, foreach.getVariable(), other.getVariable());
        this.biScan(CtRole.EXPRESSION, foreach.getExpression(), other.getExpression());
        this.biScan(CtRole.BODY, foreach.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, foreach.getComments(), other.getComments());
        this.exit(foreach);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        CtIf other = (CtIf)this.stack.peek();
        this.enter(ifElement);
        this.biScan(CtRole.ANNOTATION, ifElement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CONDITION, ifElement.getCondition(), other.getCondition());
        this.biScan(CtRole.THEN, (CtElement)ifElement.getThenStatement(), (CtElement)other.getThenStatement());
        this.biScan(CtRole.ELSE, (CtElement)ifElement.getElseStatement(), (CtElement)other.getElseStatement());
        this.biScan(CtRole.COMMENT, ifElement.getComments(), other.getComments());
        this.exit(ifElement);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        CtInterface other = (CtInterface)this.stack.peek();
        this.enter(intrface);
        this.biScan(CtRole.ANNOTATION, intrface.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.INTERFACE, intrface.getSuperInterfaces(), other.getSuperInterfaces());
        this.biScan(CtRole.TYPE_PARAMETER, intrface.getFormalCtTypeParameters(), other.getFormalCtTypeParameters());
        this.biScan(CtRole.TYPE_MEMBER, intrface.getTypeMembers(), other.getTypeMembers());
        this.biScan(CtRole.COMMENT, intrface.getComments(), other.getComments());
        this.exit(intrface);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        CtInvocation other = (CtInvocation)this.stack.peek();
        this.enter(invocation);
        this.biScan(CtRole.ANNOTATION, invocation.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, invocation.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)invocation.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.EXECUTABLE_REF, invocation.getExecutable(), other.getExecutable());
        this.biScan(CtRole.ARGUMENT, invocation.getArguments(), other.getArguments());
        this.biScan(CtRole.COMMENT, invocation.getComments(), other.getComments());
        this.exit(invocation);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        CtLiteral other = (CtLiteral)this.stack.peek();
        this.enter(literal);
        this.biScan(CtRole.ANNOTATION, literal.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, literal.getType(), other.getType());
        this.biScan(CtRole.CAST, literal.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.COMMENT, literal.getComments(), other.getComments());
        this.exit(literal);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        CtLocalVariable other = (CtLocalVariable)this.stack.peek();
        this.enter(localVariable);
        this.biScan(CtRole.ANNOTATION, localVariable.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, localVariable.getType(), other.getType());
        this.biScan(CtRole.DEFAULT_EXPRESSION, localVariable.getDefaultExpression(), other.getDefaultExpression());
        this.biScan(CtRole.COMMENT, localVariable.getComments(), other.getComments());
        this.exit(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        CtLocalVariableReference other = (CtLocalVariableReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.TYPE, reference.getType(), other.getType());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        CtCatchVariable other = (CtCatchVariable)this.stack.peek();
        this.enter(catchVariable);
        this.biScan(CtRole.COMMENT, catchVariable.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, catchVariable.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.MULTI_TYPE, catchVariable.getMultiTypes(), other.getMultiTypes());
        this.exit(catchVariable);
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        CtCatchVariableReference other = (CtCatchVariableReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.TYPE, reference.getType(), other.getType());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        CtMethod other = (CtMethod)this.stack.peek();
        this.enter(m);
        this.biScan(CtRole.ANNOTATION, m.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE_PARAMETER, m.getFormalCtTypeParameters(), other.getFormalCtTypeParameters());
        this.biScan(CtRole.TYPE, m.getType(), other.getType());
        this.biScan(CtRole.PARAMETER, m.getParameters(), other.getParameters());
        this.biScan(CtRole.THROWN, m.getThrownTypes(), other.getThrownTypes());
        this.biScan(CtRole.BODY, m.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, m.getComments(), other.getComments());
        this.exit(m);
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        CtAnnotationMethod other = (CtAnnotationMethod)this.stack.peek();
        this.enter(annotationMethod);
        this.biScan(CtRole.ANNOTATION, annotationMethod.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, annotationMethod.getType(), other.getType());
        this.biScan(CtRole.DEFAULT_EXPRESSION, annotationMethod.getDefaultExpression(), other.getDefaultExpression());
        this.biScan(CtRole.COMMENT, annotationMethod.getComments(), other.getComments());
        this.exit(annotationMethod);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        CtNewArray other = (CtNewArray)this.stack.peek();
        this.enter(newArray);
        this.biScan(CtRole.ANNOTATION, newArray.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, newArray.getType(), other.getType());
        this.biScan(CtRole.CAST, newArray.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.EXPRESSION, newArray.getElements(), other.getElements());
        this.biScan(CtRole.DIMENSION, newArray.getDimensionExpressions(), other.getDimensionExpressions());
        this.biScan(CtRole.COMMENT, newArray.getComments(), other.getComments());
        this.exit(newArray);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        CtConstructorCall other = (CtConstructorCall)this.stack.peek();
        this.enter(ctConstructorCall);
        this.biScan(CtRole.ANNOTATION, ctConstructorCall.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, ctConstructorCall.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.EXECUTABLE_REF, ctConstructorCall.getExecutable(), other.getExecutable());
        this.biScan(CtRole.TARGET, (CtElement)ctConstructorCall.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.ARGUMENT, ctConstructorCall.getArguments(), other.getArguments());
        this.biScan(CtRole.COMMENT, ctConstructorCall.getComments(), other.getComments());
        this.exit(ctConstructorCall);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        CtNewClass other = (CtNewClass)this.stack.peek();
        this.enter(newClass);
        this.biScan(CtRole.ANNOTATION, newClass.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, newClass.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.EXECUTABLE_REF, newClass.getExecutable(), other.getExecutable());
        this.biScan(CtRole.TARGET, (CtElement)newClass.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.ARGUMENT, newClass.getArguments(), other.getArguments());
        this.biScan(CtRole.NESTED_TYPE, newClass.getAnonymousClass(), other.getAnonymousClass());
        this.biScan(CtRole.COMMENT, newClass.getComments(), other.getComments());
        this.exit(newClass);
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        CtLambda other = (CtLambda)this.stack.peek();
        this.enter(lambda);
        this.biScan(CtRole.ANNOTATION, lambda.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, lambda.getType(), other.getType());
        this.biScan(CtRole.CAST, lambda.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.PARAMETER, lambda.getParameters(), other.getParameters());
        this.biScan(CtRole.BODY, lambda.getBody(), other.getBody());
        this.biScan(CtRole.EXPRESSION, lambda.getExpression(), other.getExpression());
        this.biScan(CtRole.COMMENT, lambda.getComments(), other.getComments());
        this.exit(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        CtExecutableReferenceExpression other = (CtExecutableReferenceExpression)this.stack.peek();
        this.enter(expression);
        this.biScan(CtRole.COMMENT, expression.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, expression.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, expression.getType(), other.getType());
        this.biScan(CtRole.CAST, expression.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.EXECUTABLE_REF, expression.getExecutable(), other.getExecutable());
        this.biScan(CtRole.TARGET, (CtElement)expression.getTarget(), (CtElement)other.getTarget());
        this.exit(expression);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        CtOperatorAssignment other = (CtOperatorAssignment)this.stack.peek();
        this.enter(assignment);
        this.biScan(CtRole.ANNOTATION, assignment.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, assignment.getType(), other.getType());
        this.biScan(CtRole.CAST, assignment.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.ASSIGNED, assignment.getAssigned(), other.getAssigned());
        this.biScan(CtRole.ASSIGNMENT, assignment.getAssignment(), other.getAssignment());
        this.biScan(CtRole.COMMENT, assignment.getComments(), other.getComments());
        this.exit(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        CtPackage other = (CtPackage)this.stack.peek();
        this.enter(ctPackage);
        this.biScan(CtRole.ANNOTATION, ctPackage.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.SUB_PACKAGE, ctPackage.getPackages(), other.getPackages());
        this.biScan(CtRole.CONTAINED_TYPE, ctPackage.getTypes(), other.getTypes());
        this.biScan(CtRole.COMMENT, ctPackage.getComments(), other.getComments());
        this.exit(ctPackage);
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        CtPackageReference other = (CtPackageReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        CtParameter other = (CtParameter)this.stack.peek();
        this.enter(parameter);
        this.biScan(CtRole.ANNOTATION, parameter.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, parameter.getType(), other.getType());
        this.biScan(CtRole.COMMENT, parameter.getComments(), other.getComments());
        this.exit(parameter);
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        CtParameterReference other = (CtParameterReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.TYPE, reference.getType(), other.getType());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        CtReturn other = (CtReturn)this.stack.peek();
        this.enter(returnStatement);
        this.biScan(CtRole.ANNOTATION, returnStatement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, returnStatement.getReturnedExpression(), other.getReturnedExpression());
        this.biScan(CtRole.COMMENT, returnStatement.getComments(), other.getComments());
        this.exit(returnStatement);
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        CtStatementList other = (CtStatementList)this.stack.peek();
        this.enter(statements);
        this.biScan(CtRole.ANNOTATION, statements.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.STATEMENT, statements.getStatements(), other.getStatements());
        this.biScan(CtRole.COMMENT, statements.getComments(), other.getComments());
        this.exit(statements);
    }

    @Override
    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        CtSwitch other = (CtSwitch)this.stack.peek();
        this.enter(switchStatement);
        this.biScan(CtRole.ANNOTATION, switchStatement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, switchStatement.getSelector(), other.getSelector());
        this.biScan(CtRole.CASE, switchStatement.getCases(), other.getCases());
        this.biScan(CtRole.COMMENT, switchStatement.getComments(), other.getComments());
        this.exit(switchStatement);
    }

    @Override
    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
        CtSwitchExpression other = (CtSwitchExpression)this.stack.peek();
        this.enter(switchExpression);
        this.biScan(CtRole.ANNOTATION, switchExpression.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, switchExpression.getSelector(), other.getSelector());
        this.biScan(CtRole.CASE, switchExpression.getCases(), other.getCases());
        this.biScan(CtRole.COMMENT, switchExpression.getComments(), other.getComments());
        this.biScan(CtRole.TYPE, switchExpression.getType(), other.getType());
        this.biScan(CtRole.CAST, switchExpression.getTypeCasts(), other.getTypeCasts());
        this.exit(switchExpression);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        CtSynchronized other = (CtSynchronized)this.stack.peek();
        this.enter(synchro);
        this.biScan(CtRole.ANNOTATION, synchro.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, synchro.getExpression(), other.getExpression());
        this.biScan(CtRole.BODY, synchro.getBlock(), other.getBlock());
        this.biScan(CtRole.COMMENT, synchro.getComments(), other.getComments());
        this.exit(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        CtThrow other = (CtThrow)this.stack.peek();
        this.enter(throwStatement);
        this.biScan(CtRole.ANNOTATION, throwStatement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, throwStatement.getThrownExpression(), other.getThrownExpression());
        this.biScan(CtRole.COMMENT, throwStatement.getComments(), other.getComments());
        this.exit(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        CtTry other = (CtTry)this.stack.peek();
        this.enter(tryBlock);
        this.biScan(CtRole.ANNOTATION, tryBlock.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.BODY, tryBlock.getBody(), other.getBody());
        this.biScan(CtRole.CATCH, tryBlock.getCatchers(), other.getCatchers());
        this.biScan(CtRole.FINALIZER, tryBlock.getFinalizer(), other.getFinalizer());
        this.biScan(CtRole.COMMENT, tryBlock.getComments(), other.getComments());
        this.exit(tryBlock);
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        CtTryWithResource other = (CtTryWithResource)this.stack.peek();
        this.enter(tryWithResource);
        this.biScan(CtRole.ANNOTATION, tryWithResource.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TRY_RESOURCE, tryWithResource.getResources(), other.getResources());
        this.biScan(CtRole.BODY, tryWithResource.getBody(), other.getBody());
        this.biScan(CtRole.CATCH, tryWithResource.getCatchers(), other.getCatchers());
        this.biScan(CtRole.FINALIZER, tryWithResource.getFinalizer(), other.getFinalizer());
        this.biScan(CtRole.COMMENT, tryWithResource.getComments(), other.getComments());
        this.exit(tryWithResource);
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        CtTypeParameterReference other = (CtTypeParameterReference)this.stack.peek();
        this.enter(ref);
        this.biScan(CtRole.PACKAGE_REF, ref.getPackage(), other.getPackage());
        this.biScan(CtRole.DECLARING_TYPE, ref.getDeclaringType(), other.getDeclaringType());
        this.biScan(CtRole.ANNOTATION, ref.getAnnotations(), other.getAnnotations());
        this.exit(ref);
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
        CtWildcardReference other = (CtWildcardReference)this.stack.peek();
        this.enter(wildcardReference);
        this.biScan(CtRole.PACKAGE_REF, wildcardReference.getPackage(), other.getPackage());
        this.biScan(CtRole.DECLARING_TYPE, wildcardReference.getDeclaringType(), other.getDeclaringType());
        this.biScan(CtRole.ANNOTATION, wildcardReference.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.BOUNDING_TYPE, wildcardReference.getBoundingType(), other.getBoundingType());
        this.exit(wildcardReference);
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        CtIntersectionTypeReference other = (CtIntersectionTypeReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.PACKAGE_REF, reference.getPackage(), other.getPackage());
        this.biScan(CtRole.DECLARING_TYPE, reference.getDeclaringType(), other.getDeclaringType());
        this.biScan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments(), other.getActualTypeArguments());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.BOUND, reference.getBounds(), other.getBounds());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        CtTypeReference other = (CtTypeReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.PACKAGE_REF, reference.getPackage(), other.getPackage());
        this.biScan(CtRole.DECLARING_TYPE, reference.getDeclaringType(), other.getDeclaringType());
        this.biScan(CtRole.TYPE_ARGUMENT, reference.getActualTypeArguments(), other.getActualTypeArguments());
        this.biScan(CtRole.ANNOTATION, reference.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.COMMENT, reference.getComments(), other.getComments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        CtTypeAccess other = (CtTypeAccess)this.stack.peek();
        this.enter(typeAccess);
        this.biScan(CtRole.ANNOTATION, typeAccess.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, typeAccess.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.ACCESSED_TYPE, typeAccess.getAccessedType(), other.getAccessedType());
        this.biScan(CtRole.COMMENT, typeAccess.getComments(), other.getComments());
        this.exit(typeAccess);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        CtUnaryOperator other = (CtUnaryOperator)this.stack.peek();
        this.enter(operator);
        this.biScan(CtRole.ANNOTATION, operator.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.TYPE, operator.getType(), other.getType());
        this.biScan(CtRole.CAST, operator.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.EXPRESSION, operator.getOperand(), other.getOperand());
        this.biScan(CtRole.COMMENT, operator.getComments(), other.getComments());
        this.exit(operator);
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        CtVariableRead other = (CtVariableRead)this.stack.peek();
        this.enter(variableRead);
        this.biScan(CtRole.ANNOTATION, variableRead.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, variableRead.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.VARIABLE, variableRead.getVariable(), other.getVariable());
        this.biScan(CtRole.COMMENT, variableRead.getComments(), other.getComments());
        this.exit(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        CtVariableWrite other = (CtVariableWrite)this.stack.peek();
        this.enter(variableWrite);
        this.biScan(CtRole.ANNOTATION, variableWrite.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, variableWrite.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.VARIABLE, variableWrite.getVariable(), other.getVariable());
        this.biScan(CtRole.COMMENT, variableWrite.getComments(), other.getComments());
        this.exit(variableWrite);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        CtWhile other = (CtWhile)this.stack.peek();
        this.enter(whileLoop);
        this.biScan(CtRole.ANNOTATION, whileLoop.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, whileLoop.getLoopingExpression(), other.getLoopingExpression());
        this.biScan(CtRole.BODY, whileLoop.getBody(), other.getBody());
        this.biScan(CtRole.COMMENT, whileLoop.getComments(), other.getComments());
        this.exit(whileLoop);
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        CtCodeSnippetExpression other = (CtCodeSnippetExpression)this.stack.peek();
        this.enter(expression);
        this.biScan(CtRole.TYPE, expression.getType(), other.getType());
        this.biScan(CtRole.COMMENT, expression.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, expression.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, expression.getTypeCasts(), other.getTypeCasts());
        this.exit(expression);
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        CtCodeSnippetStatement other = (CtCodeSnippetStatement)this.stack.peek();
        this.enter(statement);
        this.biScan(CtRole.COMMENT, statement.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, statement.getAnnotations(), other.getAnnotations());
        this.exit(statement);
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        CtUnboundVariableReference other = (CtUnboundVariableReference)this.stack.peek();
        this.enter(reference);
        this.biScan(CtRole.TYPE, reference.getType(), other.getType());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        CtFieldRead other = (CtFieldRead)this.stack.peek();
        this.enter(fieldRead);
        this.biScan(CtRole.ANNOTATION, fieldRead.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, fieldRead.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)fieldRead.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.VARIABLE, fieldRead.getVariable(), other.getVariable());
        this.biScan(CtRole.COMMENT, fieldRead.getComments(), other.getComments());
        this.exit(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        CtFieldWrite other = (CtFieldWrite)this.stack.peek();
        this.enter(fieldWrite);
        this.biScan(CtRole.ANNOTATION, fieldWrite.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, fieldWrite.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)fieldWrite.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.VARIABLE, fieldWrite.getVariable(), other.getVariable());
        this.biScan(CtRole.COMMENT, fieldWrite.getComments(), other.getComments());
        this.exit(fieldWrite);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        CtSuperAccess other = (CtSuperAccess)this.stack.peek();
        this.enter(f);
        this.biScan(CtRole.COMMENT, f.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, f.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.CAST, f.getTypeCasts(), other.getTypeCasts());
        this.biScan(CtRole.TARGET, (CtElement)f.getTarget(), (CtElement)other.getTarget());
        this.biScan(CtRole.VARIABLE, f.getVariable(), other.getVariable());
        this.exit(f);
    }

    @Override
    public void visitCtComment(CtComment comment) {
        CtComment other = (CtComment)this.stack.peek();
        this.enter(comment);
        this.biScan(CtRole.COMMENT, comment.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, comment.getAnnotations(), other.getAnnotations());
        this.exit(comment);
    }

    @Override
    public void visitCtJavaDoc(CtJavaDoc javaDoc) {
        CtJavaDoc other = (CtJavaDoc)this.stack.peek();
        this.enter(javaDoc);
        this.biScan(CtRole.COMMENT, javaDoc.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, javaDoc.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.COMMENT_TAG, javaDoc.getTags(), other.getTags());
        this.exit(javaDoc);
    }

    @Override
    public void visitCtJavaDocTag(CtJavaDocTag docTag) {
        CtJavaDocTag other = (CtJavaDocTag)this.stack.peek();
        this.enter(docTag);
        this.biScan(CtRole.COMMENT, docTag.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, docTag.getAnnotations(), other.getAnnotations());
        this.exit(docTag);
    }

    @Override
    public void visitCtImport(CtImport ctImport) {
        CtImport other = (CtImport)this.stack.peek();
        this.enter(ctImport);
        this.biScan(CtRole.IMPORT_REFERENCE, ctImport.getReference(), other.getReference());
        this.biScan(CtRole.ANNOTATION, ctImport.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.COMMENT, ctImport.getComments(), other.getComments());
        this.exit(ctImport);
    }

    @Override
    public void visitCtModule(CtModule module) {
        CtModule other = (CtModule)this.stack.peek();
        this.enter(module);
        this.biScan(CtRole.COMMENT, module.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, module.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.MODULE_DIRECTIVE, module.getModuleDirectives(), other.getModuleDirectives());
        this.biScan(CtRole.SUB_PACKAGE, module.getRootPackage(), other.getRootPackage());
        this.exit(module);
    }

    @Override
    public void visitCtModuleReference(CtModuleReference moduleReference) {
        CtModuleReference other = (CtModuleReference)this.stack.peek();
        this.enter(moduleReference);
        this.biScan(CtRole.ANNOTATION, moduleReference.getAnnotations(), other.getAnnotations());
        this.exit(moduleReference);
    }

    @Override
    public void visitCtPackageExport(CtPackageExport moduleExport) {
        CtPackageExport other = (CtPackageExport)this.stack.peek();
        this.enter(moduleExport);
        this.biScan(CtRole.COMMENT, moduleExport.getComments(), other.getComments());
        this.biScan(CtRole.PACKAGE_REF, moduleExport.getPackageReference(), other.getPackageReference());
        this.biScan(CtRole.MODULE_REF, moduleExport.getTargetExport(), other.getTargetExport());
        this.biScan(CtRole.ANNOTATION, moduleExport.getAnnotations(), other.getAnnotations());
        this.exit(moduleExport);
    }

    @Override
    public void visitCtModuleRequirement(CtModuleRequirement moduleRequirement) {
        CtModuleRequirement other = (CtModuleRequirement)this.stack.peek();
        this.enter(moduleRequirement);
        this.biScan(CtRole.COMMENT, moduleRequirement.getComments(), other.getComments());
        this.biScan(CtRole.MODULE_REF, moduleRequirement.getModuleReference(), other.getModuleReference());
        this.biScan(CtRole.ANNOTATION, moduleRequirement.getAnnotations(), other.getAnnotations());
        this.exit(moduleRequirement);
    }

    @Override
    public void visitCtProvidedService(CtProvidedService moduleProvidedService) {
        CtProvidedService other = (CtProvidedService)this.stack.peek();
        this.enter(moduleProvidedService);
        this.biScan(CtRole.COMMENT, moduleProvidedService.getComments(), other.getComments());
        this.biScan(CtRole.SERVICE_TYPE, moduleProvidedService.getServiceType(), other.getServiceType());
        this.biScan(CtRole.IMPLEMENTATION_TYPE, moduleProvidedService.getImplementationTypes(), other.getImplementationTypes());
        this.biScan(CtRole.ANNOTATION, moduleProvidedService.getAnnotations(), other.getAnnotations());
        this.exit(moduleProvidedService);
    }

    @Override
    public void visitCtUsedService(CtUsedService usedService) {
        CtUsedService other = (CtUsedService)this.stack.peek();
        this.enter(usedService);
        this.biScan(CtRole.COMMENT, usedService.getComments(), other.getComments());
        this.biScan(CtRole.SERVICE_TYPE, usedService.getServiceType(), other.getServiceType());
        this.biScan(CtRole.ANNOTATION, usedService.getAnnotations(), other.getAnnotations());
        this.exit(usedService);
    }

    @Override
    public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
        CtCompilationUnit other = (CtCompilationUnit)this.stack.peek();
        this.enter(compilationUnit);
        this.biScan(CtRole.COMMENT, compilationUnit.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, compilationUnit.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.PACKAGE_DECLARATION, compilationUnit.getPackageDeclaration(), other.getPackageDeclaration());
        this.biScan(CtRole.DECLARED_IMPORT, compilationUnit.getImports(), other.getImports());
        this.biScan(CtRole.DECLARED_MODULE_REF, compilationUnit.getDeclaredModuleReference(), other.getDeclaredModuleReference());
        this.biScan(CtRole.DECLARED_TYPE_REF, compilationUnit.getDeclaredTypeReferences(), other.getDeclaredTypeReferences());
        this.exit(compilationUnit);
    }

    @Override
    public void visitCtPackageDeclaration(CtPackageDeclaration packageDeclaration) {
        CtPackageDeclaration other = (CtPackageDeclaration)this.stack.peek();
        this.enter(packageDeclaration);
        this.biScan(CtRole.COMMENT, packageDeclaration.getComments(), other.getComments());
        this.biScan(CtRole.ANNOTATION, packageDeclaration.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.PACKAGE_REF, packageDeclaration.getReference(), other.getReference());
        this.exit(packageDeclaration);
    }

    @Override
    public void visitCtTypeMemberWildcardImportReference(CtTypeMemberWildcardImportReference wildcardReference) {
        CtTypeMemberWildcardImportReference other = (CtTypeMemberWildcardImportReference)this.stack.peek();
        this.enter(wildcardReference);
        this.biScan(CtRole.TYPE_REF, wildcardReference.getTypeReference(), other.getTypeReference());
        this.exit(wildcardReference);
    }

    @Override
    public void visitCtYieldStatement(CtYieldStatement statement) {
        CtYieldStatement other = (CtYieldStatement)this.stack.peek();
        this.enter(statement);
        this.biScan(CtRole.ANNOTATION, statement.getAnnotations(), other.getAnnotations());
        this.biScan(CtRole.EXPRESSION, statement.getExpression(), other.getExpression());
        this.biScan(CtRole.COMMENT, statement.getComments(), other.getComments());
        this.exit(statement);
    }
}

