/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;

public class CtIterator
extends CtScanner
implements Iterator<CtElement> {
    private ArrayDeque<CtElement> deque = new ArrayDeque<CtElement>(){

        @Override
        public boolean addAll(Collection c) {
            for (Object aC : c) {
                this.addFirst((CtElement)aC);
            }
            return !c.isEmpty();
        }
    };
    private ArrayDeque<CtElement> current_children = new ArrayDeque();

    public CtIterator(CtElement root) {
        if (root != null) {
            this.deque.add(root);
        }
    }

    @Override
    public void scan(CtElement element) {
        if (element != null) {
            this.current_children.addFirst(element);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.deque.isEmpty();
    }

    @Override
    public CtElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        CtElement next = this.deque.pollFirst();
        this.current_children.clear();
        next.accept(this);
        this.deque.addAll(this.current_children);
        return next;
    }
}

