/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.experimental.CtUnresolvedImport;
import spoon.processing.Processor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CaseKind;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleDirective;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CommentHelper;
import spoon.reflect.visitor.CtImportVisitor;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.DefaultTokenWriter;
import spoon.reflect.visitor.ElementPrinterHelper;
import spoon.reflect.visitor.LiteralHelper;
import spoon.reflect.visitor.OperatorHelper;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.reflect.visitor.PrinterHelper;
import spoon.reflect.visitor.PrintingContext;
import spoon.reflect.visitor.TokenWriter;
import spoon.reflect.visitor.printer.CommentOffset;
import spoon.support.util.ModelList;

public class DefaultJavaPrettyPrinter
implements CtVisitor,
PrettyPrinter {
    public static final String JAVA_FILE_EXTENSION = ".java";
    public static final String JAVA_PACKAGE_DECLARATION = "package-info.java";
    public static final String JAVA_MODULE_DECLARATION = "module-info.java";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String COMMENT_STAR = " * ";
    public static final String BLOCK_COMMENT_END = " */";
    public static final String JAVADOC_START = "/**";
    public static final String INLINE_COMMENT_START = "// ";
    public static final String BLOCK_COMMENT_START = "/* ";
    private PrintingContext context = new PrintingContext();
    protected final List<Processor<CtElement>> preprocessors = new ArrayList<Processor<CtElement>>();
    protected Environment env;
    private TokenWriter printer;
    private ElementPrinterHelper elementPrinterHelper;
    protected CtCompilationUnit sourceCompilationUnit;
    protected boolean ignoreImplicit = true;
    public boolean inlineElseIf = true;
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final String ERROR_MESSAGE_TO_STRING = "Error in printing the node. One parent isn't initialized!";

    public DefaultJavaPrettyPrinter(Environment env) {
        this.env = env;
        this.setPrinterTokenWriter(new DefaultTokenWriter(new PrinterHelper(env)));
    }

    public String getLineSeparator() {
        return this.getPrinterHelper().getLineSeparator();
    }

    public DefaultJavaPrettyPrinter setLineSeparator(String lineSeparator) {
        this.getPrinterHelper().setLineSeparator(lineSeparator);
        return this;
    }

    @Override
    public String printElement(CtElement element) {
        String errorMessage = "";
        try {
            CtElement clone = element.clone();
            if (element.isParentInitialized()) {
                clone.setParent(element.getParent());
            }
            this.applyPreProcessors(clone);
            this.scan(clone);
        }
        catch (ParentNotInitializedException ignore) {
            LOGGER.error(ERROR_MESSAGE_TO_STRING, (Throwable)ignore);
            errorMessage = ERROR_MESSAGE_TO_STRING;
        }
        return this.toString().replaceFirst("^\\s+", "") + errorMessage;
    }

    protected void enterCtExpression(CtExpression<?> e) {
        if (!(e instanceof CtStatement)) {
            this.elementPrinterHelper.writeComment(e, CommentOffset.BEFORE);
        }
        this.getPrinterHelper().mapLine(e, this.sourceCompilationUnit);
        if (this.shouldSetBracket(e)) {
            this.context.parenthesedExpression.push(e);
            this.printer.writeSeparator("(");
        }
        if (!e.getTypeCasts().isEmpty()) {
            for (CtTypeReference<?> r : e.getTypeCasts()) {
                this.printer.writeSeparator("(");
                this.scan(r);
                this.printer.writeSeparator(")").writeSpace();
                this.printer.writeSeparator("(");
                this.context.parenthesedExpression.push(e);
            }
        }
    }

    protected void enterCtStatement(CtStatement s) {
        this.elementPrinterHelper.writeComment(s, CommentOffset.BEFORE);
        this.getPrinterHelper().mapLine(s, this.sourceCompilationUnit);
        if (!this.context.isNextForVariable()) {
            this.elementPrinterHelper.writeAnnotations(s);
        }
        if (!this.context.isFirstForVariable() && !this.context.isNextForVariable() && s.getLabel() != null) {
            this.printer.writeIdentifier(s.getLabel()).writeSpace().writeSeparator(":").writeSpace();
        }
    }

    protected void exitCtStatement(CtStatement statement) {
        if (!(statement instanceof CtBlock || statement instanceof CtIf || statement instanceof CtFor || statement instanceof CtForEach || statement instanceof CtWhile || statement instanceof CtTry || statement instanceof CtSwitch || statement instanceof CtSynchronized || statement instanceof CtClass || statement instanceof CtComment || !this.context.isStatement(statement) || this.context.isFirstForVariable() || this.context.isNextForVariable())) {
            this.printer.writeSeparator(";");
        }
        this.elementPrinterHelper.writeComment(statement, CommentOffset.AFTER);
    }

    protected void exitCtExpression(CtExpression<?> e) {
        while (!this.context.parenthesedExpression.isEmpty() && e == this.context.parenthesedExpression.peek()) {
            this.context.parenthesedExpression.pop();
            this.printer.writeSeparator(")");
        }
        if (!(e instanceof CtStatement)) {
            this.elementPrinterHelper.writeComment(e, CommentOffset.AFTER);
        }
    }

    protected void enter(CtElement e) {
    }

    protected void exit(CtElement e) {
    }

    @Override
    public String prettyprint(CtElement e) {
        this.reset();
        this.applyPreProcessors(e);
        this.scan(e);
        return this.getResult();
    }

    public DefaultJavaPrettyPrinter scan(CtElement e) {
        if (e != null) {
            this.enter(e);
            this.context.elementStack.push(e);
            if (this.env.isPreserveLineNumbers() && !(e instanceof CtNamedElement)) {
                this.getPrinterHelper().adjustStartPosition(e);
            }
            e.accept(this);
            this.context.elementStack.pop();
            this.exit(e);
        }
        return this;
    }

    private boolean shouldSetBracket(CtExpression<?> e) {
        if (!e.getTypeCasts().isEmpty()) {
            return true;
        }
        try {
            if (e.getParent() instanceof CtBinaryOperator || e.getParent() instanceof CtUnaryOperator) {
                return e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator || e instanceof CtBinaryOperator;
            }
            if (e.getParent() instanceof CtTargetedExpression && ((CtTargetedExpression)e.getParent()).getTarget() == e) {
                return e instanceof CtBinaryOperator || e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator;
            }
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return this.printer.getPrinterHelper().toString();
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.elementPrinterHelper.writeAnnotations(annotation);
        this.printer.writeSeparator("@");
        this.scan(annotation.getAnnotationType());
        if (!annotation.getValues().isEmpty()) {
            this.elementPrinterHelper.printList(annotation.getValues().entrySet(), null, false, "(", false, false, ",", true, false, ")", e -> {
                if (!(annotation.getValues().size() == 1 && "value".equals(e.getKey()))) {
                    this.printer.writeIdentifier((String)e.getKey()).writeSpace().writeOperator("=").writeSpace();
                }
                this.elementPrinterHelper.writeAnnotationElement(annotation.getFactory(), e.getValue());
            });
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.visitCtType(annotationType);
        this.printer.writeSeparator("@").writeKeyword("interface").writeSpace().writeIdentifier(annotationType.getSimpleName()).writeSpace().writeSeparator("{").incTab();
        this.elementPrinterHelper.writeElementList(annotationType.getTypeMembers());
        this.printer.decTab().writeSeparator("}");
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable impl) {
        this.elementPrinterHelper.writeComment(impl);
        this.elementPrinterHelper.writeAnnotations(impl);
        this.elementPrinterHelper.writeModifiers(impl);
        this.scan(impl.getBody());
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.printCtArrayAccess(arrayRead);
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.printCtArrayAccess(arrayWrite);
    }

    private <T, E extends CtExpression<?>> void printCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.enterCtExpression(arrayAccess);
        this.scan((CtElement)arrayAccess.getTarget());
        this.printer.writeSeparator("[");
        this.scan(arrayAccess.getIndexExpression());
        this.printer.writeSeparator("]");
        this.exitCtExpression(arrayAccess);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        if (reference.isImplicit()) {
            return;
        }
        this.scan(reference.getComponentType());
        if (!this.context.skipArray()) {
            this.printer.writeSeparator("[").writeSeparator("]");
        }
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.enterCtStatement(asserted);
        this.printer.writeKeyword("assert").writeSpace();
        this.scan(asserted.getAssertExpression());
        if (asserted.getExpression() != null) {
            this.printer.writeSpace().writeSeparator(":").writeSpace();
            this.scan(asserted.getExpression());
        }
        this.exitCtStatement(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.enterCtStatement(assignement);
        this.enterCtExpression(assignement);
        this.scan(assignement.getAssigned());
        this.printer.writeSpace().writeOperator("=").writeSpace();
        this.scan(assignement.getAssignment());
        this.exitCtExpression(assignement);
        this.exitCtStatement(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.enterCtExpression(operator);
        this.scan(operator.getLeftHandOperand());
        this.printer.writeSpace();
        this.printer.writeOperator(OperatorHelper.getOperatorText(operator.getKind()));
        this.printer.writeSpace();
        try (PrintingContext.Writable _context = this.context.modify();){
            if (operator.getKind() == BinaryOperatorKind.INSTANCEOF) {
                _context.forceWildcardGenerics(true);
            }
            this.scan(operator.getRightHandOperand());
        }
        this.exitCtExpression(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.enterCtStatement(block);
        if (!block.isImplicit()) {
            this.printer.writeSeparator("{");
        }
        this.printer.incTab();
        for (CtStatement statement : block.getStatements()) {
            if (statement.isImplicit()) continue;
            this.printer.writeln();
            this.elementPrinterHelper.writeStatement(statement);
        }
        this.printer.decTab();
        this.getPrinterHelper().adjustEndPosition(block);
        if (this.env.isPreserveLineNumbers()) {
            if (!block.isImplicit()) {
                this.printer.writeSeparator("}");
            }
        } else {
            this.printer.writeln();
            if (!block.isImplicit()) {
                this.printer.writeSeparator("}");
            }
        }
        this.exitCtStatement(block);
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.enterCtStatement(breakStatement);
        if (!breakStatement.isImplicit()) {
            this.printer.writeKeyword("break");
            if (breakStatement.getTargetLabel() != null) {
                this.printer.writeSpace().writeKeyword(breakStatement.getTargetLabel());
            }
        }
        this.exitCtStatement(breakStatement);
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        this.enterCtStatement(caseStatement);
        if (caseStatement.getCaseExpression() != null) {
            this.printer.writeKeyword("case").writeSpace();
            List<CtExpression<E>> caseExpressions = caseStatement.getCaseExpressions();
            for (int i2 = 0; i2 < caseExpressions.size(); ++i2) {
                CtExpression<E> caseExpression = caseExpressions.get(i2);
                if (caseExpression instanceof CtFieldAccess) {
                    CtVariableReference variable = ((CtFieldAccess)caseExpression).getVariable();
                    if (variable.getType() != null && variable.getDeclaringType() != null && variable.getType().getQualifiedName().equals(variable.getDeclaringType().getQualifiedName())) {
                        this.printer.writeIdentifier(variable.getSimpleName());
                    } else {
                        this.scan(caseExpression);
                    }
                } else {
                    this.scan(caseExpression);
                }
                if (i2 == caseExpressions.size() - 1) continue;
                this.printer.writeSeparator(",").writeSpace();
            }
        } else {
            this.printer.writeKeyword("default");
        }
        String separator = caseStatement.getCaseKind() == CaseKind.ARROW ? "->" : ":";
        this.printer.writeSpace().writeSeparator(separator).incTab();
        for (CtStatement statement : caseStatement.getStatements()) {
            this.printer.writeln();
            this.elementPrinterHelper.writeStatement(statement);
        }
        this.printer.decTab();
        this.exitCtStatement(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.elementPrinterHelper.writeComment(catchBlock, CommentOffset.BEFORE);
        this.printer.writeSpace().writeKeyword("catch").writeSpace().writeSeparator("(");
        CtCatchVariable<? extends Throwable> parameter = catchBlock.getParameter();
        if (parameter != null && parameter.getMultiTypes().size() > 1) {
            this.elementPrinterHelper.printList(parameter.getMultiTypes(), null, false, null, false, true, "|", true, false, null, type -> this.scan((CtElement)type));
            this.printer.writeSpace().writeIdentifier(parameter.getSimpleName());
        } else {
            this.scan(parameter);
        }
        this.printer.writeSeparator(")").writeSpace();
        this.scan(catchBlock.getBody());
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.context.pushCurrentThis(ctClass);
        if (ctClass.getSimpleName() != null && !"<unknown>".equals(ctClass.getSimpleName()) && !ctClass.isAnonymous()) {
            this.visitCtType(ctClass);
            if (ctClass.isLocalType()) {
                this.printer.writeKeyword("class").writeSpace().writeIdentifier(ctClass.getSimpleName().replaceAll("^[0-9]*", ""));
            } else {
                this.printer.writeKeyword("class").writeSpace().writeIdentifier(ctClass.getSimpleName());
            }
            this.elementPrinterHelper.writeFormalTypeParameters(ctClass);
            this.elementPrinterHelper.writeExtendsClause(ctClass);
            this.elementPrinterHelper.writeImplementsClause(ctClass);
        }
        this.printer.writeSpace().writeSeparator("{").incTab();
        this.elementPrinterHelper.writeElementList(ctClass.getTypeMembers());
        this.getPrinterHelper().adjustEndPosition(ctClass);
        this.printer.decTab().writeSeparator("}");
        this.context.popCurrentThis();
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.elementPrinterHelper.writeAnnotations(typeParameter);
        this.printer.writeIdentifier(typeParameter.getSimpleName());
        if (typeParameter.getSuperclass() != null && !typeParameter.getSuperclass().isImplicit()) {
            this.printer.writeSpace().writeKeyword("extends").writeSpace();
            this.scan(typeParameter.getSuperclass());
        }
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        boolean parent;
        this.enterCtExpression(conditional);
        CtExpression<Boolean> condition = conditional.getCondition();
        try {
            parent = conditional.getParent() instanceof CtAssignment || conditional.getParent() instanceof CtVariable;
        }
        catch (ParentNotInitializedException ex) {
            parent = false;
        }
        if (parent) {
            this.printer.writeSeparator("(");
        }
        this.scan(condition);
        if (parent) {
            this.printer.writeSeparator(")");
        }
        this.printer.writeSpace().writeOperator("?").writeSpace();
        CtExpression<T> thenExpression = conditional.getThenExpression();
        this.scan(thenExpression);
        this.printer.writeSpace().writeOperator(":").writeSpace();
        CtExpression<T> elseExpression = conditional.getElseExpression();
        boolean isAssign = elseExpression instanceof CtAssignment;
        if (isAssign) {
            this.printer.writeSeparator("(");
        }
        this.scan(elseExpression);
        if (isAssign) {
            this.printer.writeSeparator(")");
        }
        this.exitCtExpression(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> constructor) {
        this.elementPrinterHelper.writeComment(constructor);
        this.elementPrinterHelper.visitCtNamedElement(constructor, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(constructor);
        this.elementPrinterHelper.writeFormalTypeParameters(constructor);
        if (!constructor.getFormalCtTypeParameters().isEmpty()) {
            this.printer.writeSpace();
        }
        if (constructor.getDeclaringType() != null) {
            if (constructor.getDeclaringType().isLocalType()) {
                this.printer.writeIdentifier(constructor.getDeclaringType().getSimpleName().replaceAll("^[0-9]*", ""));
            } else {
                this.printer.writeIdentifier(constructor.getDeclaringType().getSimpleName());
            }
        }
        this.elementPrinterHelper.writeExecutableParameters(constructor);
        this.elementPrinterHelper.writeThrowsClause(constructor);
        this.printer.writeSpace();
        this.scan(constructor.getBody());
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.enterCtStatement(continueStatement);
        this.printer.writeKeyword("continue");
        if (continueStatement.getTargetLabel() != null) {
            this.printer.writeSpace().writeIdentifier(continueStatement.getTargetLabel());
        }
        this.exitCtStatement(continueStatement);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.enterCtStatement(doLoop);
        this.printer.writeKeyword("do");
        this.elementPrinterHelper.writeIfOrLoopBlock(doLoop.getBody());
        this.printer.writeKeyword("while").writeSpace().writeSeparator("(");
        this.scan(doLoop.getLoopingExpression());
        this.printer.writeSpace().writeSeparator(")");
        this.exitCtStatement(doLoop);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.visitCtType(ctEnum);
        this.printer.writeKeyword("enum").writeSpace().writeIdentifier(ctEnum.getSimpleName());
        this.elementPrinterHelper.writeImplementsClause(ctEnum);
        this.context.pushCurrentThis(ctEnum);
        this.printer.writeSpace().writeSeparator("{").incTab().writeln();
        if (ctEnum.getEnumValues().isEmpty()) {
            this.printer.writeSeparator(";").writeln();
        } else {
            this.elementPrinterHelper.printList(ctEnum.getEnumValues(), null, false, null, false, false, ",", false, false, ";", enumValue -> {
                this.printer.writeln();
                this.scan((CtElement)enumValue);
            });
        }
        this.elementPrinterHelper.writeElementList(ctEnum.getTypeMembers());
        this.printer.decTab().writeSeparator("}");
        this.context.popCurrentThis();
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.printer.getPrinterHelper().write(reference.getSignature());
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.elementPrinterHelper.writeComment(f, CommentOffset.BEFORE);
        this.elementPrinterHelper.visitCtNamedElement(f, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(f);
        this.scan(f.getType());
        this.printer.writeSpace();
        this.printer.writeIdentifier(f.getSimpleName());
        if (f.getDefaultExpression() != null) {
            this.printer.writeSpace().writeOperator("=").writeSpace();
            this.scan(f.getDefaultExpression());
        }
        this.printer.writeSeparator(";");
        this.elementPrinterHelper.writeComment(f, CommentOffset.AFTER);
    }

    @Override
    public <T> void visitCtEnumValue(CtEnumValue<T> enumValue) {
        this.elementPrinterHelper.visitCtNamedElement(enumValue, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeComment(enumValue, CommentOffset.BEFORE);
        this.printer.writeIdentifier(enumValue.getSimpleName());
        if (enumValue.getDefaultExpression() != null) {
            CtConstructorCall constructorCall = (CtConstructorCall)enumValue.getDefaultExpression();
            if (!constructorCall.isImplicit()) {
                this.elementPrinterHelper.printList(constructorCall.getArguments(), null, false, "(", false, false, ",", true, false, ")", expr -> this.scan((CtElement)expr));
            }
            if (constructorCall instanceof CtNewClass) {
                this.scan(((CtNewClass)constructorCall).getAnonymousClass());
            }
        }
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.printCtFieldAccess(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.printCtFieldAccess(fieldWrite);
    }

    private <T> void printCtFieldAccess(CtFieldAccess<T> f) {
        this.enterCtExpression(f);
        try (PrintingContext.Writable _context = this.context.modify();){
            Object target;
            if ((f.getVariable().isStatic() || "class".equals(f.getVariable().getSimpleName())) && f.getTarget() instanceof CtTypeAccess) {
                _context.ignoreGenerics(true);
            }
            if ((target = f.getTarget()) != null) {
                if (this.shouldPrintTarget((CtExpression)target)) {
                    this.scan((CtElement)target);
                    this.printer.writeSeparator(".");
                }
                _context.ignoreStaticAccess(true);
            }
            this.scan(f.getVariable());
        }
        this.exitCtExpression(f);
    }

    private boolean shouldPrintTarget(CtExpression target) {
        if (target == null) {
            return false;
        }
        if (!target.isImplicit()) {
            return true;
        }
        if (!this.ignoreImplicit) {
            return false;
        }
        return !(target instanceof CtThisAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        try {
            String targetTypeQualifiedName;
            CtType<?> lastType;
            String lastTypeQualifiedName;
            this.enterCtExpression(thisAccess);
            CtTypeAccess target = (CtTypeAccess)thisAccess.getTarget();
            CtTypeReference targetType = target.getAccessedType();
            if (thisAccess.isImplicit()) {
                return;
            }
            if (targetType == null || thisAccess.getParent(CtType.class) != null && thisAccess.getParent(CtType.class).isTopLevel()) {
                this.printer.writeKeyword("this");
                return;
            }
            if (targetType.isAnonymous()) {
                this.printer.writeKeyword("this");
                return;
            }
            if (!this.context.currentThis.isEmpty() && !(lastTypeQualifiedName = (lastType = this.context.currentThis.peekFirst().type).getQualifiedName()).equals(targetTypeQualifiedName = targetType.getQualifiedName())) {
                if (!targetType.isImplicit()) {
                    this.visitCtTypeReferenceWithoutGenerics(targetType);
                    this.printer.writeSeparator(".");
                }
                this.printer.writeKeyword("this");
                return;
            }
            this.printer.writeKeyword("this");
        }
        finally {
            this.exitCtExpression(thisAccess);
        }
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enterCtExpression(f);
        if (f.getTarget() != null) {
            this.scan((CtElement)f.getTarget());
            this.printer.writeSeparator(".");
        }
        this.printer.writeKeyword("super");
        this.exitCtExpression(f);
    }

    @Override
    public void visitCtJavaDoc(CtJavaDoc comment) {
        this.visitCtComment(comment);
    }

    @Override
    public void visitCtJavaDocTag(CtJavaDocTag docTag) {
        CommentHelper.printJavaDocTag(this.printer.getPrinterHelper(), docTag, x -> x);
    }

    @Override
    public void visitCtImport(CtImport ctImport) {
        if (ctImport.getImportKind() != null) {
            this.printer.writeKeyword("import");
            this.printer.writeSpace();
            ctImport.accept(new CtImportVisitor(){

                @Override
                public <T> void visitTypeImport(CtTypeReference<T> typeReference) {
                    DefaultJavaPrettyPrinter.this.writeImportReference(typeReference);
                }

                @Override
                public <T> void visitMethodImport(CtExecutableReference<T> execRef) {
                    DefaultJavaPrettyPrinter.this.printer.writeKeyword("static");
                    DefaultJavaPrettyPrinter.this.printer.writeSpace();
                    if (execRef.getDeclaringType() != null) {
                        DefaultJavaPrettyPrinter.this.writeImportReference(execRef.getDeclaringType());
                        DefaultJavaPrettyPrinter.this.printer.writeSeparator(".");
                    }
                    DefaultJavaPrettyPrinter.this.printer.writeIdentifier(execRef.getSimpleName());
                }

                @Override
                public <T> void visitFieldImport(CtFieldReference<T> fieldReference) {
                    DefaultJavaPrettyPrinter.this.printer.writeKeyword("static");
                    DefaultJavaPrettyPrinter.this.printer.writeSpace();
                    if (fieldReference.getDeclaringType() != null) {
                        DefaultJavaPrettyPrinter.this.writeImportReference(fieldReference.getDeclaringType());
                        DefaultJavaPrettyPrinter.this.printer.writeSeparator(".");
                    }
                    DefaultJavaPrettyPrinter.this.printer.writeIdentifier(fieldReference.getSimpleName());
                }

                @Override
                public void visitAllTypesImport(CtPackageReference packageReference) {
                    DefaultJavaPrettyPrinter.this.visitCtPackageReference(packageReference);
                    DefaultJavaPrettyPrinter.this.printer.writeSeparator(".");
                    DefaultJavaPrettyPrinter.this.printer.writeIdentifier("*");
                }

                @Override
                public <T> void visitAllStaticMembersImport(CtTypeMemberWildcardImportReference typeReference) {
                    DefaultJavaPrettyPrinter.this.printer.writeKeyword("static");
                    DefaultJavaPrettyPrinter.this.printer.writeSpace();
                    DefaultJavaPrettyPrinter.this.writeImportReference(typeReference.getTypeReference());
                    DefaultJavaPrettyPrinter.this.printer.writeSeparator(".");
                    DefaultJavaPrettyPrinter.this.printer.writeIdentifier("*");
                }

                @Override
                public <T> void visitUnresolvedImport(CtUnresolvedImport ctUnresolvedImport) {
                    if (ctUnresolvedImport.isStatic()) {
                        DefaultJavaPrettyPrinter.this.printer.writeKeyword("static");
                        DefaultJavaPrettyPrinter.this.printer.writeSpace();
                    }
                    DefaultJavaPrettyPrinter.this.printer.writeCodeSnippet(ctUnresolvedImport.getUnresolvedReference());
                }
            });
            this.printer.writeSeparator(";");
        }
    }

    private void writeImportReference(CtTypeReference<?> ref) {
        boolean prevIgnoreImplicit = this.ignoreImplicit;
        this.ignoreImplicit = true;
        this.visitCtTypeReference(ref, false);
        this.ignoreImplicit = prevIgnoreImplicit;
    }

    @Override
    public void visitCtModule(CtModule module) {
        this.enter(module);
        if (module.isOpenModule()) {
            this.printer.writeKeyword("open").writeSpace();
        }
        this.printer.writeKeyword("module").writeSpace().writeIdentifier(module.getSimpleName());
        this.printer.writeSpace().writeSeparator("{").incTab().writeln();
        for (CtModuleDirective moduleDirective : module.getModuleDirectives()) {
            this.scan(moduleDirective);
        }
        this.printer.decTab().writeSeparator("}");
        this.exit(module);
    }

    @Override
    public void visitCtModuleReference(CtModuleReference moduleReference) {
        this.printer.writeIdentifier(moduleReference.getSimpleName());
    }

    @Override
    public void visitCtPackageExport(CtPackageExport moduleExport) {
        if (moduleExport.isOpenedPackage()) {
            this.printer.writeKeyword("opens");
        } else {
            this.printer.writeKeyword("exports");
        }
        this.printer.writeSpace();
        this.visitCtPackageReference(moduleExport.getPackageReference());
        if (!moduleExport.getTargetExport().isEmpty()) {
            this.elementPrinterHelper.printList(moduleExport.getTargetExport(), null, false, " to", true, false, ",", true, false, null, moduleReference -> this.scan((CtElement)moduleReference));
        }
        this.printer.writeSeparator(";").writeln();
    }

    @Override
    public void visitCtModuleRequirement(CtModuleRequirement moduleRequirement) {
        this.printer.writeKeyword("requires").writeSpace();
        if (!moduleRequirement.getRequiresModifiers().isEmpty()) {
            this.elementPrinterHelper.printList(moduleRequirement.getRequiresModifiers(), null, false, null, false, false, " ", false, false, " ", modifier -> this.printer.writeKeyword(modifier.name().toLowerCase()));
        }
        this.scan(moduleRequirement.getModuleReference());
        this.printer.writeSeparator(";").writeln();
    }

    @Override
    public void visitCtProvidedService(CtProvidedService moduleProvidedService) {
        this.printer.writeKeyword("provides").writeSpace();
        this.scan(moduleProvidedService.getServiceType());
        this.elementPrinterHelper.printList(moduleProvidedService.getImplementationTypes(), null, false, " with", true, false, ",", true, false, null, implementations -> this.scan((CtElement)implementations));
        this.printer.writeSeparator(";").writeln();
    }

    @Override
    public void visitCtUsedService(CtUsedService usedService) {
        this.printer.writeKeyword("uses").writeSpace();
        this.scan(usedService.getServiceType());
        this.printer.writeSeparator(";").writeln();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
        CtCompilationUnit outerCompilationUnit = this.sourceCompilationUnit;
        try {
            this.sourceCompilationUnit = compilationUnit;
            this.elementPrinterHelper.writeComment(compilationUnit, CommentOffset.BEFORE);
            switch (compilationUnit.getUnitType()) {
                case MODULE_DECLARATION: {
                    CtModule module = compilationUnit.getDeclaredModule();
                    this.scan(module);
                    break;
                }
                case PACKAGE_DECLARATION: {
                    CtPackage pack = compilationUnit.getDeclaredPackage();
                    this.scan(pack);
                    break;
                }
                case TYPE_DECLARATION: {
                    this.scan(compilationUnit.getPackageDeclaration());
                    for (CtImport ctImport : this.getImports(compilationUnit)) {
                        this.scan(ctImport);
                        this.printer.writeln();
                    }
                    for (CtType ctType : compilationUnit.getDeclaredTypes()) {
                        this.scan(ctType);
                    }
                    break;
                }
                default: {
                    throw new SpoonException("Unexpected compilation unit type: " + (Object)((Object)compilationUnit.getUnitType()));
                }
            }
            this.elementPrinterHelper.writeComment(compilationUnit, CommentOffset.AFTER);
        }
        finally {
            this.sourceCompilationUnit = outerCompilationUnit;
        }
    }

    protected ModelList<CtImport> getImports(CtCompilationUnit compilationUnit) {
        return compilationUnit.getImports();
    }

    @Override
    public void visitCtPackageDeclaration(CtPackageDeclaration packageDeclaration) {
        CtPackageReference ctPackage = packageDeclaration.getReference();
        this.elementPrinterHelper.writeComment(ctPackage, CommentOffset.BEFORE);
        if (!ctPackage.isUnnamedPackage()) {
            this.elementPrinterHelper.writePackageLine(ctPackage.getQualifiedName());
        }
    }

    @Override
    public void visitCtTypeMemberWildcardImportReference(CtTypeMemberWildcardImportReference wildcardReference) {
        this.scan(wildcardReference.getTypeReference());
        this.printer.writeSeparator(".").writeSeparator("*");
    }

    @Override
    public void visitCtComment(CtComment comment) {
        if (!this.env.isCommentsEnabled() && this.context.elementStack.size() > 1) {
            return;
        }
        this.printer.writeComment(comment);
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.enterCtExpression(annotationFieldAccess);
        try (PrintingContext.Writable _context = this.context.modify();){
            if (annotationFieldAccess.getTarget() != null) {
                this.scan((CtElement)annotationFieldAccess.getTarget());
                this.printer.writeSeparator(".");
                _context.ignoreStaticAccess(true);
            }
            _context.ignoreGenerics(true);
            this.scan(annotationFieldAccess.getVariable());
            this.printer.writeSeparator("(").writeSeparator(")");
        }
        this.exitCtExpression(annotationFieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        boolean isStatic = "class".equals(reference.getSimpleName()) || !"super".equals(reference.getSimpleName()) && reference.isStatic();
        boolean printType = true;
        if (reference.isFinal() && reference.isStatic()) {
            CtTypeReference<?> declTypeRef = reference.getDeclaringType();
            if (declTypeRef.isAnonymous()) {
                printType = false;
            } else if (this.context.isInCurrentScope(declTypeRef)) {
                printType = false;
            }
        }
        if (isStatic && printType && !this.context.ignoreStaticAccess()) {
            try (Object _context = this.context.modify().ignoreGenerics(true);){
                this.scan(reference.getDeclaringType());
            }
            this.printer.writeSeparator(".");
        }
        if ("class".equals(reference.getSimpleName())) {
            this.printer.writeKeyword("class");
        } else {
            this.printer.writeIdentifier(reference.getSimpleName());
        }
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        Object _context;
        this.enterCtStatement(forLoop);
        this.printer.writeKeyword("for").writeSpace().writeSeparator("(");
        List<CtStatement> st = forLoop.getForInit();
        if (!st.isEmpty()) {
            _context = this.context.modify().isFirstForVariable(true);
            try {
                this.scan(st.get(0));
            }
            finally {
                if (_context != null) {
                    ((PrintingContext.Writable)_context).close();
                }
            }
        }
        if (st.size() > 1) {
            _context = this.context.modify().isNextForVariable(true);
            try {
                for (int i2 = 1; i2 < st.size(); ++i2) {
                    this.printer.writeSeparator(",").writeSpace();
                    this.scan(st.get(i2));
                }
            }
            finally {
                if (_context != null) {
                    ((PrintingContext.Writable)_context).close();
                }
            }
        }
        this.printer.writeSeparator(";").writeSpace();
        this.scan(forLoop.getExpression());
        this.printer.writeSeparator(";");
        if (!forLoop.getForUpdate().isEmpty()) {
            this.printer.writeSpace();
        }
        this.elementPrinterHelper.printList(forLoop.getForUpdate(), null, false, null, false, true, ",", true, false, null, s -> this.scan((CtElement)s));
        this.printer.writeSeparator(")");
        this.elementPrinterHelper.writeIfOrLoopBlock(forLoop.getBody());
        this.exitCtStatement(forLoop);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.enterCtStatement(foreach);
        this.printer.writeKeyword("for").writeSpace().writeSeparator("(");
        this.scan(foreach.getVariable());
        this.printer.writeSpace().writeSeparator(":").writeSpace();
        this.scan(foreach.getExpression());
        this.printer.writeSeparator(")");
        this.elementPrinterHelper.writeIfOrLoopBlock(foreach.getBody());
        this.exitCtStatement(foreach);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.enterCtStatement(ifElement);
        this.printer.writeKeyword("if").writeSpace().writeSeparator("(");
        this.scan(ifElement.getCondition());
        this.printer.writeSeparator(")");
        Object thenStmt = ifElement.getThenStatement();
        Object elseStmt = ifElement.getElseStatement();
        this.elementPrinterHelper.writeIfOrLoopBlock((CtStatement)thenStmt);
        if (elseStmt != null) {
            List<CtComment> comments = this.elementPrinterHelper.getComments(ifElement, CommentOffset.INSIDE);
            if (thenStmt != null) {
                SourcePosition thenPosition = thenStmt.getPosition();
                if (!thenPosition.isValidPosition() && thenStmt instanceof CtBlock) {
                    Object thenExpression = ((CtBlock)thenStmt).getStatement(0);
                    thenPosition = thenExpression.getPosition();
                }
                for (CtComment comment : comments) {
                    if (comment.getPosition().getSourceStart() <= thenPosition.getSourceEnd()) continue;
                    this.elementPrinterHelper.writeComment(comment);
                }
            }
            if (thenStmt instanceof CtBlock && !thenStmt.isImplicit()) {
                this.printer.writeSpace();
            }
            this.printer.writeKeyword("else");
            if (this.inlineElseIf && this.elementPrinterHelper.isElseIf(ifElement)) {
                this.printer.writeSpace();
                CtIf child = elseStmt instanceof CtBlock ? (CtIf)((CtBlock)elseStmt).getStatement(0) : (CtIf)elseStmt;
                this.scan(child);
            } else {
                this.elementPrinterHelper.writeIfOrLoopBlock((CtStatement)elseStmt);
            }
        }
        this.exitCtStatement(ifElement);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.visitCtType(intrface);
        this.printer.writeKeyword("interface").writeSpace().writeIdentifier(intrface.getSimpleName());
        if (intrface.getFormalCtTypeParameters() != null) {
            this.elementPrinterHelper.writeFormalTypeParameters(intrface);
        }
        if (!intrface.getSuperInterfaces().isEmpty()) {
            this.elementPrinterHelper.printList(intrface.getSuperInterfaces(), "extends", false, null, false, true, ",", true, false, null, ref -> this.scan((CtElement)ref));
        }
        this.context.pushCurrentThis(intrface);
        this.printer.writeSpace().writeSeparator("{").incTab();
        this.elementPrinterHelper.writeElementList(intrface.getTypeMembers());
        this.printer.decTab().writeSeparator("}");
        this.context.popCurrentThis();
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enterCtStatement(invocation);
        this.enterCtExpression(invocation);
        if (invocation.getExecutable().isConstructor()) {
            CtType parentType;
            this.elementPrinterHelper.writeActualTypeArguments(invocation.getExecutable());
            try {
                parentType = invocation.getParent(CtType.class);
            }
            catch (ParentNotInitializedException e2) {
                parentType = null;
            }
            if (parentType == null || parentType.getQualifiedName() != null && parentType.getQualifiedName().equals(invocation.getExecutable().getDeclaringType().getQualifiedName())) {
                this.printer.writeKeyword("this");
            } else {
                if (invocation.getTarget() != null && !invocation.getTarget().isImplicit()) {
                    this.scan((CtElement)invocation.getTarget());
                    this.printer.writeSeparator(".");
                }
                this.printer.writeKeyword("super");
            }
        } else {
            if (invocation.getTarget() != null && (this.ignoreImplicit || !invocation.getTarget().isImplicit())) {
                try (PrintingContext.Writable _context = this.context.modify();){
                    if (invocation.getTarget() instanceof CtTypeAccess) {
                        _context.ignoreGenerics(true);
                    }
                    if (this.shouldPrintTarget((CtExpression)invocation.getTarget())) {
                        this.scan((CtElement)invocation.getTarget());
                        this.printer.writeSeparator(".");
                    }
                }
            }
            this.elementPrinterHelper.writeActualTypeArguments(invocation);
            if (this.env.isPreserveLineNumbers()) {
                this.getPrinterHelper().adjustStartPosition(invocation);
            }
            this.printer.writeIdentifier(invocation.getExecutable().getSimpleName());
        }
        this.elementPrinterHelper.printList(invocation.getArguments(), null, false, "(", false, false, ",", true, false, ")", e -> this.scan((CtElement)e));
        this.exitCtExpression(invocation);
        this.exitCtStatement(invocation);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.enterCtExpression(literal);
        this.printer.writeLiteral(LiteralHelper.getLiteralToken(literal));
        this.exitCtExpression(literal);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.enterCtStatement(localVariable);
        if (this.env.isPreserveLineNumbers()) {
            this.getPrinterHelper().adjustStartPosition(localVariable);
        }
        if (!this.context.isNextForVariable()) {
            this.elementPrinterHelper.writeModifiers(localVariable);
            if (localVariable.isInferred() && this.env.getComplianceLevel() >= 10) {
                this.getPrinterTokenWriter().writeKeyword("var");
            } else {
                this.scan(localVariable.getType());
            }
            this.printer.writeSpace();
        }
        this.printer.writeIdentifier(localVariable.getSimpleName());
        if (localVariable.getDefaultExpression() != null) {
            this.printer.writeSpace().writeOperator("=").writeSpace();
            this.scan(localVariable.getDefaultExpression());
        }
        this.exitCtStatement(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.printer.writeIdentifier(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        if (this.env.isPreserveLineNumbers()) {
            this.getPrinterHelper().adjustStartPosition(catchVariable);
        }
        this.elementPrinterHelper.writeModifiers(catchVariable);
        this.scan(catchVariable.getType());
        this.printer.writeSpace();
        this.printer.writeIdentifier(catchVariable.getSimpleName());
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.printer.writeIdentifier(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.elementPrinterHelper.writeComment(m, CommentOffset.BEFORE);
        this.elementPrinterHelper.visitCtNamedElement(m, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(m);
        this.elementPrinterHelper.writeFormalTypeParameters(m);
        if (!m.getFormalCtTypeParameters().isEmpty()) {
            this.printer.writeSpace();
        }
        try (Object _context = this.context.modify().ignoreGenerics(false);){
            this.scan(m.getType());
        }
        this.printer.writeSpace();
        this.printer.writeIdentifier(m.getSimpleName());
        this.elementPrinterHelper.writeExecutableParameters(m);
        this.elementPrinterHelper.writeThrowsClause(m);
        if (m.getBody() != null) {
            this.printer.writeSpace();
            this.scan(m.getBody());
            if (m.getBody().getPosition().isValidPosition()) {
                if (m.getBody().getPosition().getCompilationUnit() == this.sourceCompilationUnit) {
                    if (m.getBody().getStatements().isEmpty() || !(m.getBody().getStatements().get(m.getBody().getStatements().size() - 1) instanceof CtReturn)) {
                        this.getPrinterHelper().putLineNumberMapping(m.getBody().getPosition().getEndLine());
                    }
                } else {
                    this.getPrinterHelper().undefineLine();
                }
            } else {
                this.getPrinterHelper().undefineLine();
            }
        } else {
            this.printer.writeSeparator(";");
        }
        this.elementPrinterHelper.writeComment(m, CommentOffset.AFTER);
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        this.elementPrinterHelper.writeComment(annotationMethod);
        this.elementPrinterHelper.visitCtNamedElement(annotationMethod, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(annotationMethod);
        this.scan(annotationMethod.getType());
        this.printer.writeSpace();
        this.printer.writeIdentifier(annotationMethod.getSimpleName());
        this.printer.writeSeparator("(").writeSeparator(")");
        if (annotationMethod.getDefaultExpression() != null) {
            this.printer.writeSpace().writeKeyword("default").writeSpace();
            this.scan(annotationMethod.getDefaultExpression());
        }
        this.printer.writeSeparator(";");
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        boolean isNotInAnnotation;
        this.enterCtExpression(newArray);
        try {
            isNotInAnnotation = newArray.getParent(CtAnnotationType.class) == null && newArray.getParent(CtAnnotation.class) == null;
        }
        catch (ParentNotInitializedException e2) {
            isNotInAnnotation = true;
        }
        if (isNotInAnnotation) {
            CtTypeReference<Object> ref = newArray.getType();
            if (ref != null) {
                this.printer.writeKeyword("new").writeSpace();
            }
            try (Object _context = this.context.modify().skipArray(true);){
                this.scan(ref);
            }
            int i2 = 0;
            while (ref instanceof CtArrayTypeReference) {
                this.printer.writeSeparator("[");
                if (newArray.getDimensionExpressions().size() > i2) {
                    CtExpression<Integer> e3 = newArray.getDimensionExpressions().get(i2);
                    this.scan(e3);
                }
                this.printer.writeSeparator("]");
                ref = ((CtArrayTypeReference)ref).getComponentType();
                ++i2;
            }
        }
        if (newArray.getDimensionExpressions().isEmpty()) {
            this.elementPrinterHelper.printList(newArray.getElements(), null, false, "{", true, false, ",", true, true, "}", e -> this.scan((CtElement)e));
            this.elementPrinterHelper.writeComment(newArray, CommentOffset.INSIDE);
        }
        this.elementPrinterHelper.writeComment(newArray, CommentOffset.AFTER);
        this.exitCtExpression(newArray);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.enterCtStatement(ctConstructorCall);
        this.enterCtExpression(ctConstructorCall);
        this.printConstructorCall(ctConstructorCall);
        this.exitCtExpression(ctConstructorCall);
        this.exitCtStatement(ctConstructorCall);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.enterCtStatement(newClass);
        this.enterCtExpression(newClass);
        this.printConstructorCall(newClass);
        this.scan(newClass.getAnonymousClass());
        this.exitCtExpression(newClass);
        this.exitCtStatement(newClass);
    }

    private <T> void printConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        try (PrintingContext.Writable _context = this.context.modify();){
            if (ctConstructorCall.getTarget() != null) {
                this.scan((CtElement)ctConstructorCall.getTarget());
                this.printer.writeSeparator(".");
                _context.ignoreEnclosingClass(true);
            }
            if (this.hasDeclaringTypeWithGenerics(ctConstructorCall.getType())) {
                _context.ignoreEnclosingClass(true);
            }
            this.printer.writeKeyword("new").writeSpace();
            if (!ctConstructorCall.getActualTypeArguments().isEmpty()) {
                this.elementPrinterHelper.writeActualTypeArguments(ctConstructorCall);
            }
            this.scan(ctConstructorCall.getType());
        }
        this.elementPrinterHelper.printList(ctConstructorCall.getArguments(), null, false, "(", false, false, ",", true, false, ")", exp -> this.scan((CtElement)exp));
    }

    private <T> boolean hasDeclaringTypeWithGenerics(CtTypeReference<T> reference) {
        if (reference == null) {
            return false;
        }
        if (reference.getDeclaringType() == null) {
            return false;
        }
        if (reference.isLocalType()) {
            return false;
        }
        if (!reference.getDeclaringType().getActualTypeArguments().isEmpty()) {
            return true;
        }
        return this.hasDeclaringTypeWithGenerics(reference.getDeclaringType());
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.enterCtExpression(lambda);
        this.elementPrinterHelper.printList(lambda.getParameters(), null, false, "(", false, false, ",", false, false, ")", parameter -> this.scan((CtElement)parameter));
        this.printer.writeSpace();
        this.printer.writeSeparator("->");
        this.printer.writeSpace();
        if (lambda.getBody() != null) {
            this.scan(lambda.getBody());
        } else {
            this.scan(lambda.getExpression());
        }
        this.exitCtExpression(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.enterCtExpression(expression);
        try (PrintingContext.Writable _context = this.context.modify();){
            if (expression.getExecutable().isStatic()) {
                _context.ignoreGenerics(true);
            }
            this.scan((CtElement)expression.getTarget());
        }
        this.printer.writeSeparator("::");
        if (expression.getExecutable().isConstructor()) {
            this.printer.writeKeyword("new");
        } else {
            this.printer.writeIdentifier(expression.getExecutable().getSimpleName());
        }
        this.exitCtExpression(expression);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.enterCtStatement(assignment);
        this.enterCtExpression(assignment);
        this.scan(assignment.getAssigned());
        this.printer.writeSpace();
        this.printer.writeOperator(OperatorHelper.getOperatorText(assignment.getKind()) + "=");
        this.printer.writeSpace();
        this.scan(assignment.getAssignment());
        this.exitCtExpression(assignment);
        this.exitCtStatement(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        this.elementPrinterHelper.writeComment(ctPackage);
        this.elementPrinterHelper.writeAnnotations(ctPackage);
        if (!ctPackage.isUnnamedPackage()) {
            this.elementPrinterHelper.writePackageLine(ctPackage.getQualifiedName());
        }
        this.elementPrinterHelper.writeImports(this.getImports(ctPackage.getPosition().getCompilationUnit()));
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.elementPrinterHelper.writeQualifiedName(reference.getSimpleName());
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.elementPrinterHelper.writeComment(parameter);
        this.elementPrinterHelper.writeAnnotations(parameter);
        this.elementPrinterHelper.writeModifiers(parameter);
        if (parameter.isVarArgs()) {
            this.scan(((CtArrayTypeReference)parameter.getType()).getComponentType());
            this.printer.writeSeparator("...");
        } else if (parameter.isInferred() && this.env.getComplianceLevel() >= 11) {
            this.getPrinterTokenWriter().writeKeyword("var");
        } else {
            this.scan(parameter.getType());
        }
        this.printer.writeSpace();
        this.printer.writeIdentifier(parameter.getSimpleName());
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.printer.writeIdentifier(reference.getSimpleName());
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.enterCtStatement(returnStatement);
        this.printer.writeKeyword("return");
        if (returnStatement.getReturnedExpression() != null) {
            this.printer.writeSpace();
        }
        this.scan(returnStatement.getReturnedExpression());
        this.exitCtStatement(returnStatement);
    }

    private <T> void visitCtType(CtType<T> type) {
        this.elementPrinterHelper.writeComment(type, CommentOffset.BEFORE);
        this.getPrinterHelper().mapLine(type, this.sourceCompilationUnit);
        if (type.isTopLevel()) {
            this.context.currentTopLevel = type;
        }
        this.elementPrinterHelper.visitCtNamedElement(type, this.sourceCompilationUnit);
        this.elementPrinterHelper.writeModifiers(type);
    }

    @Override
    public void visitCtStatementList(CtStatementList statements) {
        for (CtStatement s : statements.getStatements()) {
            this.scan(s);
        }
    }

    private <S> void writeSwitch(CtAbstractSwitch<S> abstractSwitch) {
        this.printer.writeKeyword("switch").writeSpace().writeSeparator("(");
        this.scan(abstractSwitch.getSelector());
        this.printer.writeSeparator(")").writeSpace().writeSeparator("{").incTab();
        for (CtCase<S> c : abstractSwitch.getCases()) {
            this.printer.writeln();
            this.scan(c);
        }
        if (this.env.isPreserveLineNumbers()) {
            this.printer.decTab().writeSeparator("}");
        } else {
            this.printer.decTab().writeln().writeSeparator("}");
        }
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.enterCtStatement(switchStatement);
        this.writeSwitch(switchStatement);
        this.exitCtStatement(switchStatement);
    }

    @Override
    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
        this.enterCtExpression(switchExpression);
        this.writeSwitch(switchExpression);
        this.exitCtExpression(switchExpression);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.enterCtStatement(synchro);
        this.printer.writeKeyword("synchronized");
        if (synchro.getExpression() != null) {
            this.printer.writeSeparator("(");
            this.scan(synchro.getExpression());
            this.printer.writeSeparator(")").writeSpace();
        }
        this.scan(synchro.getBlock());
        this.exitCtStatement(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.enterCtStatement(throwStatement);
        this.printer.writeKeyword("throw").writeSpace();
        this.scan(throwStatement.getThrownExpression());
        this.exitCtStatement(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.enterCtStatement(tryBlock);
        this.printer.writeKeyword("try").writeSpace();
        this.scan(tryBlock.getBody());
        for (CtCatch c : tryBlock.getCatchers()) {
            this.scan(c);
        }
        if (tryBlock.getFinalizer() != null) {
            this.printer.writeSpace().writeKeyword("finally").writeSpace();
            this.scan(tryBlock.getFinalizer());
        }
        this.exitCtStatement(tryBlock);
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.enterCtStatement(tryWithResource);
        this.printer.writeKeyword("try").writeSpace();
        if (tryWithResource.getResources() != null && !tryWithResource.getResources().isEmpty()) {
            this.elementPrinterHelper.printList(tryWithResource.getResources(), null, false, "(", false, false, ";", false, false, ")", r -> this.scan((CtElement)r));
        }
        this.printer.writeSpace();
        this.scan(tryWithResource.getBody());
        for (CtCatch c : tryWithResource.getCatchers()) {
            this.scan(c);
        }
        if (tryWithResource.getFinalizer() != null) {
            this.printer.writeSpace().writeKeyword("finally").writeSpace();
            this.scan(tryWithResource.getFinalizer());
        }
        this.exitCtStatement(tryWithResource);
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        if (ref.isImplicit()) {
            return;
        }
        this.elementPrinterHelper.writeAnnotations(ref);
        if (this.printQualified(ref)) {
            this.elementPrinterHelper.writeQualifiedName(ref.getQualifiedName());
        } else {
            this.printer.writeIdentifier(ref.getSimpleName());
        }
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
        if (wildcardReference.isImplicit()) {
            return;
        }
        this.elementPrinterHelper.writeAnnotations(wildcardReference);
        this.printer.writeSeparator("?");
        if (!wildcardReference.isDefaultBoundingType() || !wildcardReference.getBoundingType().isImplicit()) {
            if (wildcardReference.isUpper()) {
                this.printer.writeSpace().writeKeyword("extends").writeSpace();
            } else {
                this.printer.writeSpace().writeKeyword("super").writeSpace();
            }
            this.scan(wildcardReference.getBoundingType());
        }
    }

    private boolean printQualified(CtTypeReference<?> ref) {
        return this.ignoreImplicit || !ref.isSimplyQualified();
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        if (reference.isImplicit()) {
            return;
        }
        this.elementPrinterHelper.printList(reference.getBounds(), null, false, null, false, true, "&", true, false, null, bound -> this.scan((CtElement)bound));
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> ref) {
        this.visitCtTypeReference(ref, true);
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        if (!this.ignoreImplicit && typeAccess.isImplicit()) {
            return;
        }
        this.enterCtExpression(typeAccess);
        this.scan(typeAccess.getAccessedType());
        this.exitCtExpression(typeAccess);
    }

    private void visitCtTypeReferenceWithoutGenerics(CtTypeReference<?> ref) {
        this.visitCtTypeReference(ref, false);
    }

    private void visitCtTypeReference(CtTypeReference<?> ref, boolean withGenerics) {
        boolean isInner;
        if (!this.isPrintTypeReference(ref)) {
            return;
        }
        if (ref.isPrimitive()) {
            this.elementPrinterHelper.writeAnnotations(ref);
            this.printer.writeKeyword(ref.getSimpleName());
            return;
        }
        boolean bl = isInner = ref.getDeclaringType() != null;
        if (isInner) {
            CtTypeReference<?> accessType;
            if (!this.context.ignoreEnclosingClass() && !ref.isLocalType() && !(accessType = ref.getAccessType()).isAnonymous() && this.isPrintTypeReference(accessType)) {
                try (PrintingContext.Writable _context = this.context.modify();){
                    if (!withGenerics) {
                        _context.ignoreGenerics(true);
                    }
                    this.scan(accessType);
                }
                this.printer.writeSeparator(".");
            }
            this.elementPrinterHelper.writeAnnotations(ref);
            if (ref.isLocalType()) {
                this.printer.writeIdentifier(ref.getSimpleName().replaceAll("^[0-9]*", ""));
            } else {
                this.printer.writeIdentifier(ref.getSimpleName());
            }
        } else {
            if (ref.getPackage() != null && this.printQualified(ref) && !ref.getPackage().isUnnamedPackage()) {
                this.scan(ref.getPackage());
                this.printer.writeSeparator(".");
            }
            if (ref.isParentInitialized() && !(ref.getParent() instanceof CtImport)) {
                this.elementPrinterHelper.writeAnnotations(ref);
            }
            this.printer.writeIdentifier(ref.getSimpleName());
        }
        if (withGenerics && !this.context.ignoreGenerics()) {
            try (Object _context = this.context.modify().ignoreEnclosingClass(false);){
                this.elementPrinterHelper.writeActualTypeArguments(ref);
            }
        }
    }

    private boolean isPrintTypeReference(CtTypeReference<?> accessType) {
        if (!accessType.isImplicit()) {
            return true;
        }
        if (this.ignoreImplicit) {
            return true;
        }
        return this.context.forceWildcardGenerics() && accessType.getTypeDeclaration().getFormalCtTypeParameters().size() > 0;
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.enterCtStatement(operator);
        this.enterCtExpression(operator);
        UnaryOperatorKind op = operator.getKind();
        if (OperatorHelper.isPrefixOperator(op)) {
            this.printer.writeOperator(OperatorHelper.getOperatorText(op));
        }
        this.scan(operator.getOperand());
        if (OperatorHelper.isSufixOperator(op)) {
            this.printer.writeOperator(OperatorHelper.getOperatorText(op));
        }
        this.exitCtExpression(operator);
        this.exitCtStatement(operator);
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.enterCtExpression(variableRead);
        this.printer.writeIdentifier(variableRead.getVariable().getSimpleName());
        this.exitCtExpression(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.enterCtExpression(variableWrite);
        this.printer.writeIdentifier(variableWrite.getVariable().getSimpleName());
        this.exitCtExpression(variableWrite);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.enterCtStatement(whileLoop);
        this.printer.writeKeyword("while").writeSpace().writeSeparator("(");
        this.scan(whileLoop.getLoopingExpression());
        this.printer.writeSeparator(")");
        this.elementPrinterHelper.writeIfOrLoopBlock(whileLoop.getBody());
        this.exitCtStatement(whileLoop);
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.elementPrinterHelper.writeComment(expression);
        this.printer.writeCodeSnippet(expression.getValue());
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.enterCtStatement(statement);
        this.printer.writeCodeSnippet(statement.getValue());
        this.exitCtStatement(statement);
    }

    public ElementPrinterHelper getElementPrinterHelper() {
        return this.elementPrinterHelper;
    }

    public PrintingContext getContext() {
        return this.context;
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        this.printer.writeIdentifier(reference.getSimpleName());
    }

    @Override
    public String printCompilationUnit(CtCompilationUnit compilationUnit) {
        this.calculate(compilationUnit, compilationUnit.getDeclaredTypes());
        return this.getResult();
    }

    public void applyPreProcessors(CtElement el) {
        for (Processor<CtElement> preprocessor : this.preprocessors) {
            preprocessor.process(el);
        }
    }

    @Override
    public String printPackageInfo(CtPackage pack) {
        CompilationUnit cu = pack.getFactory().CompilationUnit().getOrCreate(pack);
        return this.printCompilationUnit(cu);
    }

    @Override
    public String printModuleInfo(CtModule module) {
        CompilationUnit cu = module.getFactory().CompilationUnit().getOrCreate(module);
        return this.printCompilationUnit(cu);
    }

    @Override
    public String printTypes(CtType<?> ... type) {
        this.calculate(null, Arrays.asList(type));
        return this.getResult();
    }

    @Override
    public String getResult() {
        return this.printer.getPrinterHelper().toString();
    }

    public void reset() {
        this.printer.reset();
        this.context = new PrintingContext();
    }

    @Override
    public void calculate(CtCompilationUnit sourceCompilationUnit, List<CtType<?>> types) {
        this.reset();
        if (!types.isEmpty()) {
            CtPackageReference packRef;
            CtType<?> type = types.get(0);
            if (sourceCompilationUnit == null) {
                sourceCompilationUnit = type.getFactory().CompilationUnit().getOrCreate(type);
            }
            if (type.getPackage() == null) {
                type.setParent(type.getFactory().Package().getRootPackage());
            }
            if (!(packRef = type.getPackage().getReference()).equals(sourceCompilationUnit.getPackageDeclaration().getReference())) {
                sourceCompilationUnit.getPackageDeclaration().setReference(packRef);
            }
            if (!this.hasSameTypes(sourceCompilationUnit, types)) {
                sourceCompilationUnit = sourceCompilationUnit.clone();
                sourceCompilationUnit.setDeclaredTypes(types);
            }
        }
        this.applyPreProcessors(sourceCompilationUnit);
        this.scan(sourceCompilationUnit);
    }

    private boolean hasSameTypes(CtCompilationUnit compilationUnit, List<CtType<?>> types) {
        List<CtTypeReference<?>> cuTypes = compilationUnit.getDeclaredTypeReferences();
        if (cuTypes.size() != types.size()) {
            return false;
        }
        Set cuQnames = cuTypes.stream().map(CtTypeInformation::getQualifiedName).collect(Collectors.toSet());
        Set qnames = types.stream().map(CtTypeInformation::getQualifiedName).collect(Collectors.toSet());
        return cuQnames.equals(qnames);
    }

    @Override
    public Map<Integer, Integer> getLineNumberMapping() {
        return this.getPrinterHelper().getLineNumberMapping();
    }

    protected TokenWriter getPrinterTokenWriter() {
        return this.printer;
    }

    public DefaultJavaPrettyPrinter setPrinterTokenWriter(TokenWriter tokenWriter) {
        this.elementPrinterHelper = new ElementPrinterHelper(tokenWriter, this, this.env);
        this.printer = tokenWriter;
        return this;
    }

    private PrinterHelper getPrinterHelper() {
        return this.printer.getPrinterHelper();
    }

    public void setPreprocessors(List<Processor<CtElement>> preprocessors) {
        this.preprocessors.clear();
        this.preprocessors.addAll(preprocessors);
    }

    public List<Processor<CtElement>> getPreprocessors() {
        return this.preprocessors;
    }

    public void setIgnoreImplicit(boolean ignoreImplicit) {
        this.ignoreImplicit = ignoreImplicit;
    }

    @Override
    public void visitCtYieldStatement(CtYieldStatement statement) {
        if (statement.isImplicit()) {
            this.scan(statement.getExpression());
            this.exitCtStatement(statement);
            return;
        }
        this.enterCtStatement(statement);
        this.printer.writeKeyword("yield");
        if (statement.getExpression() != null) {
            this.printer.writeSpace();
        }
        this.scan(statement.getExpression());
        this.exitCtStatement(statement);
    }
}

