/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.io.Closeable;
import spoon.reflect.visitor.TokenWriter;

public class ListPrinter
implements Closeable {
    private final TokenWriter printerTokenWriter;
    private final boolean nextPrefixSpace;
    private final String separator;
    private final boolean nextSuffixSpace;
    private final boolean endPrefixSpace;
    private final String end;
    private boolean isFirst = true;

    public ListPrinter(TokenWriter printerHelper, boolean startPrefixSpace, String start, boolean startSuffixSpace, boolean nextPrefixSpace, String next, boolean nextSuffixSpace, boolean endPrefixSpace, String end) {
        this.printerTokenWriter = printerHelper;
        this.nextPrefixSpace = nextPrefixSpace;
        this.separator = next;
        this.nextSuffixSpace = nextSuffixSpace;
        this.endPrefixSpace = endPrefixSpace;
        this.end = end;
        if (startPrefixSpace) {
            printerHelper.writeSpace();
        }
        if (start != null && !start.isEmpty()) {
            this.printerTokenWriter.writeSeparator(start);
        }
        if (startSuffixSpace) {
            printerHelper.writeSpace();
        }
    }

    public void printSeparatorIfAppropriate() {
        if (this.isFirst) {
            this.isFirst = false;
        } else {
            if (this.nextPrefixSpace) {
                this.printerTokenWriter.writeSpace();
            }
            if (this.separator != null && !this.separator.isEmpty()) {
                this.printerTokenWriter.writeSeparator(this.separator);
            }
            if (this.nextSuffixSpace) {
                this.printerTokenWriter.writeSpace();
            }
        }
    }

    @Override
    public void close() {
        if (this.endPrefixSpace) {
            this.printerTokenWriter.writeSpace();
        }
        if (this.end != null && !this.end.isEmpty()) {
            this.printerTokenWriter.writeSeparator(this.end);
        }
    }
}

