/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import spoon.compiler.Environment;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.support.reflect.cu.position.PartialSourcePositionImpl;

public class PrinterHelper {
    private String lineSeparator = System.getProperty("line.separator");
    private Environment env;
    protected final StringBuffer sbf = new StringBuffer();
    private int nbTabs = 0;
    private int line = 1;
    private int column = 1;
    private Map<Integer, Integer> lineNumberMapping = new HashMap<Integer, Integer>();
    protected boolean shouldWriteTabs = true;
    private boolean lastCharWasCR = false;

    public PrinterHelper() {
    }

    public PrinterHelper(Environment env) {
        this.env = env;
    }

    public void reset() {
        this.sbf.setLength(0);
        this.nbTabs = 0;
        this.line = 1;
        this.column = 1;
        this.shouldWriteTabs = true;
        this.lineNumberMapping = new HashMap<Integer, Integer>();
    }

    public PrinterHelper write(String s) {
        if (s != null) {
            int len = s.length();
            for (int i2 = 0; i2 < len; ++i2) {
                this.write(s.charAt(i2));
            }
        }
        return this;
    }

    public PrinterHelper write(char c) {
        if (c == '\r') {
            this.sbf.append(c);
            ++this.line;
            this.column = 1;
            this.shouldWriteTabs = true;
            this.lastCharWasCR = true;
            return this;
        }
        if (c == '\n') {
            this.sbf.append(c);
            if (!this.lastCharWasCR) {
                ++this.line;
                this.column = 1;
                this.shouldWriteTabs = true;
            }
            this.lastCharWasCR = false;
            return this;
        }
        this.autoWriteTabs();
        this.sbf.append(c);
        ++this.column;
        this.lastCharWasCR = false;
        return this;
    }

    public PrinterHelper writeln() {
        this.write(this.lineSeparator);
        return this;
    }

    private void writeTabsInternal() {
        for (int i2 = 0; i2 < this.nbTabs; ++i2) {
            if (this.env != null && this.env.isUsingTabulations()) {
                this.sbf.append('\t');
                ++this.column;
                continue;
            }
            int indentationSize = 2;
            if (this.env != null) {
                indentationSize = this.env.getTabulationSize();
            }
            for (int j = 0; j < indentationSize; ++j) {
                this.sbf.append(' ');
                ++this.column;
            }
        }
    }

    protected void autoWriteTabs() {
        if (this.shouldWriteTabs) {
            this.writeTabsInternal();
            this.shouldWriteTabs = false;
        }
    }

    public PrinterHelper incTab() {
        ++this.nbTabs;
        return this;
    }

    public PrinterHelper decTab() {
        --this.nbTabs;
        return this;
    }

    public int getTabCount() {
        return this.nbTabs;
    }

    public PrinterHelper setTabCount(int tabCount) {
        this.nbTabs = tabCount;
        return this;
    }

    public boolean removeLine() {
        int i2;
        String ls = this.lineSeparator;
        boolean hasWhite = false;
        for (i2 = this.sbf.length() - ls.length(); i2 > 0 && !ls.equals(this.sbf.substring(i2, i2 + ls.length())); --i2) {
            if (!this.isWhite(this.sbf.charAt(i2))) {
                return false;
            }
            hasWhite = true;
        }
        if (i2 <= 0) {
            return false;
        }
        hasWhite = hasWhite || this.isWhite(this.sbf.charAt(i2 - 1));
        this.sbf.replace(i2, i2 + ls.length(), hasWhite ? "" : " ");
        --this.line;
        return true;
    }

    private boolean isWhite(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public PrinterHelper adjustStartPosition(CtElement e) {
        block2: {
            if (e.isImplicit() || !e.getPosition().isValidPosition()) break block2;
            while (this.line < e.getPosition().getLine()) {
                this.writeln();
            }
            while (this.line > e.getPosition().getLine() && this.removeLine()) {
            }
        }
        return this;
    }

    public PrinterHelper adjustEndPosition(CtElement e) {
        if (this.env != null && this.env.isPreserveLineNumbers() && e.getPosition().isValidPosition()) {
            while (this.line < e.getPosition().getEndLine()) {
                this.writeln();
            }
        }
        return this;
    }

    public void undefineLine() {
        if (this.lineNumberMapping.get(this.line) == null) {
            this.putLineNumberMapping(0);
        }
    }

    public void mapLine(CtElement e, CtCompilationUnit unitExpected) {
        SourcePosition sp = e.getPosition();
        if (sp.isValidPosition() && sp.getCompilationUnit() == unitExpected && !(sp instanceof PartialSourcePositionImpl)) {
            this.putLineNumberMapping(e.getPosition().getLine());
        } else {
            this.undefineLine();
        }
    }

    public void putLineNumberMapping(int valueLine) {
        this.lineNumberMapping.put(this.line, valueLine);
    }

    public Map<Integer, Integer> getLineNumberMapping() {
        return Collections.unmodifiableMap(this.lineNumberMapping);
    }

    public String toString() {
        return this.sbf.toString();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void writeSpace() {
        this.write(' ');
    }

    public void setShouldWriteTabs(boolean b) {
        this.shouldWriteTabs = b;
    }
}

