/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.reflect.visitor.filter.AllTypeMembersFunction;
import spoon.reflect.visitor.filter.LambdaFilter;
import spoon.support.visitor.ClassTypingContext;
import spoon.support.visitor.SubInheritanceHierarchyResolver;

public class AllMethodsSameSignatureFunction
implements CtConsumableFunction<CtExecutable<?>>,
CtQueryAware {
    private boolean includingSelf = false;
    private boolean includingLambdas = true;
    private CtQuery query;

    public AllMethodsSameSignatureFunction includingSelf(boolean includingSelf) {
        this.includingSelf = includingSelf;
        return this;
    }

    public AllMethodsSameSignatureFunction includingLambdas(boolean includingLambdas) {
        this.includingLambdas = includingLambdas;
        return this;
    }

    @Override
    public void apply(final CtExecutable<?> targetExecutable, final CtConsumer<Object> outputConsumer) {
        CtMethod<?> targetMethod;
        final LambdaFilter lambdaFilter = new LambdaFilter();
        CtQuery lambdaQuery = targetExecutable.getFactory().getModel().filterChildren(lambdaFilter);
        if (targetExecutable instanceof CtLambda) {
            if (this.includingSelf && this.includingLambdas) {
                outputConsumer.accept(targetExecutable);
                if (this.query.isTerminated()) {
                    return;
                }
            }
            targetMethod = ((CtLambda)targetExecutable).getOverriddenMethod();
            outputConsumer.accept(targetMethod);
            if (this.query.isTerminated()) {
                return;
            }
            lambdaQuery.select(new Filter<CtLambda<?>>(){

                @Override
                public boolean matches(CtLambda<?> lambda) {
                    return targetExecutable != lambda;
                }
            });
        } else if (targetExecutable instanceof CtMethod) {
            if (this.includingSelf) {
                outputConsumer.accept(targetExecutable);
                if (this.query.isTerminated()) {
                    return;
                }
            }
            targetMethod = (CtMethod<?>)targetExecutable;
        } else {
            if (this.includingSelf) {
                outputConsumer.accept(targetExecutable);
            }
            return;
        }
        final ArrayList targetMethods = new ArrayList();
        targetMethods.add(targetMethod);
        CtType<?> declaringType = targetMethod.getDeclaringType();
        lambdaFilter.addImplementingInterface(declaringType);
        class Context {
            boolean haveToSearchForSubtypes;

            Context() {
            }
        }
        final Context context = new Context();
        context.haveToSearchForSubtypes = true;
        final SubInheritanceHierarchyResolver subHierarchyFnc = new SubInheritanceHierarchyResolver(declaringType.getFactory().getModel().getRootPackage());
        subHierarchyFnc.addSuperType(declaringType);
        HashSet<String> typesCheckedForRootType = new HashSet<String>();
        final ArrayList toBeCheckedSubTypes = new ArrayList();
        toBeCheckedSubTypes.add(declaringType);
        while (!toBeCheckedSubTypes.isEmpty()) {
            for (CtType ctType : toBeCheckedSubTypes) {
                ClassTypingContext ctc = new ClassTypingContext(ctType);
                targetMethod = this.getTargetMethodOfHierarchy(targetMethods, ctc);
                this.forEachOverridenMethod(ctc, targetMethod, typesCheckedForRootType, new CtConsumer<CtMethod<?>>(){
                    {
                    }

                    @Override
                    public void accept(CtMethod<?> overriddenMethod) {
                        targetMethods.add(overriddenMethod);
                        outputConsumer.accept(overriddenMethod);
                        CtType<?> type = overriddenMethod.getDeclaringType();
                        lambdaFilter.addImplementingInterface(type);
                        subHierarchyFnc.addSuperType(type);
                        context.haveToSearchForSubtypes = true;
                    }
                });
                if (!this.query.isTerminated()) continue;
                return;
            }
            toBeCheckedSubTypes.clear();
            if (!context.haveToSearchForSubtypes) continue;
            context.haveToSearchForSubtypes = false;
            subHierarchyFnc.forEachSubTypeInPackage(new CtConsumer<CtType<?>>(){

                @Override
                public void accept(CtType<?> type) {
                    toBeCheckedSubTypes.add(type);
                }
            });
        }
        if (this.includingLambdas) {
            lambdaQuery.forEach(outputConsumer);
        }
    }

    private void forEachOverridenMethod(final ClassTypingContext ctc, final CtMethod<?> thisMethod, Set<String> distintTypesSet, final CtConsumer<CtMethod<?>> outputConsumer) {
        final CtQuery q = ctc.getAdaptationScope().map(new AllTypeMembersFunction(CtMethod.class).distinctSet(distintTypesSet));
        q.forEach(new CtConsumer<CtMethod<?>>(){

            @Override
            public void accept(CtMethod<?> thatMethod) {
                if (thisMethod == thatMethod) {
                    return;
                }
                if (ctc.isSubSignature(thisMethod, thatMethod)) {
                    outputConsumer.accept(thatMethod);
                    if (AllMethodsSameSignatureFunction.this.query.isTerminated()) {
                        q.terminate();
                    }
                }
            }
        });
    }

    private CtMethod<?> getTargetMethodOfHierarchy(List<CtMethod<?>> targetMethods, ClassTypingContext ctc) {
        for (CtMethod<?> method : targetMethods) {
            CtType<?> declaringType = method.getDeclaringType();
            if (!ctc.isSubtypeOf((CtTypeReference<?>)declaringType.getReference())) continue;
            return method;
        }
        throw new SpoonException("No target executable was found in super type hiearchy of class typing context");
    }

    @Override
    public void setQuery(CtQuery query) {
        this.query = query;
    }
}

