/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.SpoonException;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.filter.CatchVariableScopeFunction;
import spoon.reflect.visitor.filter.LocalVariableScopeFunction;
import spoon.reflect.visitor.filter.ParameterScopeFunction;

public class VariableScopeFunction
implements CtConsumableFunction<CtVariable<?>> {
    protected final Visitor visitor = new Visitor();
    protected CtConsumer<Object> outputConsumer;
    private static final LocalVariableScopeFunction localVariableScopeFunction = new LocalVariableScopeFunction();
    private static final ParameterScopeFunction parameterScopeFunction = new ParameterScopeFunction();
    private static final CatchVariableScopeFunction catchVariableScopeFunction = new CatchVariableScopeFunction();

    @Override
    public void apply(CtVariable<?> variable, CtConsumer<Object> outputConsumer) {
        this.outputConsumer = outputConsumer;
        variable.accept(this.visitor);
    }

    protected class Visitor
    extends CtScanner {
        protected Visitor() {
        }

        @Override
        protected void enter(CtElement e) {
            throw new SpoonException("Unsupported variable of type " + e.getClass().getName());
        }

        @Override
        public <T> void visitCtField(CtField<T> field) {
            throw new SpoonException("Field scope function is not supported");
        }

        @Override
        public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
            localVariableScopeFunction.apply(localVariable, VariableScopeFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtParameter(CtParameter<T> parameter) {
            parameterScopeFunction.apply(parameter, VariableScopeFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
            catchVariableScopeFunction.apply(catchVariable, VariableScopeFunction.this.outputConsumer);
        }
    }
}

