/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import spoon.compiler.Environment;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.support.OutputDestinationHandler;

public class DefaultOutputDestinationHandler
implements OutputDestinationHandler {
    private File defaultOutputDirectory;
    private Environment environment;

    public DefaultOutputDestinationHandler(File defaultOutputDirectory, Environment environment) {
        this.defaultOutputDirectory = defaultOutputDirectory;
        this.environment = environment;
    }

    @Override
    public Path getOutputPath(CtModule module, CtPackage pack, CtType type) {
        Path directory = this.getDirectoryPath(module, pack, type);
        Path moduleDir = this.getModulePath(module);
        Path packagePath = this.getPackagePath(pack);
        String fileName = this.getFileName(pack, type);
        return Paths.get(directory.toString(), moduleDir.toString(), packagePath.toString(), fileName);
    }

    protected String getFileName(CtPackage pack, CtType type) {
        String fileName = type != null ? type.getSimpleName() + ".java" : (pack != null ? "package-info.java" : "module-info.java");
        return fileName;
    }

    protected Path getPackagePath(CtPackage pack) {
        Path packagePath = Paths.get(".", new String[0]);
        if (pack != null && !pack.isUnnamedPackage()) {
            packagePath = Paths.get(pack.getQualifiedName().replace('.', File.separatorChar), new String[0]);
        }
        return packagePath;
    }

    protected Path getModulePath(CtModule module) {
        Path moduleDir = Paths.get(".", new String[0]);
        if (module != null && !module.isUnnamedModule() && this.environment.getComplianceLevel() > 8) {
            moduleDir = Paths.get(module.getSimpleName(), new String[0]);
        }
        return moduleDir;
    }

    protected Path getDirectoryPath(CtModule module, CtPackage pack, CtType type) {
        return Paths.get(this.getDefaultOutputDirectory().getAbsolutePath(), new String[0]);
    }

    @Override
    public File getDefaultOutputDirectory() {
        return this.defaultOutputDirectory;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

