/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import spoon.SpoonException;
import spoon.processing.ProcessInterruption;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.support.compiler.SpoonProgress;
import spoon.support.visitor.ProcessingVisitor;

public class QueueProcessingManager
implements ProcessingManager {
    Processor<?> current;
    Factory factory;
    Queue<Processor<?>> processors;
    ProcessingVisitor visitor;

    public QueueProcessingManager(Factory factory) {
        this.setFactory(factory);
    }

    @Override
    public void addProcessor(Class<? extends Processor<?>> type) {
        try {
            Processor<?> p = type.newInstance();
            this.addProcessor(p);
        }
        catch (Exception e) {
            throw new SpoonException("Unable to instantiate processor \"" + type.getName() + "\" - Your processor should have a constructor with no arguments", e);
        }
    }

    @Override
    public boolean addProcessor(Processor<?> p) {
        p.setFactory(this.getFactory());
        return this.getProcessors().add(p);
    }

    @Override
    public void addProcessor(String qualifiedName) {
        try {
            this.addProcessor(this.getFactory().getEnvironment().getInputClassLoader().loadClass(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            throw new SpoonException("Unable to load processor \"" + qualifiedName + "\" - Check your classpath.", e);
        }
    }

    public Processor<?> getCurrentProcessor() {
        return this.current;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    public Queue<Processor<?>> getProcessors() {
        if (this.processors == null) {
            this.processors = new LinkedList();
        }
        return this.processors;
    }

    protected ProcessingVisitor getVisitor() {
        if (this.visitor == null) {
            this.visitor = new ProcessingVisitor(this.getFactory());
        }
        return this.visitor;
    }

    @Override
    public void process(Collection<? extends CtElement> elements) {
        Processor p;
        LinkedList processors = new LinkedList(this.getProcessors());
        if (this.factory.getEnvironment().getSpoonProgress() != null) {
            this.factory.getEnvironment().getSpoonProgress().start(SpoonProgress.Process.PROCESS);
        }
        int i2 = 0;
        while ((p = (Processor)processors.poll()) != null) {
            try {
                this.getFactory().getEnvironment().reportProgressMessage(p.getClass().getName());
                this.current = p;
                p.init();
                p.process();
                for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
                    this.getVisitor().setProcessor(p);
                    this.getVisitor().scan(ctElement);
                }
            }
            catch (ProcessInterruption processInterruption) {
                // empty catch block
            }
            p.processingDone();
            if (this.factory.getEnvironment().getSpoonProgress() == null) continue;
            this.factory.getEnvironment().getSpoonProgress().step(SpoonProgress.Process.PROCESS, p.getClass().getName(), ++i2, this.getProcessors().size());
        }
        if (this.factory.getEnvironment().getSpoonProgress() != null) {
            this.factory.getEnvironment().getSpoonProgress().end(SpoonProgress.Process.PROCESS);
        }
    }

    @Override
    public void process(CtElement element) {
        ArrayList<CtElement> l = new ArrayList<CtElement>();
        l.add(element);
        this.process(l);
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        factory.getEnvironment().setManager(this);
    }
}

