/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.util.GregorianCalendar;
import spoon.compiler.Environment;
import spoon.support.compiler.SpoonProgress;

public class ProgressLogger
implements SpoonProgress {
    private long stepTimer;
    private long timer;
    private Environment environment;

    public ProgressLogger(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void start(SpoonProgress.Process process) {
        this.environment.debugMessage("Start " + (Object)((Object)process));
        this.stepTimer = this.timer = this.getCurrentTimeInMillis();
    }

    @Override
    public void step(SpoonProgress.Process process, String task, int taskId, int nbTask) {
        this.environment.debugMessage("Step " + (Object)((Object)process) + " " + taskId + "/" + nbTask + " " + task + " in " + (this.getCurrentTimeInMillis() - this.timer) + " ms");
        this.timer = this.getCurrentTimeInMillis();
    }

    @Override
    public void step(SpoonProgress.Process process, String task) {
        this.environment.debugMessage("Step " + (Object)((Object)process) + " " + task + " in " + (this.getCurrentTimeInMillis() - this.timer) + " ms");
        this.timer = this.getCurrentTimeInMillis();
    }

    @Override
    public void end(SpoonProgress.Process process) {
        this.environment.debugMessage("End " + (Object)((Object)process) + " in " + (this.getCurrentTimeInMillis() - this.stepTimer) + " ms");
    }

    private long getCurrentTimeInMillis() {
        return new GregorianCalendar().getTimeInMillis();
    }
}

