/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import spoon.OutputType;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.compiler.Environment;
import spoon.compiler.ModelBuildingException;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;
import spoon.compiler.builder.AdvancedOptions;
import spoon.compiler.builder.AnnotationProcessingOptions;
import spoon.compiler.builder.ClasspathOptions;
import spoon.compiler.builder.ComplianceOptions;
import spoon.compiler.builder.JDTBuilder;
import spoon.compiler.builder.JDTBuilderImpl;
import spoon.compiler.builder.SourceOptions;
import spoon.processing.Processor;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.AstParentConsistencyChecker;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.reflect.visitor.Query;
import spoon.support.QueueProcessingManager;
import spoon.support.comparator.FixedOrderBasedOnFileNameCompilationUnitComparator;
import spoon.support.compiler.SnippetCompilationError;
import spoon.support.compiler.SpoonProgress;
import spoon.support.compiler.VirtualFolder;
import spoon.support.compiler.jdt.CompilationUnitFilter;
import spoon.support.compiler.jdt.FileCompilerConfig;
import spoon.support.compiler.jdt.JDTBatchCompiler;
import spoon.support.compiler.jdt.JDTCommentBuilder;
import spoon.support.compiler.jdt.JDTImportBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.TreeBuilderRequestor;
import spoon.support.modelobs.SourceFragmentCreator;
import spoon.support.sniper.SniperJavaPrettyPrinter;

public class JDTBasedSpoonCompiler
implements SpoonModelBuilder {
    protected INameEnvironment environment = null;
    protected final List<CategorizedProblem> probs = new ArrayList<CategorizedProblem>();
    protected final TreeBuilderRequestor requestor = new TreeBuilderRequestor(this);
    protected Factory factory;
    protected int javaCompliance = 7;
    protected SpoonFolder sources = new VirtualFolder();
    protected SpoonFolder templates = new VirtualFolder();
    protected String[] templateClasspath = new String[0];
    protected List<CompilationUnitFilter> compilationUnitFilters = new ArrayList<CompilationUnitFilter>();
    private boolean sortList;
    private static final CompilationUnitDeclaration[] EMPTY_RESULT = new CompilationUnitDeclaration[0];

    public JDTBasedSpoonCompiler(Factory factory) {
        this.factory = factory;
        this.initializeCUCOmparator();
    }

    private void initializeCUCOmparator() {
        this.sortList = System.getenv("SPOON_SEED_CU_COMPARATOR") == null;
    }

    @Override
    public boolean build() {
        return this.build(null);
    }

    @Override
    public boolean build(JDTBuilder builder) {
        if (this.factory == null) {
            throw new SpoonException("Factory not initialized");
        }
        if (this.factory.getModel() != null && this.factory.getModel().isBuildModelFinished()) {
            throw new SpoonException("Model already built");
        }
        this.factory.getEnvironment().debugMessage("building sources: " + this.sources.getAllJavaFiles());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        boolean srcSuccess = this.buildSources(builder);
        this.reportProblems(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("built in " + (System.currentTimeMillis() - t) + " ms");
        this.factory.getEnvironment().debugMessage("building templates: " + this.templates.getAllJavaFiles());
        t = System.currentTimeMillis();
        boolean templateSuccess = this.buildTemplates(builder);
        this.factory.getEnvironment().debugMessage("built in " + (System.currentTimeMillis() - t) + " ms");
        this.checkModel();
        this.factory.getModel().setBuildModelIsFinished(true);
        if (this.factory.getEnvironment().createPrettyPrinter() instanceof SniperJavaPrettyPrinter) {
            new SourceFragmentCreator().attachTo(this.factory.getEnvironment());
        }
        return srcSuccess && templateSuccess;
    }

    private void checkModel() {
        if (!this.factory.getEnvironment().checksAreSkipped()) {
            this.factory.getModel().getUnnamedModule().accept(new AstParentConsistencyChecker());
        }
    }

    @Override
    public boolean compile(SpoonModelBuilder.InputType ... types) {
        this.factory.getEnvironment().debugMessage("compiling sources: " + this.factory.CompilationUnit().getMap().keySet());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        JDTBatchCompiler batchCompiler = this.createBatchCompiler(types);
        Object classpathOptions = ((ClasspathOptions)((ClasspathOptions)new ClasspathOptions().encoding(this.getEnvironment().getEncoding().displayName())).classpath(this.getSourceClasspath())).binaries(this.getBinaryOutputDirectory());
        Object complianceOptions = new ComplianceOptions().compliance(this.javaCompliance);
        if (this.factory.getEnvironment().isPreviewFeaturesEnabled()) {
            ((ComplianceOptions)complianceOptions).enablePreview();
        }
        Object annotationProcessingOptions = new AnnotationProcessingOptions().compileProcessors();
        Object advancedOptions = ((AdvancedOptions)((AdvancedOptions)new AdvancedOptions().preserveUnusedVars()).continueExecution()).enableJavadoc();
        Object sourceOptions = new SourceOptions().sources(this.sources.getAllJavaFiles());
        Object[] args = new JDTBuilderImpl().classpathOptions((ClasspathOptions<?>)classpathOptions).complianceOptions((ComplianceOptions<?>)complianceOptions).annotationProcessingOptions((AnnotationProcessingOptions<?>)annotationProcessingOptions).advancedOptions((AdvancedOptions<?>)advancedOptions).sources((SourceOptions<?>)sourceOptions).build();
        this.getFactory().getEnvironment().debugMessage("compile args: " + Arrays.toString(args));
        System.setProperty("jdt.compiler.useSingleThread", "true");
        batchCompiler.compile((String[])args);
        this.reportProblemsWhenCompiling(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        return this.probs.isEmpty();
    }

    @Override
    public void instantiateAndProcess(List<String> processors) {
        QueueProcessingManager processing = new QueueProcessingManager(this.factory);
        for (String processorName : processors) {
            processing.addProcessor(processorName);
            this.factory.getEnvironment().debugMessage("Loaded processor " + processorName + ".");
        }
        processing.process(this.factory.Package().getRootPackage());
    }

    @Override
    public void process(Collection<Processor<? extends CtElement>> processors) {
        QueueProcessingManager processing = new QueueProcessingManager(this.factory);
        for (Processor<? extends CtElement> processorName : processors) {
            processing.addProcessor(processorName);
            this.factory.getEnvironment().debugMessage("Loaded processor " + processorName + ".");
        }
        processing.process(this.factory.Package().getRootPackage());
    }

    @Override
    public void generateProcessedSourceFiles(OutputType outputType) {
        this.generateProcessedSourceFiles(outputType, null);
    }

    @Override
    public void generateProcessedSourceFiles(OutputType outputType, Filter<CtType<?>> typeFilter) {
        if (this.getEnvironment().getSpoonProgress() != null) {
            this.getEnvironment().getSpoonProgress().start(SpoonProgress.Process.PRINT);
        }
        switch (outputType) {
            case CLASSES: {
                this.generateProcessedSourceFilesUsingTypes(typeFilter);
                break;
            }
            case COMPILATION_UNITS: {
                this.generateProcessedSourceFilesUsingCUs();
                break;
            }
        }
        if (this.getEnvironment().getSpoonProgress() != null) {
            this.getEnvironment().getSpoonProgress().end(SpoonProgress.Process.PRINT);
        }
    }

    @Override
    public void addInputSource(File source) {
        try {
            if (SpoonResourceHelper.isFile(source)) {
                this.sources.addFile(SpoonResourceHelper.createFile(source));
            } else {
                this.sources.addFolder(SpoonResourceHelper.createFolder(source));
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public void addInputSource(SpoonResource source) {
        if (source.isFile()) {
            this.sources.addFile((SpoonFile)source);
        } else {
            this.sources.addFolder((SpoonFolder)source);
        }
    }

    @Override
    public void addInputSources(List<SpoonResource> resources) {
        for (SpoonResource r : resources) {
            this.addInputSource(r);
        }
    }

    @Override
    public Set<File> getInputSources() {
        HashSet<File> files = new HashSet<File>();
        for (SpoonFolder file : this.getSource().getSubFolders()) {
            files.add(new File(file.getPath()));
        }
        return files;
    }

    @Override
    public void addTemplateSource(SpoonResource source) {
        if (source.isFile()) {
            this.templates.addFile((SpoonFile)source);
        } else {
            this.templates.addFolder((SpoonFolder)source);
        }
    }

    @Override
    public void addTemplateSource(File source) {
        try {
            if (SpoonResourceHelper.isFile(source)) {
                this.templates.addFile(SpoonResourceHelper.createFile(source));
            } else {
                this.templates.addFolder(SpoonResourceHelper.createFolder(source));
            }
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public void addTemplateSources(List<SpoonResource> resources) {
        for (SpoonResource r : resources) {
            this.addTemplateSource(r);
        }
    }

    @Override
    public Set<File> getTemplateSources() {
        HashSet<File> files = new HashSet<File>();
        for (SpoonFolder file : this.getTemplates().getSubFolders()) {
            files.add(new File(file.getPath()));
        }
        return files;
    }

    @Override
    public File getSourceOutputDirectory() {
        return this.factory.getEnvironment().getSourceOutputDirectory();
    }

    @Override
    public void setBinaryOutputDirectory(File binaryOutputDirectory) {
        this.getEnvironment().setBinaryOutputDirectory(binaryOutputDirectory.getAbsolutePath());
    }

    @Override
    public File getBinaryOutputDirectory() {
        return new File(this.getEnvironment().getBinaryOutputDirectory());
    }

    @Override
    public String[] getSourceClasspath() {
        return this.getEnvironment().getSourceClasspath();
    }

    @Override
    public void setSourceClasspath(String ... classpath) {
        this.getEnvironment().setSourceClasspath(classpath);
    }

    @Override
    public String[] getTemplateClasspath() {
        return this.templateClasspath;
    }

    @Override
    public void setTemplateClasspath(String ... classpath) {
        this.templateClasspath = classpath;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    protected boolean buildSources(JDTBuilder jdtBuilder) {
        return this.buildUnitsAndModel(jdtBuilder, this.sources, this.getSourceClasspath(), "");
    }

    protected JDTBatchCompiler createBatchCompiler() {
        return new JDTBatchCompiler(this);
    }

    protected JDTBatchCompiler createBatchCompiler(SpoonModelBuilder.InputType ... types) {
        JDTBatchCompiler batchCompiler = this.createBatchCompiler();
        if (types.length == 0) {
            types = new SpoonModelBuilder.InputType[]{SpoonModelBuilder.InputType.CTTYPES};
        }
        for (SpoonModelBuilder.InputType inputType : types) {
            inputType.initializeCompiler(batchCompiler);
        }
        return batchCompiler;
    }

    protected boolean buildTemplates(JDTBuilder jdtBuilder) {
        return this.buildUnitsAndModel(jdtBuilder, this.templates, this.getTemplateClasspath(), "template ");
    }

    protected boolean buildUnitsAndModel(JDTBuilder jdtBuilder, SpoonFolder sourcesFolder, String[] classpath, String debugMessagePrefix) {
        CompilationUnitDeclaration[] units = this.buildUnits(jdtBuilder, sourcesFolder, classpath, debugMessagePrefix);
        this.buildModel(units);
        return this.probs.isEmpty();
    }

    protected CompilationUnitDeclaration[] buildUnits(JDTBuilder jdtBuilder, SpoonFolder sourcesFolder, String[] classpath, String debugMessagePrefix) {
        Object[] args;
        List<SpoonFile> sourceFiles = Collections.unmodifiableList(sourcesFolder.getAllJavaFiles());
        if (sourceFiles.isEmpty()) {
            return EMPTY_RESULT;
        }
        JDTBatchCompiler batchCompiler = this.createBatchCompiler(new FileCompilerConfig(sourceFiles));
        if (jdtBuilder == null) {
            Object classpathOptions = ((ClasspathOptions)new ClasspathOptions().encoding(this.getEnvironment().getEncoding().displayName())).classpath(classpath);
            Object complianceOptions = new ComplianceOptions().compliance(this.javaCompliance);
            if (this.factory.getEnvironment().isPreviewFeaturesEnabled()) {
                ((ComplianceOptions)complianceOptions).enablePreview();
            }
            Object advancedOptions = ((AdvancedOptions)((AdvancedOptions)new AdvancedOptions().preserveUnusedVars()).continueExecution()).enableJavadoc();
            Object sourceOptions = new SourceOptions().sources(sourceFiles);
            args = new JDTBuilderImpl().classpathOptions((ClasspathOptions<?>)classpathOptions).complianceOptions((ComplianceOptions<?>)complianceOptions).advancedOptions((AdvancedOptions<?>)advancedOptions).sources((SourceOptions<?>)sourceOptions).build();
        } else {
            args = jdtBuilder.build();
        }
        this.getFactory().getEnvironment().debugMessage(debugMessagePrefix + "build args: " + Arrays.toString(args));
        batchCompiler.configure((String[])args);
        return batchCompiler.getUnits();
    }

    protected List<CompilationUnitDeclaration> sortCompilationUnits(CompilationUnitDeclaration[] units) {
        ArrayList<CompilationUnitDeclaration> unitList = new ArrayList<CompilationUnitDeclaration>(Arrays.asList(units));
        if (this.sortList) {
            unitList.sort(new FixedOrderBasedOnFileNameCompilationUnitComparator());
        } else {
            Collections.shuffle(unitList);
        }
        return unitList;
    }

    protected void buildModel(CompilationUnitDeclaration[] units) {
        JDTTreeBuilder builder = new JDTTreeBuilder(this.factory);
        List<CompilationUnitDeclaration> unitList = this.sortCompilationUnits(units);
        this.forEachCompilationUnit(unitList, SpoonProgress.Process.MODEL, unit -> unit.traverse((ASTVisitor)builder, unit.scope));
        this.forEachCompilationUnit(unitList, SpoonProgress.Process.IMPORT, unit -> new JDTImportBuilder((CompilationUnitDeclaration)unit, this.factory).build());
        if (this.getFactory().getEnvironment().isCommentsEnabled()) {
            this.forEachCompilationUnit(unitList, SpoonProgress.Process.COMMENT_LINKING, unit -> {
                try {
                    new JDTCommentBuilder((CompilationUnitDeclaration)unit, this.factory).build();
                }
                catch (Exception e) {
                    this.getEnvironment().report(null, Level.ERROR, "JDTCommentBuilder crashed with the error, some comments may be missing in the model: " + e.toString());
                }
            });
        }
    }

    private void forEachCompilationUnit(List<CompilationUnitDeclaration> unitList, SpoonProgress.Process process, Consumer<CompilationUnitDeclaration> consumer) {
        if (this.getEnvironment().getSpoonProgress() != null) {
            this.getEnvironment().getSpoonProgress().start(process);
        }
        int i2 = 0;
        for (CompilationUnitDeclaration unit : unitList) {
            if (unit.isModuleInfo() && this.factory.getEnvironment().getComplianceLevel() < 9) {
                throw new SpoonException("Modules are only available since Java 9. Please set appropriate compliance level.");
            }
            if (!unit.isModuleInfo() && unit.isEmpty()) continue;
            String unitPath = new String(unit.getFileName());
            if (this.canProcessCompilationUnit(unitPath)) {
                consumer.accept(unit);
            }
            if (this.getEnvironment().getSpoonProgress() == null) continue;
            this.getEnvironment().getSpoonProgress().step(process, unitPath, ++i2, unitList.size());
        }
        if (this.getEnvironment().getSpoonProgress() != null) {
            this.getEnvironment().getSpoonProgress().end(process);
        }
    }

    private boolean canProcessCompilationUnit(String unitPath) {
        for (CompilationUnitFilter cuf : this.compilationUnitFilters) {
            if (!cuf.exclude(unitPath)) continue;
            return false;
        }
        return true;
    }

    protected void generateProcessedSourceFilesUsingTypes(Filter<CtType<?>> typeFilter) {
        if (this.factory.getEnvironment().getDefaultFileGenerator() != null) {
            this.factory.getEnvironment().debugMessage("Generating source using types...");
            QueueProcessingManager processing = new QueueProcessingManager(this.factory);
            processing.addProcessor(this.factory.getEnvironment().getDefaultFileGenerator());
            if (typeFilter != null) {
                processing.process(Query.getElements(this.factory.getModel().getUnnamedModule(), typeFilter));
            } else {
                processing.process(this.factory.getModel().getAllModules());
            }
        }
    }

    protected void generateProcessedSourceFilesUsingCUs() {
        File outputDirectory = this.getSourceOutputDirectory();
        this.factory.getEnvironment().debugMessage("Generating source using compilation units...");
        if (outputDirectory == null) {
            throw new RuntimeException("You should set output directory before generating source files");
        }
        if (outputDirectory.isFile()) {
            throw new RuntimeException("Output must be a directory");
        }
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        try {
            outputDirectory = outputDirectory.getCanonicalFile();
        }
        catch (IOException e1) {
            throw new SpoonException(e1);
        }
        this.factory.getEnvironment().debugMessage("Generating source files to: " + outputDirectory);
        ArrayList<File> printedFiles = new ArrayList<File>();
        for (CompilationUnit cu : this.factory.CompilationUnit().getMap().values()) {
            if (cu.getDeclaredTypes().isEmpty()) continue;
            CtType<?> element = cu.getMainType();
            CtPackage pack = element.getPackage();
            File packageDir = pack.isUnnamedPackage() ? new File(outputDirectory.getAbsolutePath()) : new File(outputDirectory.getAbsolutePath() + File.separatorChar + pack.getQualifiedName().replace('.', File.separatorChar));
            if (!packageDir.exists() && !packageDir.mkdirs()) {
                throw new RuntimeException("Error creating output directory");
            }
            try {
                File file = new File(packageDir.getAbsolutePath() + File.separatorChar + element.getSimpleName() + ".java");
                file.createNewFile();
                try (InputStream is = this.getCompilationUnitInputStream(cu);
                     FileOutputStream outFile = new FileOutputStream(file);){
                    IOUtils.copy(is, (OutputStream)outFile);
                }
                if (printedFiles.contains(file)) continue;
                printedFiles.add(file);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SpoonException(e);
            }
        }
    }

    public void setEnvironment(INameEnvironment environment) {
        this.environment = environment;
    }

    public void reportProblem(CategorizedProblem pb) {
        if (pb == null) {
            return;
        }
        if (pb.getID() == 16777539) {
            if (!this.getFactory().getEnvironment().isIgnoreDuplicateDeclarations()) {
                throw new ModelBuildingException(pb.getMessage());
            }
        } else {
            this.probs.add(pb);
        }
    }

    public void reportProblemsWhenCompiling(Environment environment) {
        for (CategorizedProblem problem : this.getProblems()) {
            if (problem == null) continue;
            String message = problem.getMessage() + " at " + new String(problem.getOriginatingFileName()) + ":" + problem.getSourceLineNumber();
            if (problem.isError()) {
                throw new SnippetCompilationError(message);
            }
            environment.report(null, Level.WARN, message);
        }
    }

    public void reportProblems(Environment environment) {
        if (!this.getProblems().isEmpty()) {
            for (CategorizedProblem problem : this.getProblems()) {
                if (problem == null) continue;
                this.report(environment, problem);
            }
        }
    }

    protected void report(Environment environment, CategorizedProblem problem) {
        if (problem == null) {
            throw new IllegalArgumentException("problem cannot be null");
        }
        File file = new File(new String(problem.getOriginatingFileName()));
        String message = problem.getMessage() + " at " + file.getAbsolutePath() + ":" + problem.getSourceLineNumber();
        if (problem.isError()) {
            if (!environment.getNoClasspath()) {
                throw new ModelBuildingException(message);
            }
            int problemId = problem.getID();
            if (problemId != 0x1000002 && problemId != 0x22000032 && problemId != 268435846) {
                environment.report(null, Level.WARN, message);
            }
        }
    }

    public List<CategorizedProblem> getProblems() {
        return Collections.unmodifiableList(this.probs);
    }

    public SpoonFolder getSource() {
        return this.sources;
    }

    public SpoonFolder getTemplates() {
        return this.templates;
    }

    protected InputStream getCompilationUnitInputStream(CompilationUnit cu) {
        Environment env = this.factory.getEnvironment();
        List<CtType<?>> toBePrinted = cu.getDeclaredTypes();
        PrettyPrinter printer = env.createPrettyPrinter();
        printer.calculate(cu, toBePrinted);
        return new ByteArrayInputStream(printer.getResult().getBytes(env.getEncoding()));
    }

    protected Environment getEnvironment() {
        return this.getFactory().getEnvironment();
    }

    @Override
    public void addCompilationUnitFilter(CompilationUnitFilter filter) {
        this.compilationUnitFilters.add(filter);
    }

    @Override
    public void removeCompilationUnitFilter(CompilationUnitFilter filter) {
        this.compilationUnitFilters.remove(filter);
    }

    @Override
    public List<CompilationUnitFilter> getCompilationUnitFilter() {
        return new ArrayList<CompilationUnitFilter>(this.compilationUnitFilters);
    }
}

