/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.PositionBuilder;

class JDTImportBuilder {
    private final CompilationUnitDeclaration declarationUnit;
    private String filePath;
    private CompilationUnit spoonUnit;
    private ICompilationUnit sourceUnit;
    private Factory factory;
    private Set<CtImport> imports;

    JDTImportBuilder(CompilationUnitDeclaration declarationUnit, Factory factory) {
        this.declarationUnit = declarationUnit;
        this.factory = factory;
        this.sourceUnit = declarationUnit.compilationResult.compilationUnit;
        this.filePath = CharOperation.charToString(this.sourceUnit.getFileName());
        this.spoonUnit = JDTTreeBuilder.getOrCreateCompilationUnit(declarationUnit, factory);
        this.imports = new HashSet<CtImport>();
    }

    void build() {
        if (this.declarationUnit.imports == null || this.declarationUnit.imports.length == 0) {
            return;
        }
        for (ImportReference importRef : this.declarationUnit.imports) {
            int lastDot;
            String importName = importRef.toString();
            if (!importRef.isStatic()) {
                if (importName.endsWith("*")) {
                    lastDot = importName.lastIndexOf(46);
                    String packageName = importName.substring(0, lastDot);
                    CtPackage ctPackage = this.factory.Package().get(packageName);
                    if (ctPackage != null) {
                        this.imports.add(this.createImportWithPosition(ctPackage.getReference(), importRef));
                        continue;
                    }
                    if (!this.factory.getEnvironment().getNoClasspath()) continue;
                    this.imports.add(this.createUnresolvedImportWithPosition(importName, false, importRef));
                    continue;
                }
                CtType klass = this.getOrLoadClass(importName);
                if (klass != null) {
                    this.imports.add(this.createImportWithPosition(klass.getReference(), importRef));
                    continue;
                }
                if (!this.factory.getEnvironment().getNoClasspath()) continue;
                this.imports.add(this.createUnresolvedImportWithPosition(importName, false, importRef));
                continue;
            }
            lastDot = importName.lastIndexOf(46);
            String className = importName.substring(0, lastDot);
            String methodOrFieldName = importName.substring(lastDot + 1);
            CtType klass = this.getOrLoadClass(className);
            if (klass != null) {
                List<CtMethod<?>> methods;
                if ("*".equals(methodOrFieldName)) {
                    this.imports.add(this.createImportWithPosition(this.factory.Type().createTypeMemberWildcardImportReference((CtTypeReference)klass.getReference()), importRef));
                    continue;
                }
                CtNamedElement methodOrField = null;
                methodOrField = klass.getField(methodOrFieldName);
                if (methodOrField == null && (methods = klass.getMethodsByName(methodOrFieldName)).size() > 0) {
                    methodOrField = methods.get(0);
                }
                if (methodOrField == null) continue;
                this.imports.add(this.createImportWithPosition(methodOrField.getReference(), importRef));
                continue;
            }
            if (!this.factory.getEnvironment().getNoClasspath()) continue;
            this.imports.add(this.createUnresolvedImportWithPosition(importName, true, importRef));
        }
        this.spoonUnit.setImports(this.imports);
    }

    private CtImport createImportWithPosition(CtReference ref, ImportReference importRef) {
        char[] content = this.sourceUnit.getContents();
        CtImport imprt = this.factory.Type().createImport(ref);
        int declStart = importRef.declarationSourceStart;
        int commentStart = PositionBuilder.findNextNonWhitespace(false, content, declStart, PositionBuilder.findPrevNonWhitespace(content, 0, declStart - 1) + 1);
        imprt.setPosition(this.factory.Core().createCompoundSourcePosition(this.spoonUnit, importRef.sourceStart(), importRef.sourceEnd(), commentStart, importRef.declarationEnd, this.spoonUnit.getLineSeparatorPositions()));
        imprt.getReference().setPosition(this.factory.Core().createSourcePosition(this.spoonUnit, importRef.sourceStart(), importRef.sourceEnd(), this.spoonUnit.getLineSeparatorPositions()));
        return imprt;
    }

    private CtImport createUnresolvedImportWithPosition(String ref, boolean isStatic, ImportReference importRef) {
        char[] content = this.sourceUnit.getContents();
        CtImport imprt = this.factory.Type().createUnresolvedImport(ref, isStatic);
        int declStart = importRef.declarationSourceStart;
        int commentStart = PositionBuilder.findNextNonWhitespace(false, content, declStart, PositionBuilder.findPrevNonWhitespace(content, 0, declStart - 1) + 1);
        imprt.setPosition(this.factory.Core().createCompoundSourcePosition(this.spoonUnit, importRef.sourceStart(), importRef.sourceEnd(), commentStart, importRef.declarationEnd, this.spoonUnit.getLineSeparatorPositions()));
        return imprt;
    }

    private CtType getOrLoadClass(String className) {
        CtType klass = this.factory.Type().get(className);
        if (klass == null && (klass = this.factory.Interface().get(className)) == null) {
            try {
                Class<?> zeClass = this.loadClass(className);
                klass = this.factory.Type().get(zeClass);
                return klass;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                if (!className.contains("$") && className.contains(".")) {
                    int lastIndexOfDot = className.lastIndexOf(".");
                    String classNameWithInnerSep = className.substring(0, lastIndexOfDot) + "$" + className.substring(lastIndexOfDot + 1);
                    return this.getOrLoadClass(classNameWithInnerSep);
                }
                return null;
            }
        }
        return klass;
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> zeClass = this.factory.getEnvironment().getInputClassLoader() != null ? this.factory.getEnvironment().getInputClassLoader().loadClass(className) : this.getClass().getClassLoader().loadClass(className);
        return zeClass;
    }
}

