/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Receiver;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.ast.YieldStatement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import spoon.SpoonException;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.LiteralBase;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderHelper;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.ParentExiter;
import spoon.support.compiler.jdt.PositionBuilder;
import spoon.support.compiler.jdt.ReferenceBuilder;
import spoon.support.reflect.CtExtendedModifier;

public class JDTTreeBuilder
extends ASTVisitor {
    private final PositionBuilder position;
    private final ContextBuilder context;
    private final ParentExiter exiter;
    final ReferenceBuilder references;
    private final JDTTreeBuilderHelper helper;
    private final Factory factory;
    boolean skipTypeInAnnotation = false;
    private static final Logger LOGGER = LogManager.getLogger();

    public static Logger getLogger() {
        return LOGGER;
    }

    public PositionBuilder getPositionBuilder() {
        return this.position;
    }

    public ContextBuilder getContextBuilder() {
        return this.context;
    }

    public ReferenceBuilder getReferencesBuilder() {
        return this.references;
    }

    public JDTTreeBuilderHelper getHelper() {
        return this.helper;
    }

    public ParentExiter getExiter() {
        return this.exiter;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public JDTTreeBuilder(Factory factory) {
        this.factory = factory;
        this.position = new PositionBuilder(this);
        this.context = new ContextBuilder(this);
        this.exiter = new ParentExiter(this);
        this.references = new ReferenceBuilder(this);
        this.helper = new JDTTreeBuilderHelper(this);
    }

    private LiteralBase getBase(NumberLiteral numberLiteral) {
        String sourceString = new String(numberLiteral.source());
        if (sourceString.startsWith("0x") || sourceString.startsWith("0X")) {
            return LiteralBase.HEXADECIMAL;
        }
        if (sourceString.startsWith("0b") || sourceString.startsWith("0B")) {
            return LiteralBase.BINARY;
        }
        if (sourceString.startsWith("0") && (numberLiteral instanceof IntLiteral && sourceString.length() > 1 || numberLiteral instanceof LongLiteral && sourceString.length() > 2)) {
            return LiteralBase.OCTAL;
        }
        return LiteralBase.DECIMAL;
    }

    @Override
    public void endVisit(AllocationExpression allocationExpression, BlockScope scope) {
        this.context.exit(allocationExpression);
    }

    @Override
    public void endVisit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        this.context.exit(and_and_Expression);
    }

    @Override
    public void endVisit(AnnotationMethodDeclaration annotationTypeDeclaration, ClassScope classScope) {
        this.context.exit(annotationTypeDeclaration);
    }

    @Override
    public void endVisit(Argument argument, BlockScope scope) {
        this.context.exit(argument);
    }

    @Override
    public void endVisit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        this.context.exit(arrayAllocationExpression);
    }

    @Override
    public void endVisit(ArrayInitializer arrayInitializer, BlockScope scope) {
        this.context.exit(arrayInitializer);
    }

    @Override
    public void endVisit(ArrayReference arrayReference, BlockScope scope) {
        this.context.exit(arrayReference);
    }

    @Override
    public void endVisit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        this.context.exit(arrayTypeReference);
    }

    @Override
    public void endVisit(ArrayTypeReference arrayTypeReference, ClassScope scope) {
        this.context.exit(arrayTypeReference);
    }

    @Override
    public void endVisit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope scope) {
        this.context.exit(arrayQualifiedTypeReference);
    }

    @Override
    public void endVisit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope scope) {
        this.context.exit(arrayQualifiedTypeReference);
    }

    @Override
    public void endVisit(AssertStatement assertStatement, BlockScope scope) {
        this.context.exit(assertStatement);
    }

    @Override
    public void endVisit(Assignment assignment, BlockScope scope) {
        this.context.exit(assignment);
    }

    @Override
    public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
        this.context.exit(binaryExpression);
    }

    @Override
    public void endVisit(Block block, BlockScope scope) {
        this.context.exit(block);
    }

    @Override
    public void endVisit(BreakStatement breakStatement, BlockScope scope) {
        this.context.exit(breakStatement);
    }

    @Override
    public void endVisit(CaseStatement caseStatement, BlockScope scope) {
    }

    @Override
    public void endVisit(CharLiteral charLiteral, BlockScope scope) {
        this.context.exit(charLiteral);
    }

    @Override
    public void endVisit(ClassLiteralAccess classLiteral, BlockScope scope) {
        this.context.exit(classLiteral);
    }

    @Override
    public void endVisit(CompoundAssignment compoundAssignment, BlockScope scope) {
        this.context.exit(compoundAssignment);
    }

    @Override
    public void endVisit(ConditionalExpression conditionalExpression, BlockScope scope) {
        this.context.exit(conditionalExpression);
    }

    @Override
    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        this.context.exit(constructorDeclaration);
    }

    @Override
    public void endVisit(ContinueStatement continueStatement, BlockScope scope) {
        this.context.exit(continueStatement);
    }

    @Override
    public void endVisit(DoStatement doStatement, BlockScope scope) {
        this.context.exit(doStatement);
    }

    @Override
    public void endVisit(DoubleLiteral doubleLiteral, BlockScope scope) {
        this.context.exit(doubleLiteral);
    }

    @Override
    public void endVisit(EqualExpression equalExpression, BlockScope scope) {
        this.context.exit(equalExpression);
    }

    @Override
    public void endVisit(ExplicitConstructorCall explicitConstructor, BlockScope scope) {
        this.context.exit(explicitConstructor);
    }

    @Override
    public void endVisit(ExtendedStringLiteral extendedStringLiteral, BlockScope scope) {
        this.context.exit(extendedStringLiteral);
    }

    @Override
    public void endVisit(FalseLiteral falseLiteral, BlockScope scope) {
        this.context.exit(falseLiteral);
    }

    @Override
    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.context.exit(fieldDeclaration);
    }

    @Override
    public void endVisit(FieldReference fieldReference, BlockScope scope) {
        this.context.exit(fieldReference);
    }

    @Override
    public void endVisit(FloatLiteral floatLiteral, BlockScope scope) {
        this.context.exit(floatLiteral);
    }

    @Override
    public void endVisit(ForeachStatement forStatement, BlockScope scope) {
        this.context.exit(forStatement);
    }

    @Override
    public void endVisit(ForStatement forStatement, BlockScope scope) {
        this.context.exit(forStatement);
    }

    @Override
    public void endVisit(IfStatement ifStatement, BlockScope scope) {
        this.context.exit(ifStatement);
    }

    @Override
    public void endVisit(Initializer initializer, MethodScope scope) {
        this.context.exit(initializer);
    }

    @Override
    public void endVisit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        this.context.exit(instanceOfExpression);
    }

    @Override
    public void endVisit(IntLiteral intLiteral, BlockScope scope) {
        this.context.exit(intLiteral);
    }

    @Override
    public void endVisit(LabeledStatement labeledStatement, BlockScope scope) {
        Object childStmt;
        ASTPair pair = this.context.stack.peek();
        CtBlock block = (CtBlock)pair.element;
        if (block.getStatements().size() == 1 && (childStmt = block.getStatement(0)).getLabel() == null) {
            childStmt.setLabel(block.getLabel());
            SourcePosition oldPos = childStmt.getPosition();
            int newSourceStart = Math.min(oldPos.getSourceStart(), block.getPosition().getSourceStart());
            if (newSourceStart != oldPos.getSourceStart()) {
                childStmt.setPosition(block.getFactory().Core().createSourcePosition(oldPos.getCompilationUnit(), newSourceStart, oldPos.getSourceEnd(), oldPos.getCompilationUnit().getLineSeparatorPositions()));
            }
            this.context.exit(labeledStatement);
            CtElement parent = block.getParent();
            boolean parentIsImplicit = parent.isImplicit();
            block.replace((CtElement)childStmt);
            parent.setImplicit(parentIsImplicit);
            return;
        }
        this.context.exit(labeledStatement);
    }

    @Override
    public void endVisit(LocalDeclaration localDeclaration, BlockScope scope) {
        this.context.exit(localDeclaration);
    }

    @Override
    public void endVisit(LongLiteral longLiteral, BlockScope scope) {
        this.context.exit(longLiteral);
    }

    @Override
    public void endVisit(NormalAnnotation annotation, ClassScope scope) {
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(MarkerAnnotation annotation, ClassScope scope) {
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(MarkerAnnotation annotation, BlockScope scope) {
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(MemberValuePair pair, ClassScope scope) {
        if (!this.context.annotationValueName.pop().equals(new String(pair.name))) {
            throw new RuntimeException("Inconsistent Stack");
        }
    }

    @Override
    public void endVisit(MemberValuePair pair, BlockScope scope) {
        if (!this.context.annotationValueName.pop().equals(new String(pair.name))) {
            throw new RuntimeException("Inconsistent Stack");
        }
    }

    @Override
    public void endVisit(MessageSend messageSend, BlockScope scope) {
        this.context.exit(messageSend);
    }

    @Override
    public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
        this.context.exit(methodDeclaration);
    }

    @Override
    public void endVisit(NormalAnnotation annotation, BlockScope scope) {
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(NullLiteral nullLiteral, BlockScope scope) {
        this.context.exit(nullLiteral);
    }

    @Override
    public void endVisit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        this.context.exit(or_or_Expression);
    }

    @Override
    public void endVisit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(parameterizedQualifiedTypeReference);
    }

    @Override
    public void endVisit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(parameterizedQualifiedTypeReference);
    }

    @Override
    public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(parameterizedSingleTypeReference);
    }

    @Override
    public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(parameterizedSingleTypeReference);
    }

    @Override
    public void endVisit(PostfixExpression postfixExpression, BlockScope scope) {
        this.context.exit(postfixExpression);
    }

    @Override
    public void endVisit(PrefixExpression prefixExpression, BlockScope scope) {
        this.context.exit(prefixExpression);
    }

    @Override
    public void endVisit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        this.endVisit((AllocationExpression)qualifiedAllocationExpression, scope);
    }

    @Override
    public void endVisit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
        if (this.context.stack.peek().node == qualifiedNameReference) {
            this.context.exit(qualifiedNameReference);
        }
    }

    @Override
    public void endVisit(QualifiedThisReference qualifiedThisReference, BlockScope scope) {
        this.endVisit((ThisReference)qualifiedThisReference, scope);
    }

    @Override
    public void endVisit(QualifiedTypeReference qualifiedTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(qualifiedTypeReference);
    }

    @Override
    public void endVisit(QualifiedTypeReference qualifiedTypeReference, ClassScope scope) {
        this.endVisit(qualifiedTypeReference, (BlockScope)null);
    }

    @Override
    public void endVisit(ReturnStatement returnStatement, BlockScope scope) {
        this.context.exit(returnStatement);
    }

    @Override
    public void endVisit(SingleMemberAnnotation annotation, BlockScope scope) {
        if (!"value".equals(this.context.annotationValueName.pop())) {
            throw new RuntimeException("Inconsistent Stack");
        }
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(SingleNameReference singleNameReference, BlockScope scope) {
        if (this.context.stack.peek().node == singleNameReference) {
            this.context.exit(singleNameReference);
        }
    }

    @Override
    public void endVisit(SingleTypeReference singleTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(singleTypeReference);
    }

    @Override
    public void endVisit(SingleTypeReference singleTypeReference, ClassScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(singleTypeReference);
    }

    @Override
    public void endVisit(StringLiteral stringLiteral, BlockScope scope) {
        this.context.exit(stringLiteral);
    }

    @Override
    public void endVisit(StringLiteralConcatenation literal, BlockScope scope) {
        this.context.exit(literal);
    }

    @Override
    public void endVisit(QualifiedSuperReference qualifiedsuperReference, BlockScope scope) {
        this.context.exit(qualifiedsuperReference);
    }

    @Override
    public void endVisit(SuperReference superReference, BlockScope scope) {
        this.context.exit(superReference);
    }

    @Override
    public void endVisit(QualifiedThisReference qualifiedThisReference, ClassScope scope) {
        super.endVisit(qualifiedThisReference, scope);
        this.context.exit(qualifiedThisReference);
    }

    @Override
    public void endVisit(ThisReference thisReference, BlockScope scope) {
        this.context.exit(thisReference);
    }

    @Override
    public void endVisit(SwitchStatement switchStatement, BlockScope scope) {
        if (this.context.stack.peek().node instanceof CaseStatement) {
            this.context.exit(this.context.stack.peek().node);
        }
        this.context.exit(switchStatement);
    }

    @Override
    public void endVisit(SwitchExpression switchExpression, BlockScope scope) {
        if (this.context.stack.peek().node instanceof CaseStatement) {
            this.context.exit(this.context.stack.peek().node);
        }
        this.context.exit(switchExpression);
    }

    @Override
    public void endVisit(SynchronizedStatement synchronizedStatement, BlockScope scope) {
        this.context.exit(synchronizedStatement);
    }

    @Override
    public void endVisit(ThrowStatement throwStatement, BlockScope scope) {
        this.context.exit(throwStatement);
    }

    @Override
    public void endVisit(TrueLiteral trueLiteral, BlockScope scope) {
        this.context.exit(trueLiteral);
    }

    @Override
    public void endVisit(TryStatement tryStatement, BlockScope scope) {
        this.context.exit(tryStatement);
    }

    @Override
    public void endVisit(TypeParameter typeParameter, BlockScope scope) {
        this.context.exit(typeParameter);
    }

    @Override
    public void endVisit(TypeParameter typeParameter, ClassScope scope) {
        this.context.exit(typeParameter);
    }

    @Override
    public void endVisit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        this.context.exit(localTypeDeclaration);
    }

    @Override
    public void endVisit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        while (!this.context.stack.isEmpty() && this.context.stack.peek().node == memberTypeDeclaration) {
            this.context.exit(memberTypeDeclaration);
        }
    }

    @Override
    public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        while (!this.context.stack.isEmpty() && this.context.stack.peek().node == typeDeclaration) {
            this.context.exit(typeDeclaration);
        }
    }

    @Override
    public void endVisit(UnaryExpression unaryExpression, BlockScope scope) {
        this.context.exit(unaryExpression);
    }

    @Override
    public void endVisit(WhileStatement whileStatement, BlockScope scope) {
        this.context.exit(whileStatement);
    }

    @Override
    public void endVisit(CompilationUnitDeclaration compilationUnitDeclaration, CompilationUnitScope scope) {
        this.context.compilationunitdeclaration = null;
        this.context.compilationUnitSpoon = null;
    }

    @Override
    public boolean visit(Javadoc javadoc, BlockScope scope) {
        return false;
    }

    @Override
    public boolean visit(Javadoc javadoc, ClassScope scope) {
        return false;
    }

    static CompilationUnit getOrCreateCompilationUnit(CompilationUnitDeclaration compilationUnitDeclaration, Factory factory) {
        CompilationUnit compilationUnitSpoon = factory.CompilationUnit().getOrCreate(new String(compilationUnitDeclaration.getFileName()));
        if (compilationUnitSpoon.getLineSeparatorPositions() == null) {
            compilationUnitSpoon.setLineSeparatorPositions(compilationUnitDeclaration.compilationResult.lineSeparatorPositions);
        } else if (compilationUnitSpoon.getLineSeparatorPositions() != compilationUnitDeclaration.compilationResult.lineSeparatorPositions) {
            throw new SpoonException("Unexpected CompilationUnit lineSeparatorPositions");
        }
        return compilationUnitSpoon;
    }

    @Override
    public boolean visit(CompilationUnitDeclaration compilationUnitDeclaration, CompilationUnitScope scope) {
        ImportReference packageRef;
        this.context.compilationunitdeclaration = scope.referenceContext;
        this.context.compilationUnitSpoon = JDTTreeBuilder.getOrCreateCompilationUnit(this.context.compilationunitdeclaration, this.getFactory());
        ModuleBinding enclosingModule = scope.fPackage.enclosingModule;
        CtModule module = !enclosingModule.isUnnamed() && enclosingModule.shortReadableName() != null && enclosingModule.shortReadableName().length > 0 ? this.getFactory().Module().getOrCreate(String.valueOf(enclosingModule.shortReadableName())) : this.getFactory().Module().getUnnamedModule();
        this.context.compilationUnitSpoon.setDeclaredPackage(this.getFactory().Package().getOrCreate(CharOperation.toString(scope.currentPackageName), module));
        CtPackageDeclaration packageDeclaration = this.context.compilationUnitSpoon.getPackageDeclaration();
        if (packageDeclaration != null && (packageRef = compilationUnitDeclaration.currentPackage) != null) {
            char[] content = this.context.getCompilationUnitContents();
            int declStart = packageRef.declarationSourceStart;
            int firstComment = PositionBuilder.findNextNonWhitespace(false, content, packageRef.sourceStart(), 0);
            if (firstComment < packageRef.sourceStart() && content[firstComment] == '/' && content[firstComment + 1] == '*') {
                int commentEnd = PositionBuilder.getEndOfComment(content, packageRef.sourceStart(), firstComment);
                declStart = PositionBuilder.findNextNonWhitespace(false, content, packageRef.sourceStart(), commentEnd + 1);
            } else {
                declStart = firstComment;
            }
            packageDeclaration.setPosition(this.factory.Core().createCompoundSourcePosition(this.context.compilationUnitSpoon, packageRef.sourceStart(), packageRef.sourceEnd(), declStart, packageRef.declarationEnd, this.context.compilationUnitSpoon.getLineSeparatorPositions()));
            packageDeclaration.getReference().setPosition(this.factory.Core().createSourcePosition(this.context.compilationUnitSpoon, packageRef.sourceStart(), packageRef.sourceEnd(), this.context.compilationUnitSpoon.getLineSeparatorPositions()));
        }
        return true;
    }

    @Override
    public boolean visit(ReferenceExpression referenceExpression, BlockScope blockScope) {
        this.context.enter(this.helper.createExecutableReferenceExpression(referenceExpression), referenceExpression);
        return true;
    }

    @Override
    public void endVisit(ReferenceExpression referenceExpression, BlockScope blockScope) {
        this.context.exit(referenceExpression);
    }

    @Override
    public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
        CtLambda lambda = this.factory.Core().createLambda();
        MethodBinding methodBinding = lambdaExpression.getMethodBinding();
        if (methodBinding != null) {
            lambda.setSimpleName(CharOperation.charToString(methodBinding.constantPoolName()));
        }
        this.context.isBuildLambda = true;
        this.context.enter(lambda, lambdaExpression);
        return true;
    }

    @Override
    public void endVisit(LambdaExpression lambdaExpression, BlockScope blockScope) {
        this.context.isBuildLambda = false;
        this.context.exit(lambdaExpression);
    }

    @Override
    public boolean visit(AllocationExpression allocationExpression, BlockScope scope) {
        CtConstructorCall constructorCall = this.factory.Core().createConstructorCall();
        constructorCall.setExecutable(this.references.getExecutableReference(allocationExpression));
        ASTPair first = this.context.stack.getFirst();
        if (first.element instanceof CtEnumValue && allocationExpression.sourceEnd == first.node.sourceEnd) {
            constructorCall.setImplicit(true);
        }
        this.context.enter(constructorCall, allocationExpression);
        return true;
    }

    @Override
    public boolean visit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        CtConstructorCall constructorCall = qualifiedAllocationExpression.anonymousType != null ? this.factory.Core().createNewClass() : this.factory.Core().createConstructorCall();
        constructorCall.setExecutable(this.references.getExecutableReference(qualifiedAllocationExpression));
        this.context.enter(constructorCall, qualifiedAllocationExpression);
        return true;
    }

    @Override
    public boolean visit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(JDTTreeBuilderQuery.getBinaryOperatorKind((and_and_Expression.bits & 0xFC0) >> 6));
        this.context.enter(op, and_and_Expression);
        return true;
    }

    @Override
    public boolean visit(AnnotationMethodDeclaration annotationTypeDeclaration, ClassScope classScope) {
        CtAnnotationMethod ctAnnotationMethod = this.factory.Core().createAnnotationMethod();
        ctAnnotationMethod.setSimpleName(CharOperation.charToString(annotationTypeDeclaration.selector));
        this.context.enter(ctAnnotationMethod, annotationTypeDeclaration);
        return true;
    }

    @Override
    public boolean visit(Argument argument, BlockScope scope) {
        if (this.getContextBuilder().stack.peekFirst().element instanceof CtTry) {
            this.context.enter(this.factory.Core().createCatch(), argument);
            return true;
        }
        boolean isVar = argument.type != null && argument.type.isTypeNameVar(scope);
        CtParameter p = this.helper.createParameter(argument);
        if (isVar) {
            p.setInferred(true);
        }
        this.context.enter(p, argument);
        return true;
    }

    @Override
    public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        this.context.enter(this.factory.Core().createNewArray(), arrayAllocationExpression);
        return true;
    }

    @Override
    public boolean visit(ArrayInitializer arrayInitializer, BlockScope scope) {
        this.context.enter(this.factory.Core().createNewArray(), arrayInitializer);
        return true;
    }

    @Override
    public boolean visit(ArrayReference arrayReference, BlockScope scope) {
        CtArrayAccess a = JDTTreeBuilderQuery.isLhsAssignment(this.context, arrayReference) ? this.factory.Core().createArrayWrite() : this.factory.Core().createArrayRead();
        this.context.enter(a, arrayReference);
        return true;
    }

    @Override
    public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        CtTypeReference objectCtTypeReference = this.references.buildTypeReference(arrayTypeReference, (Scope)scope);
        CtTypeAccess typeAccess = this.factory.Code().createTypeAccess(objectCtTypeReference);
        if (typeAccess.getAccessedType() instanceof CtArrayTypeReference) {
            CtTypeReference<?> arrayType = ((CtArrayTypeReference)typeAccess.getAccessedType()).getArrayType();
            arrayType.setAnnotations(this.references.buildTypeReference(arrayTypeReference, (Scope)scope).getAnnotations());
            arrayType.setSimplyQualified(true);
        }
        this.context.enter(typeAccess, arrayTypeReference);
        return true;
    }

    @Override
    public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope scope) {
        return this.visit(arrayTypeReference, (BlockScope)null);
    }

    @Override
    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope scope) {
        CtTypeAccess typeAccess = this.factory.Core().createTypeAccess();
        this.context.enter(typeAccess, arrayQualifiedTypeReference);
        CtArrayTypeReference arrayType = (CtArrayTypeReference)this.references.getTypeReference(arrayQualifiedTypeReference.resolvedType);
        typeAccess.setAccessedType(arrayType);
        if (arrayType != null) {
            arrayType.getArrayType().setAnnotations(this.references.buildTypeReference(arrayQualifiedTypeReference, (Scope)scope).getAnnotations());
        }
        return true;
    }

    @Override
    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope scope) {
        return this.visit(arrayQualifiedTypeReference, (BlockScope)null);
    }

    @Override
    public boolean visit(AssertStatement assertStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createAssert(), assertStatement);
        return true;
    }

    @Override
    public boolean visit(Assignment assignment, BlockScope scope) {
        this.context.enter(this.factory.Core().createAssignment(), assignment);
        return true;
    }

    @Override
    public boolean visit(CompoundAssignment compoundAssignment, BlockScope scope) {
        CtOperatorAssignment a = this.factory.Core().createOperatorAssignment();
        a.setKind(JDTTreeBuilderQuery.getBinaryOperatorKind(compoundAssignment.operator));
        this.context.enter(a, compoundAssignment);
        return true;
    }

    @Override
    public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(JDTTreeBuilderQuery.getBinaryOperatorKind((binaryExpression.bits & 0xFC0) >> 6));
        this.context.enter(op, binaryExpression);
        return true;
    }

    @Override
    public boolean visit(Block block, BlockScope scope) {
        this.context.enter(this.factory.Core().createBlock(), block);
        return true;
    }

    @Override
    public boolean visit(BreakStatement breakStatement, BlockScope scope) {
        CtBreak b = this.factory.Core().createBreak();
        if (breakStatement.label != null) {
            b.setTargetLabel(new String(breakStatement.label));
        }
        this.context.enter(b, breakStatement);
        return true;
    }

    @Override
    public boolean visit(CastExpression castExpression, BlockScope scope) {
        ContextBuilder.CastInfo ci = new ContextBuilder.CastInfo();
        ci.nrOfBrackets = castExpression.bits >>> 21 & 0xF;
        ci.typeRef = this.references.buildTypeReference(castExpression.type, scope, true);
        this.context.casts.add(ci);
        castExpression.expression.traverse((ASTVisitor)this, scope);
        return false;
    }

    @Override
    public boolean visit(CharLiteral charLiteral, BlockScope scope) {
        charLiteral.computeConstant();
        this.context.enter(this.factory.Code().createLiteral(Character.valueOf(charLiteral.constant.charValue())), charLiteral);
        return true;
    }

    @Override
    public boolean visit(ClassLiteralAccess classLiteral, BlockScope scope) {
        this.context.enter(this.factory.Code().createClassAccess(this.references.getTypeReference(classLiteral.targetType)), classLiteral);
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression conditionalExpression, BlockScope scope) {
        this.context.enter(this.factory.Core().createConditional(), conditionalExpression);
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        Receiver receiver;
        CtMethod m = this.factory.Core().createMethod();
        m.setSimpleName(CharOperation.charToString(methodDeclaration.selector));
        if (methodDeclaration.binding != null) {
            m.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(methodDeclaration.binding.modifiers, true, true));
        }
        for (CtExtendedModifier extendedModifier : JDTTreeBuilderQuery.getModifiers(methodDeclaration.modifiers, false, true)) {
            m.addModifier(extendedModifier.getKind());
        }
        m.setDefaultMethod(methodDeclaration.isDefaultMethod());
        this.context.enter(m, methodDeclaration);
        if (!methodDeclaration.isAbstract() && (methodDeclaration.modifiers & 0x100) == 0) {
            this.context.enter(this.getFactory().Core().createBlock(), methodDeclaration);
            this.context.exit(methodDeclaration);
        }
        if ((receiver = methodDeclaration.receiver) != null) {
            receiver.traverse((ASTVisitor)this, methodDeclaration.scope);
        }
        return true;
    }

    @Override
    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        CtConstructor c = this.factory.Core().createConstructor();
        if (scope != null && scope.referenceContext != null) {
            c.setImplicit(scope.referenceContext.sourceStart() == constructorDeclaration.sourceStart());
        }
        if (constructorDeclaration.binding != null) {
            c.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(constructorDeclaration.binding.modifiers, true, true));
        }
        if (!c.isImplicit()) {
            for (CtExtendedModifier extendedModifier : JDTTreeBuilderQuery.getModifiers(constructorDeclaration.modifiers, false, true)) {
                c.addModifier(extendedModifier.getKind());
            }
        }
        this.context.enter(c, constructorDeclaration);
        this.context.enter(this.factory.Core().createBlock(), constructorDeclaration);
        this.context.exit(constructorDeclaration);
        return true;
    }

    @Override
    public boolean visit(TypeParameter typeParameter, ClassScope scope) {
        return this.visitTypeParameter(typeParameter, scope);
    }

    @Override
    public boolean visit(TypeParameter typeParameter, BlockScope scope) {
        return this.visitTypeParameter(typeParameter, scope);
    }

    private boolean visitTypeParameter(TypeParameter typeParameter, Scope scope) {
        CtTypeParameter typeParameterRef = this.factory.Core().createTypeParameter();
        typeParameterRef.setSimpleName(CharOperation.charToString(typeParameter.name));
        this.context.enter(typeParameterRef, typeParameter);
        return true;
    }

    @Override
    public boolean visit(ContinueStatement continueStatement, BlockScope scope) {
        CtContinue c = this.factory.Core().createContinue();
        this.context.enter(c, continueStatement);
        if (continueStatement.label != null) {
            c.setTargetLabel(new String(continueStatement.label));
        }
        return true;
    }

    @Override
    public boolean visit(DoStatement doStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createDo(), doStatement);
        return true;
    }

    @Override
    public boolean visit(DoubleLiteral doubleLiteral, BlockScope scope) {
        doubleLiteral.computeConstant();
        CtLiteral<Double> l = this.factory.Code().createLiteral(doubleLiteral.constant.doubleValue());
        l.setBase(this.getBase(doubleLiteral));
        this.context.enter(l, doubleLiteral);
        return true;
    }

    @Override
    public boolean visit(EqualExpression equalExpression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(JDTTreeBuilderQuery.getBinaryOperatorKind((equalExpression.bits & 0xFC0) >> 6));
        this.context.enter(op, equalExpression);
        return true;
    }

    @Override
    public boolean visit(ExplicitConstructorCall explicitConstructor, BlockScope scope) {
        CtInvocation inv = this.factory.Core().createInvocation();
        inv.setImplicit(explicitConstructor.isImplicitSuper());
        inv.setExecutable(this.references.getExecutableReference(explicitConstructor.binding));
        CtTypeReference<?> declaringType = inv.getExecutable().getDeclaringType();
        inv.getExecutable().setType(declaringType == null ? null : declaringType.clone());
        this.context.enter(inv, explicitConstructor);
        return true;
    }

    @Override
    public boolean visit(ExtendedStringLiteral extendedStringLiteral, BlockScope scope) {
        this.context.enter(this.factory.Code().createLiteral(CharOperation.charToString(extendedStringLiteral.source())), extendedStringLiteral);
        return true;
    }

    @Override
    public boolean visit(FalseLiteral falseLiteral, BlockScope scope) {
        this.context.enter(this.factory.Code().createLiteral(false), falseLiteral);
        return true;
    }

    @Override
    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        CtField field;
        if (fieldDeclaration.type != null) {
            field = this.factory.Core().createField();
        } else {
            field = this.factory.Core().createEnumValue();
            if (fieldDeclaration.binding != null) {
                field.setType(this.references.getTypeReference(fieldDeclaration.binding.type));
            }
        }
        field.setSimpleName(CharOperation.charToString(fieldDeclaration.name));
        if (fieldDeclaration.binding != null) {
            if (fieldDeclaration.binding.declaringClass != null && fieldDeclaration.binding.declaringClass.isEnum() && field instanceof CtEnumValue) {
                field.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(fieldDeclaration.binding.declaringClass.modifiers, true, false));
            } else {
                field.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(fieldDeclaration.binding.modifiers, true, false));
            }
        }
        for (CtExtendedModifier extendedModifier : JDTTreeBuilderQuery.getModifiers(fieldDeclaration.modifiers, false, false)) {
            field.addModifier(extendedModifier.getKind());
        }
        this.context.enter(field, fieldDeclaration);
        return true;
    }

    @Override
    public boolean visit(FieldReference fieldReference, BlockScope scope) {
        this.context.enter(this.helper.createFieldAccess(fieldReference), fieldReference);
        return true;
    }

    @Override
    public boolean visit(FloatLiteral floatLiteral, BlockScope scope) {
        floatLiteral.computeConstant();
        CtLiteral<Float> l = this.factory.Code().createLiteral(Float.valueOf(floatLiteral.constant.floatValue()));
        l.setBase(this.getBase(floatLiteral));
        this.context.enter(l, floatLiteral);
        return true;
    }

    @Override
    public boolean visit(ForeachStatement forStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createForEach(), forStatement);
        return true;
    }

    @Override
    public boolean visit(ForStatement forStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createFor(), forStatement);
        return true;
    }

    @Override
    public boolean visit(IfStatement ifStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createIf(), ifStatement);
        return true;
    }

    @Override
    public boolean visit(Initializer initializer, MethodScope scope) {
        CtAnonymousExecutable b = this.factory.Core().createAnonymousExecutable();
        if (initializer.isStatic()) {
            b.addModifier(ModifierKind.STATIC);
        }
        this.context.enter(b, initializer);
        return true;
    }

    @Override
    public boolean visit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(BinaryOperatorKind.INSTANCEOF);
        this.context.enter(op, instanceOfExpression);
        return true;
    }

    @Override
    public boolean visit(IntLiteral intLiteral, BlockScope scope) {
        intLiteral.computeConstant();
        CtLiteral<Integer> l = this.factory.Code().createLiteral(intLiteral.constant.intValue());
        l.setBase(this.getBase(intLiteral));
        this.context.enter(l, intLiteral);
        return true;
    }

    @Override
    public boolean visit(LabeledStatement labeledStatement, BlockScope scope) {
        CtBlock block = this.factory.Core().createBlock();
        block.setLabel(new String(labeledStatement.label));
        this.context.enter(block, labeledStatement);
        block.setImplicit(true);
        return true;
    }

    @Override
    public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
        CtLocalVariable v = this.factory.Core().createLocalVariable();
        boolean isVar = localDeclaration.type.isTypeNameVar(scope);
        if (isVar) {
            v.setInferred(true);
        }
        v.setSimpleName(CharOperation.charToString(localDeclaration.name));
        if (localDeclaration.binding != null) {
            v.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(localDeclaration.binding.modifiers, true, false));
        }
        for (CtExtendedModifier extendedModifier : JDTTreeBuilderQuery.getModifiers(localDeclaration.modifiers, false, false)) {
            v.addModifier(extendedModifier.getKind());
        }
        this.context.enter(v, localDeclaration);
        return true;
    }

    @Override
    public boolean visit(LongLiteral longLiteral, BlockScope scope) {
        longLiteral.computeConstant();
        CtLiteral<Long> l = this.factory.Code().createLiteral(longLiteral.constant.longValue());
        l.setBase(this.getBase(longLiteral));
        this.context.enter(l, longLiteral);
        return true;
    }

    @Override
    public boolean visit(NormalAnnotation annotation, ClassScope scope) {
        return this.visitNormalAnnotation(annotation, scope);
    }

    @Override
    public boolean visit(NormalAnnotation annotation, BlockScope scope) {
        return this.visitNormalAnnotation(annotation, scope);
    }

    @Override
    public boolean visit(MarkerAnnotation annotation, ClassScope scope) {
        return this.visitMarkerAnnotation(annotation, scope);
    }

    @Override
    public boolean visit(MarkerAnnotation annotation, BlockScope scope) {
        return this.visitMarkerAnnotation(annotation, scope);
    }

    @Override
    public boolean visit(SingleMemberAnnotation annotation, BlockScope scope) {
        this.visitMarkerAnnotation(annotation, scope);
        this.context.annotationValueName.push("value");
        return true;
    }

    private <A extends java.lang.annotation.Annotation> boolean visitNormalAnnotation(NormalAnnotation annotation, Scope scope) {
        this.context.enter(this.factory.Code().createAnnotation(this.references.getTypeReference(annotation.resolvedType)), annotation);
        this.skipTypeInAnnotation = true;
        return true;
    }

    private <A extends java.lang.annotation.Annotation> boolean visitMarkerAnnotation(Annotation annotation, Scope scope) {
        this.context.enter(this.factory.Code().createAnnotation(this.references.getTypeReference(annotation.resolvedType, annotation.type)), annotation);
        this.skipTypeInAnnotation = true;
        return true;
    }

    @Override
    public boolean visit(MemberValuePair pair, ClassScope scope) {
        this.context.annotationValueName.push(new String(pair.name));
        return true;
    }

    @Override
    public boolean visit(MemberValuePair pair, BlockScope scope) {
        this.context.annotationValueName.push(new String(pair.name));
        return true;
    }

    @Override
    public boolean visit(MessageSend messageSend, BlockScope scope) {
        CtInvocation inv = this.factory.Core().createInvocation();
        inv.setExecutable(this.references.getExecutableReference(messageSend));
        if (messageSend.binding instanceof ProblemMethodBinding) {
            if (inv.getExecutable() != null && inv.getExecutable().getDeclaringType() != null) {
                inv.setTarget(this.factory.Code().createTypeAccess(inv.getExecutable().getDeclaringType(), inv.getExecutable().getDeclaringType().isAnonymous()));
            }
            if (messageSend.expectedType() != null) {
                inv.getExecutable().setType(this.references.getTypeReference(messageSend.expectedType()));
            }
        }
        this.context.enter(inv, messageSend);
        return true;
    }

    @Override
    public boolean visit(NullLiteral nullLiteral, BlockScope scope) {
        this.context.enter(this.factory.Code().createLiteral(null), nullLiteral);
        return true;
    }

    @Override
    public boolean visit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(JDTTreeBuilderQuery.getBinaryOperatorKind((or_or_Expression.bits & 0xFC0) >> 6));
        this.context.enter(op, or_or_Expression);
        return true;
    }

    @Override
    public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope scope) {
        return this.createParameterizedType(parameterizedQualifiedTypeReference);
    }

    @Override
    public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope scope) {
        return this.createParameterizedType(parameterizedQualifiedTypeReference);
    }

    @Override
    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope scope) {
        return this.createParameterizedType(parameterizedSingleTypeReference);
    }

    @Override
    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope scope) {
        return this.createParameterizedType(parameterizedSingleTypeReference);
    }

    private boolean createParameterizedType(TypeReference parameterizedTypeReference) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        CtTypeReference typeReference = this.references.buildTypeReference(parameterizedTypeReference, null);
        CtTypeAccess typeAccess = this.factory.Code().createTypeAccessWithoutCloningReference(typeReference);
        this.context.enter(typeAccess, parameterizedTypeReference);
        return true;
    }

    @Override
    public boolean visit(PostfixExpression postfixExpression, BlockScope scope) {
        CtUnaryOperator op = this.factory.Core().createUnaryOperator();
        if (postfixExpression.operator == 14) {
            op.setKind(UnaryOperatorKind.POSTINC);
        }
        if (postfixExpression.operator == 13) {
            op.setKind(UnaryOperatorKind.POSTDEC);
        }
        this.context.enter(op, postfixExpression);
        return true;
    }

    @Override
    public boolean visit(PrefixExpression prefixExpression, BlockScope scope) {
        CtUnaryOperator op = this.factory.Core().createUnaryOperator();
        if (prefixExpression.operator == 14) {
            op.setKind(UnaryOperatorKind.PREINC);
        }
        if (prefixExpression.operator == 13) {
            op.setKind(UnaryOperatorKind.PREDEC);
        }
        this.context.enter(op, prefixExpression);
        return true;
    }

    @Override
    public boolean visit(QualifiedNameReference qualifiedNameRef, BlockScope scope) {
        if (qualifiedNameRef.binding instanceof FieldBinding || qualifiedNameRef.binding instanceof VariableBinding) {
            this.context.enter(this.helper.createVariableAccess(qualifiedNameRef), qualifiedNameRef);
            return true;
        }
        if (qualifiedNameRef.binding instanceof TypeBinding) {
            TypeBinding typeBinding = (TypeBinding)qualifiedNameRef.binding;
            CtTypeReference typeRef = this.references.getTypeReference(typeBinding);
            JDTTreeBuilderHelper.handleImplicit(typeBinding.getPackage(), qualifiedNameRef, null, typeRef);
            this.context.enter(this.factory.Code().createTypeAccessWithoutCloningReference(typeRef), qualifiedNameRef);
            return true;
        }
        if (qualifiedNameRef.binding instanceof ProblemBinding) {
            if (this.context.stack.peek().element instanceof CtInvocation) {
                this.context.enter(this.helper.createTypeAccessNoClasspath(qualifiedNameRef), qualifiedNameRef);
                return true;
            }
            this.context.enter(this.helper.createFieldAccessNoClasspath(qualifiedNameRef), qualifiedNameRef);
            return true;
        }
        this.context.enter(this.helper.createVariableAccess((CtVariableReference)this.factory.Core().createUnboundVariableReference().setSimpleName(qualifiedNameRef.toString()), JDTTreeBuilderQuery.isLhsAssignment(this.context, qualifiedNameRef)), qualifiedNameRef);
        return true;
    }

    @Override
    public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        if (this.context.stack.peekFirst().node instanceof UnionTypeReference) {
            CtTypeReference reference = this.references.getTypeReference(qualifiedTypeReference.resolvedType);
            if (reference == null) {
                reference = this.getFactory().createReference(qualifiedTypeReference.toString());
            }
            this.context.enter(reference, qualifiedTypeReference);
            return true;
        }
        if (this.context.stack.peekFirst().element instanceof CtCatch) {
            this.context.enter(this.helper.createCatchVariable(qualifiedTypeReference), qualifiedTypeReference);
            return true;
        }
        this.context.enter(this.factory.Code().createTypeAccessWithoutCloningReference(this.references.buildTypeReference(qualifiedTypeReference, (Scope)scope)), qualifiedTypeReference);
        return true;
    }

    @Override
    public boolean visit(QualifiedTypeReference qualifiedTypeReference, ClassScope scope) {
        return this.visit(qualifiedTypeReference, (BlockScope)null);
    }

    @Override
    public boolean visit(ReturnStatement returnStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createReturn(), returnStatement);
        return true;
    }

    @Override
    public boolean visit(SingleNameReference singleNameReference, BlockScope scope) {
        if (singleNameReference.binding instanceof FieldBinding) {
            this.context.enter(this.helper.createFieldAccess(singleNameReference), singleNameReference);
        } else if (singleNameReference.binding instanceof VariableBinding) {
            this.context.enter(this.helper.createVariableAccess(singleNameReference), singleNameReference);
        } else if (singleNameReference.binding instanceof TypeBinding) {
            this.context.enter(this.factory.Code().createTypeAccessWithoutCloningReference(this.references.getTypeReference((TypeBinding)singleNameReference.binding).setSimplyQualified(true)), singleNameReference);
        } else if (singleNameReference.binding instanceof ProblemBinding) {
            if (this.context.stack.peek().element instanceof CtInvocation && Character.isUpperCase(CharOperation.charToString(singleNameReference.token).charAt(0))) {
                this.context.enter(this.helper.createTypeAccessNoClasspath(singleNameReference), singleNameReference);
            } else {
                this.context.enter(this.helper.createFieldAccessNoClasspath(singleNameReference), singleNameReference);
            }
        } else if (singleNameReference.binding == null) {
            CtExpression access = this.helper.createVariableAccessNoClasspath(singleNameReference);
            if (access == null) {
                access = this.helper.createTypeAccessNoClasspath(singleNameReference);
            }
            this.context.enter(access, singleNameReference);
        }
        return true;
    }

    @Override
    public boolean visit(QualifiedSuperReference qualifiedSuperReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        this.context.enter(this.factory.Core().createSuperAccess(), qualifiedSuperReference);
        return true;
    }

    @Override
    public boolean visit(SuperReference superReference, BlockScope scope) {
        this.context.enter(this.factory.Core().createSuperAccess(), superReference);
        return true;
    }

    @Override
    public boolean visit(QualifiedThisReference qualifiedThisRef, BlockScope scope) {
        this.context.enter(this.factory.Code().createThisAccess(this.references.getTypeReference(qualifiedThisRef.qualification.resolvedType), qualifiedThisRef.isImplicitThis()), qualifiedThisRef);
        return true;
    }

    @Override
    public boolean visit(ThisReference thisReference, BlockScope scope) {
        this.context.enter(this.factory.Code().createThisAccess(this.references.getTypeReference(thisReference.resolvedType), thisReference.isImplicitThis()), thisReference);
        return true;
    }

    @Override
    public void endVisit(UnionTypeReference unionTypeReference, BlockScope scope) {
        this.context.exit(unionTypeReference);
    }

    @Override
    public void endVisit(UnionTypeReference unionTypeReference, ClassScope scope) {
        this.endVisit(unionTypeReference, (BlockScope)null);
    }

    @Override
    public boolean visit(UnionTypeReference unionTypeReference, BlockScope scope) {
        if (!(this.context.stack.peekFirst().node instanceof Argument)) {
            throw new SpoonException("UnionType is only supported for CtCatch.");
        }
        this.context.enter(this.helper.createCatchVariable(unionTypeReference), unionTypeReference);
        return true;
    }

    @Override
    public boolean visit(UnionTypeReference unionTypeReference, ClassScope scope) {
        return this.visit(unionTypeReference, (BlockScope)null);
    }

    @Override
    public boolean visit(SingleTypeReference singleTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        if (this.context.stack.peekFirst().node instanceof UnionTypeReference) {
            if (singleTypeReference.resolvedType == null) {
                CtTypeReference typeReference = this.factory.Type().createReference(singleTypeReference.toString());
                CtReference ref = this.references.getDeclaringReferenceFromImports(singleTypeReference.getLastToken());
                this.references.setPackageOrDeclaringType(typeReference, ref);
                this.context.enter(typeReference, singleTypeReference);
            } else {
                this.context.enter(this.references.getTypeReference(singleTypeReference.resolvedType), singleTypeReference);
            }
            return true;
        }
        if (this.context.stack.peekFirst().element instanceof CtCatch) {
            this.context.enter(this.helper.createCatchVariable(singleTypeReference), singleTypeReference);
            return true;
        }
        CtTypeReference typeRef = this.references.buildTypeReference(singleTypeReference, (Scope)scope);
        if (typeRef != null) {
            typeRef.setSimplyQualified(true);
        }
        this.context.enter(this.factory.Code().createTypeAccessWithoutCloningReference(typeRef), singleTypeReference);
        return true;
    }

    @Override
    public boolean visit(SingleTypeReference singleTypeReference, ClassScope scope) {
        return this.visit(singleTypeReference, (BlockScope)null);
    }

    @Override
    public boolean visit(StringLiteral stringLiteral, BlockScope scope) {
        this.context.enter(this.factory.Code().createLiteral(CharOperation.charToString(stringLiteral.source())), stringLiteral);
        return true;
    }

    @Override
    public boolean visit(StringLiteralConcatenation literal, BlockScope scope) {
        this.context.enter((CtElement)this.factory.Core().createBinaryOperator().setKind(BinaryOperatorKind.PLUS), literal);
        return true;
    }

    @Override
    public boolean visit(CaseStatement caseStatement, BlockScope scope) {
        if (this.context.stack.peek().node instanceof CaseStatement) {
            this.context.exit(this.context.stack.peek().node);
        }
        this.context.enter(this.factory.Core().createCase(), caseStatement);
        return true;
    }

    @Override
    public boolean visit(SwitchStatement switchStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createSwitch(), switchStatement);
        return true;
    }

    @Override
    public boolean visit(SwitchExpression switchExpression, BlockScope blockScope) {
        this.context.enter(this.factory.Core().createSwitchExpression(), switchExpression);
        return true;
    }

    @Override
    public boolean visit(SynchronizedStatement synchronizedStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createSynchronized(), synchronizedStatement);
        return true;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createThrow(), throwStatement);
        return true;
    }

    @Override
    public boolean visit(TrueLiteral trueLiteral, BlockScope scope) {
        this.context.enter(this.factory.Code().createLiteral(true), trueLiteral);
        return true;
    }

    @Override
    public boolean visit(TryStatement tryStatement, BlockScope scope) {
        CtTry t = tryStatement.resources.length > 0 ? this.factory.Core().createTryWithResource() : this.factory.Core().createTry();
        this.context.enter(t, tryStatement);
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        if (localTypeDeclaration.binding == null) {
            CtClass t = this.factory.Core().createClass();
            t.setSimpleName(Integer.toString(localTypeDeclaration.sourceStart()));
            t.setSuperclass(this.references.getTypeReference(null, localTypeDeclaration.allocation.type));
            this.context.enter(t, localTypeDeclaration);
        } else {
            this.helper.createType(localTypeDeclaration);
        }
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.helper.createType(memberTypeDeclaration);
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        if ("package-info".equals(new String(typeDeclaration.name))) {
            this.context.enter(this.factory.Package().getOrCreate(new String(typeDeclaration.binding.fPackage.readableName())), typeDeclaration);
            return true;
        }
        if (typeDeclaration.binding == null && this.getFactory().getEnvironment().isIgnoreDuplicateDeclarations()) {
            return false;
        }
        CtModule module = typeDeclaration.binding.module != null && !typeDeclaration.binding.module.isUnnamed() && typeDeclaration.binding.module.shortReadableName() != null && typeDeclaration.binding.module.shortReadableName().length > 0 ? this.factory.Module().getOrCreate(String.valueOf(typeDeclaration.binding.module.shortReadableName())) : this.factory.Module().getUnnamedModule();
        CtPackage pack = typeDeclaration.binding.fPackage.shortReadableName() != null && typeDeclaration.binding.fPackage.shortReadableName().length > 0 ? this.factory.Package().getOrCreate(new String(typeDeclaration.binding.fPackage.shortReadableName()), module) : module.getRootPackage();
        this.context.enter(pack, typeDeclaration);
        pack.addType(this.helper.createType(typeDeclaration));
        return true;
    }

    @Override
    public boolean visit(UnaryExpression unaryExpression, BlockScope scope) {
        CtUnaryOperator op = this.factory.Core().createUnaryOperator();
        op.setKind(JDTTreeBuilderQuery.getUnaryOperator((unaryExpression.bits & 0xFC0) >> 6));
        this.context.enter(op, unaryExpression);
        return true;
    }

    @Override
    public boolean visit(WhileStatement whileStatement, BlockScope scope) {
        this.context.enter(this.factory.Core().createWhile(), whileStatement);
        return true;
    }

    @Override
    public boolean visit(ModuleDeclaration moduleDeclaration, CompilationUnitScope scope) {
        CtModule module = this.getHelper().createModule(moduleDeclaration);
        this.context.compilationUnitSpoon.setDeclaredModule(module);
        return true;
    }

    @Override
    public void endVisit(YieldStatement yieldStatement, BlockScope scope) {
        this.context.exit(yieldStatement);
    }

    @Override
    public boolean visit(YieldStatement yieldStatement, BlockScope scope) {
        this.context.enter((CtElement)this.factory.Core().createYieldStatement().setImplicit(yieldStatement.isImplicit), yieldStatement);
        return true;
    }

    class SpoonReferenceBinding
    extends ReferenceBinding {
        private ReferenceBinding enclosingType;

        SpoonReferenceBinding(char[] sourceName, ReferenceBinding enclosingType) {
            this.sourceName = sourceName;
            this.enclosingType = enclosingType;
        }

        @Override
        public ReferenceBinding enclosingType() {
            return this.enclosingType;
        }
    }

    static abstract class OnAccessListener {
        OnAccessListener() {
        }

        abstract boolean onAccess(char[][] var1, int var2);
    }
}

