/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import spoon.SpoonException;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CaseKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotatedElementType;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.reflect.visitor.CtScanner;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;

public class ParentExiter
extends CtInheritanceScanner {
    private final JDTTreeBuilder jdtTreeBuilder;
    private CtElement child;
    private ASTNode childJDT;
    private ASTNode parentJDT;
    private Map<CtTypedElement<?>, List<CtAnnotation>> annotationsMap = new HashMap();
    private static final String KEYWORD_NEW = "new";

    ParentExiter(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    public void setChild(CtElement child) {
        this.child = child;
    }

    public void setChild(ASTNode child) {
        this.childJDT = child;
    }

    public void setParent(ASTNode parent) {
        this.parentJDT = parent;
    }

    @Override
    public void scanCtElement(CtElement e) {
        if (this.child instanceof CtAnnotation && this.jdtTreeBuilder.getContextBuilder().annotationValueName.isEmpty()) {
            CtAnnotatedElementType annotatedElementType = CtAnnotation.getAnnotatedElementTypeForCtElement(e);
            CtAnnotatedElementType ctAnnotatedElementType = annotatedElementType = e instanceof CtTypeParameter || e instanceof CtTypeParameterReference ? CtAnnotatedElementType.TYPE_USE : annotatedElementType;
            if (this.jdtTreeBuilder.getFactory().getEnvironment().getNoClasspath() || annotatedElementType != null && JDTTreeBuilderQuery.hasAnnotationWithType((Annotation)this.childJDT, annotatedElementType)) {
                e.addAnnotation((CtAnnotation)this.child);
            }
            if (e instanceof CtTypedElement && JDTTreeBuilderQuery.hasAnnotationWithType((Annotation)this.childJDT, CtAnnotatedElementType.TYPE_USE)) {
                List<Object> annotations = new ArrayList();
                if (!this.annotationsMap.containsKey(e)) {
                    this.annotationsMap.put((CtTypedElement)e, annotations);
                } else {
                    annotations = this.annotationsMap.get(e);
                }
                annotations.add((CtAnnotation)this.child.clone());
                this.annotationsMap.put((CtTypedElement)e, annotations);
            }
        }
    }

    private void substituteAnnotation(CtTypedElement ele) {
        if (this.annotationsMap.containsKey(ele)) {
            List<CtAnnotation> annotations = this.annotationsMap.get(ele);
            for (CtAnnotation annotation : annotations) {
                if (this.jdtTreeBuilder.getFactory().getEnvironment().getNoClasspath() && annotation.isParentInitialized()) {
                    CtElement parent = annotation.getParent();
                    parent.removeAnnotation(annotation);
                }
                if (ele.getType().getAnnotations().contains(annotation)) continue;
                ele.getType().addAnnotation((CtAnnotation<? extends java.lang.annotation.Annotation>)annotation.clone());
            }
            this.annotationsMap.remove(ele);
        }
    }

    @Override
    public <R> void scanCtExecutable(CtExecutable<R> e) {
        if (this.child instanceof CtTypeAccess) {
            e.addThrownType(((CtTypeAccess)this.child).getAccessedType());
            return;
        }
        if (this.child instanceof CtParameter) {
            e.addParameter((CtParameter)this.child);
            return;
        }
        if (this.child instanceof CtBlock && !(e instanceof CtMethod) && !(e instanceof CtConstructor)) {
            e.setBody((CtBlock)this.child);
            return;
        }
        super.scanCtExecutable(e);
    }

    @Override
    public void scanCtFormalTypeDeclarer(CtFormalTypeDeclarer e) {
        if (this.childJDT instanceof TypeParameter && this.child instanceof CtTypeParameter) {
            e.addFormalCtTypeParameter((CtTypeParameter)this.child);
        }
    }

    @Override
    public void scanCtLoop(CtLoop loop) {
        if (loop.getBody() == null && this.child instanceof CtStatement) {
            CtBlock<?> child = (CtBlock<?>)this.child;
            if (!(this.child instanceof CtBlock)) {
                child = this.jdtTreeBuilder.getFactory().Code().createCtBlock(child);
                child.setImplicit(true);
                child.setPosition(this.child.getPosition());
            }
            loop.setBody(child);
        }
        super.scanCtLoop(loop);
    }

    @Override
    public <T, E extends CtExpression<?>> void scanCtTargetedExpression(CtTargetedExpression<T, E> targetedExpression) {
        if (this.child instanceof CtExpression) {
            targetedExpression.setTarget((CtExpression)this.child);
            return;
        }
        super.scanCtTargetedExpression(targetedExpression);
    }

    @Override
    public <T> void scanCtType(CtType<T> type) {
        if (this.child instanceof CtType && !(this.child instanceof CtTypeParameter)) {
            if (type.getTypeMembers().contains(this.child)) {
                type.removeTypeMember((CtType)this.child);
            }
            type.addNestedType((CtType)this.child);
            return;
        }
        if (this.child instanceof CtEnumValue && type instanceof CtEnum) {
            ((CtEnum)type).addEnumValue((CtEnumValue)this.child);
        } else {
            if (this.child instanceof CtField) {
                type.addField((CtField)this.child);
                return;
            }
            if (this.child instanceof CtConstructor) {
                return;
            }
        }
        if (this.child instanceof CtMethod) {
            type.addMethod((CtMethod)this.child);
            return;
        }
        super.scanCtType(type);
    }

    @Override
    public <T> void scanCtVariable(CtVariable<T> v) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            v.setType(((CtTypeAccess)this.child).getAccessedType());
            this.substituteAnnotation(v);
            return;
        }
        if (this.child instanceof CtExpression && this.hasChildEqualsToDefaultValue(v)) {
            v.setDefaultExpression((CtExpression)this.child);
            return;
        }
        super.scanCtVariable(v);
    }

    private <T> boolean hasChildEqualsToDefaultValue(CtVariable<T> ctVariable) {
        if (this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof AnnotationMethodDeclaration) {
            AnnotationMethodDeclaration parent = (AnnotationMethodDeclaration)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
            return parent.defaultValue != null && this.getFinalExpressionFromCast(parent.defaultValue).equals(this.childJDT) && !this.child.equals(ctVariable.getDefaultExpression());
        }
        AbstractVariableDeclaration parent = (AbstractVariableDeclaration)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.initialization != null && this.getFinalExpressionFromCast(parent.initialization).equals(this.childJDT) && !this.child.equals(ctVariable.getDefaultExpression());
    }

    @Override
    public <A extends java.lang.annotation.Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        if (this.child instanceof CtExpression) {
            annotation.addValue(this.jdtTreeBuilder.getContextBuilder().annotationValueName.peek(), this.child);
        }
        super.visitCtAnnotation(annotation);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> e) {
        if (e.getBody() == null && this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            this.visitCtBlock((CtBlock)e.getBody());
            return;
        }
        super.visitCtConstructor(e);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> e) {
        if (e.getBody() == null && this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            this.visitCtBlock((CtBlock)e.getBody());
            return;
        }
        if (this.child instanceof CtTypeAccess && this.hasChildEqualsToType(e)) {
            e.setType(((CtTypeAccess)this.child).getAccessedType());
            this.substituteAnnotation(e);
            return;
        }
        super.visitCtMethod(e);
    }

    private <T> boolean hasChildEqualsToType(CtMethod<T> ctMethod) {
        MethodDeclaration parent = (MethodDeclaration)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.returnType != null && parent.returnType.equals(this.childJDT) && !this.child.equals(ctMethod.getType());
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        if (this.child instanceof CtExpression && this.hasChildEqualsToDefaultValue(annotationMethod)) {
            annotationMethod.setDefaultExpression((CtExpression)this.child);
            return;
        }
        super.visitCtAnnotationMethod(annotationMethod);
    }

    private <T> boolean hasChildEqualsToDefaultValue(CtAnnotationMethod<T> ctAnnotationMethod) {
        AnnotationMethodDeclaration parent = (AnnotationMethodDeclaration)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.defaultValue != null && parent.defaultValue.equals(this.childJDT) && !this.child.equals(ctAnnotationMethod.getDefaultExpression());
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable e) {
        if (this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        super.visitCtAnonymousExecutable(e);
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        if (this.visitArrayAccess(arrayRead)) {
            super.visitCtArrayRead(arrayRead);
        }
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        if (this.visitArrayAccess(arrayWrite)) {
            super.visitCtArrayWrite(arrayWrite);
        }
    }

    private <T, E extends CtExpression<?>> boolean visitArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        if (this.child instanceof CtExpression) {
            if (arrayAccess.getTarget() == null) {
                arrayAccess.setTarget((CtExpression)this.child);
                return false;
            }
            arrayAccess.setIndexExpression((CtExpression)this.child);
            return false;
        }
        return true;
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        if (this.child instanceof CtExpression) {
            if (asserted.getAssertExpression() == null) {
                asserted.setAssertExpression((CtExpression)this.child);
                return;
            }
            asserted.setExpression((CtExpression)this.child);
            return;
        }
        super.visitCtAssert(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        if (this.child instanceof CtExpression) {
            if (assignement.getAssigned() == null) {
                assignement.setAssigned((CtExpression)this.child);
                return;
            }
            if (assignement.getAssignment() == null) {
                assignement.setAssignment((CtExpression)this.child);
                return;
            }
        }
        super.visitCtAssignment(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (this.child instanceof CtExpression) {
            if (operator.getLeftHandOperand() == null) {
                operator.setLeftHandOperand((CtExpression)this.child);
                return;
            }
            if (operator.getRightHandOperand() == null) {
                if (this.child.getPosition().isValidPosition()) {
                    int childEnd = this.child.getPosition().getSourceEnd();
                    SourcePosition oldPos = operator.getPosition();
                    if (oldPos.isValidPosition() && oldPos.getSourceEnd() < childEnd) {
                        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
                        operator.setPosition(operator.getFactory().Core().createSourcePosition(oldPos.getCompilationUnit(), oldPos.getSourceStart(), childEnd, lineSeparatorPositions));
                    }
                }
                operator.setRightHandOperand((CtExpression)this.child);
                return;
            }
            if (this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof StringLiteralConcatenation) {
                CtBinaryOperator op = operator.getFactory().Core().createBinaryOperator();
                op.setKind(BinaryOperatorKind.PLUS);
                op.setLeftHandOperand(operator.getRightHandOperand());
                op.setRightHandOperand((CtExpression)this.child);
                op.setType(operator.getFactory().Type().STRING.clone());
                operator.setRightHandOperand(op);
                int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
                SourcePosition leftPosition = op.getLeftHandOperand().getPosition();
                SourcePosition rightPosition = op.getRightHandOperand().getPosition();
                op.setPosition(op.getFactory().createSourcePosition(leftPosition.getCompilationUnit(), leftPosition.getSourceStart(), rightPosition.getSourceEnd(), lineSeparatorPositions));
                return;
            }
        }
        super.visitCtBinaryOperator(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        if (this.child instanceof CtStatement) {
            block.addStatement((CtStatement)this.child);
            return;
        }
        super.visitCtBlock(block);
    }

    @Override
    public void visitCtBreak(CtBreak b) {
        super.visitCtBreak(b);
    }

    @Override
    public <E> void visitCtCase(CtCase<E> caseStatement) {
        ASTNode node = this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        if (node instanceof CaseStatement) {
            caseStatement.setCaseKind(((CaseStatement)node).isExpr ? CaseKind.ARROW : CaseKind.COLON);
        }
        if (node instanceof CaseStatement && ((CaseStatement)node).constantExpression != null && this.child instanceof CtExpression && caseStatement.getCaseExpressions().size() < ((CaseStatement)node).constantExpressions.length) {
            caseStatement.addCaseExpression((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            caseStatement.addStatement((CtStatement)this.child);
            return;
        }
        super.visitCtCase(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        if (this.child instanceof CtBlock) {
            catchBlock.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtCatchVariable) {
            catchBlock.setParameter((CtCatchVariable)this.child);
            catchBlock.getAnnotations().forEach(a -> {
                a.setParent(this.child);
                this.child.addAnnotation((CtAnnotation<? extends java.lang.annotation.Annotation>)a);
            });
            catchBlock.setAnnotations(Collections.unmodifiableList(Collections.emptyList()));
            return;
        }
        super.visitCtCatch(catchBlock);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> e) {
        if (this.jdtTreeBuilder.getContextBuilder().stack.peekFirst().node instanceof UnionTypeReference) {
            e.addMultiType((CtTypeReference)this.child);
            return;
        }
        super.visitCtCatchVariable(e);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (this.child instanceof CtConstructor) {
            ctClass.addConstructor((CtConstructor)this.child);
        }
        if (this.child instanceof CtAnonymousExecutable) {
            ctClass.addAnonymousExecutable((CtAnonymousExecutable)this.child);
        }
        super.visitCtClass(ctClass);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            if (typeParameter.getSuperclass() == null) {
                typeParameter.setSuperclass(((CtTypeAccess)this.child).getAccessedType());
            } else if (typeParameter.getSuperclass() instanceof CtIntersectionTypeReference) {
                typeParameter.getSuperclass().asCtIntersectionTypeReference().addBound(((CtTypeAccess)this.child).getAccessedType());
            } else {
                ArrayList refs = new ArrayList();
                refs.add(typeParameter.getSuperclass());
                refs.add(((CtTypeAccess)this.child).getAccessedType());
                typeParameter.setSuperclass(this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(refs));
            }
            return;
        }
        super.visitCtTypeParameter(typeParameter);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        if (this.child instanceof CtExpression) {
            if (conditional.getCondition() == null) {
                conditional.setCondition((CtExpression)this.child);
            } else if (conditional.getThenExpression() == null) {
                conditional.setThenExpression((CtExpression)this.child);
            } else if (conditional.getElseExpression() == null) {
                conditional.setElseExpression((CtExpression)this.child);
            }
        }
        super.visitCtConditional(conditional);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        if (doLoop.getBody() != null && this.child instanceof CtExpression && doLoop.getLoopingExpression() == null) {
            doLoop.setLoopingExpression((CtExpression)this.child);
            return;
        }
        super.visitCtDo(doLoop);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        if (this.isContainedInForInit() && this.child instanceof CtStatement) {
            forLoop.addForInit((CtStatement)this.child);
            return;
        }
        if (this.isContainedInForUpdate() && this.child instanceof CtStatement) {
            forLoop.addForUpdate((CtStatement)this.child);
            return;
        }
        if (this.isContainedInForCondition() && this.child instanceof CtExpression) {
            forLoop.setExpression((CtExpression)this.child);
            return;
        }
        super.visitCtFor(forLoop);
    }

    private boolean isContainedInForInit() {
        if (!(this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof ForStatement)) {
            return false;
        }
        ForStatement parent = (ForStatement)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        if (parent.initializations == null) {
            return false;
        }
        for (Statement initialization : parent.initializations) {
            if (initialization == null || !initialization.equals(this.childJDT)) continue;
            return true;
        }
        return false;
    }

    private boolean isContainedInForUpdate() {
        if (!(this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof ForStatement)) {
            return false;
        }
        ForStatement parent = (ForStatement)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        if (parent.increments == null) {
            return false;
        }
        for (Statement increment : parent.increments) {
            if (increment == null || !increment.equals(this.childJDT)) continue;
            return true;
        }
        return false;
    }

    private boolean isContainedInForCondition() {
        if (!(this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof ForStatement)) {
            return false;
        }
        ForStatement parent = (ForStatement)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.condition != null && parent.condition.equals(this.childJDT);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        if (foreach.getVariable() == null && this.child instanceof CtVariable) {
            foreach.setVariable((CtLocalVariable)this.child);
            return;
        }
        if (foreach.getExpression() == null && this.child instanceof CtExpression) {
            foreach.setExpression((CtExpression)this.child);
            return;
        }
        super.visitCtForEach(foreach);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        if (whileLoop.getLoopingExpression() == null && this.child instanceof CtExpression) {
            whileLoop.setLoopingExpression((CtExpression)this.child);
            return;
        }
        super.visitCtWhile(whileLoop);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        if (ifElement.getCondition() == null && this.child instanceof CtExpression) {
            ifElement.setCondition((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            CtBlock<?> child = (CtBlock<?>)this.child;
            if (!(this.child instanceof CtBlock)) {
                child = this.jdtTreeBuilder.getFactory().Code().createCtBlock(child);
                child.setImplicit(true);
                child.setPosition(this.child.getPosition());
            }
            IfStatement ifJDT = (IfStatement)this.parentJDT;
            if (ifJDT.thenStatement == this.childJDT) {
                ifElement.setThenStatement(child);
                return;
            }
            if (ifJDT.elseStatement == this.childJDT) {
                ifElement.setElseStatement(child);
                return;
            }
            throw new SpoonException("Unexpected call of ParentExiter on CtIf");
        }
        super.visitCtIf(ifElement);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> superAccess) {
        if (this.child instanceof CtTypeAccess) {
            superAccess.setTarget((CtTypeAccess)this.child);
            return;
        }
        super.visitCtSuperAccess(superAccess);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            invocation.getExecutable().addActualTypeArgument(((CtTypeAccess)this.child).getAccessedType());
            return;
        }
        if (this.child instanceof CtExpression) {
            if (this.hasChildEqualsToReceiver(invocation) || this.hasChildEqualsToQualification(invocation)) {
                if (this.child instanceof CtThisAccess) {
                    CtTypeReference<?> declaringType = invocation.getExecutable().getDeclaringType();
                    if (declaringType != null && invocation.getExecutable().isStatic() && this.child.isImplicit()) {
                        invocation.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringType, true));
                    } else {
                        invocation.setTarget((CtThisAccess)this.child);
                    }
                } else {
                    invocation.setTarget((CtExpression)this.child);
                }
            } else {
                invocation.addArgument((CtExpression)this.child);
            }
            return;
        }
        super.visitCtInvocation(invocation);
    }

    private <T> boolean hasChildEqualsToQualification(CtInvocation<T> ctInvocation) {
        if (!(this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof ExplicitConstructorCall)) {
            return false;
        }
        ExplicitConstructorCall parent = (ExplicitConstructorCall)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.qualification != null && this.getFinalExpressionFromCast(parent.qualification).equals(this.childJDT) && !this.child.equals(ctInvocation.getTarget());
    }

    private <T> boolean hasChildEqualsToReceiver(CtInvocation<T> ctInvocation) {
        if (!(this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof MessageSend)) {
            return false;
        }
        MessageSend parent = (MessageSend)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.receiver != null && this.getFinalExpressionFromCast(parent.receiver).equals(this.childJDT) && !this.child.equals(ctInvocation.getTarget());
    }

    private Expression getFinalExpressionFromCast(Expression potentialCase) {
        if (!(potentialCase instanceof CastExpression)) {
            return potentialCase;
        }
        return this.getFinalExpressionFromCast(((CastExpression)potentialCase).expression);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            ArrayAllocationExpression arrayAlloc = (ArrayAllocationExpression)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
            newArray.setType(this.jdtTreeBuilder.getFactory().Type().createArrayReference(((CtTypeAccess)this.child).getAccessedType(), arrayAlloc.dimensions.length));
        } else if (this.child instanceof CtExpression) {
            if (this.isContainedInDimensionExpression()) {
                newArray.addDimensionExpression((CtExpression)this.child);
            } else if (this.child instanceof CtNewArray && this.childJDT instanceof ArrayInitializer && this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof ArrayAllocationExpression) {
                newArray.setElements(((CtNewArray)this.child).getElements());
            } else {
                newArray.addElement((CtExpression)this.child);
            }
        }
    }

    private boolean isContainedInDimensionExpression() {
        if (!(this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof ArrayAllocationExpression)) {
            return false;
        }
        ArrayAllocationExpression parent = (ArrayAllocationExpression)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        if (parent.dimensions == null) {
            return false;
        }
        for (Expression dimension : parent.dimensions) {
            if (dimension == null || !this.getFinalExpressionFromCast(dimension).equals(this.childJDT)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        if (this.child instanceof CtTypeAccess) {
            if (this.hasChildEqualsToType(ctConstructorCall)) {
                ctConstructorCall.getExecutable().setType(((CtTypeAccess)this.child).getAccessedType());
            } else {
                ctConstructorCall.addActualTypeArgument(((CtTypeAccess)this.child).getAccessedType());
            }
            return;
        }
        if (this.child instanceof CtExpression) {
            if (this.hasChildEqualsToEnclosingInstance(ctConstructorCall)) {
                ctConstructorCall.setTarget((CtExpression)this.child);
            } else {
                ctConstructorCall.addArgument((CtExpression)this.child);
            }
            return;
        }
        super.visitCtConstructorCall(ctConstructorCall);
    }

    private <T> boolean hasChildEqualsToEnclosingInstance(CtConstructorCall<T> ctConstructorCall) {
        if (!(this.jdtTreeBuilder.getContextBuilder().stack.peek().node instanceof QualifiedAllocationExpression)) {
            return false;
        }
        QualifiedAllocationExpression parent = (QualifiedAllocationExpression)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.enclosingInstance != null && this.getFinalExpressionFromCast(parent.enclosingInstance).equals(this.childJDT) && !this.child.equals(ctConstructorCall.getTarget());
    }

    private <T> boolean hasChildEqualsToType(CtConstructorCall<T> ctConstructorCall) {
        AllocationExpression parent = (AllocationExpression)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
        return parent.type != null && parent.type.equals(this.childJDT);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        if (this.child instanceof CtClass) {
            ReferenceBinding[] referenceBindings;
            newClass.setAnonymousClass((CtClass)this.child);
            QualifiedAllocationExpression node = (QualifiedAllocationExpression)this.jdtTreeBuilder.getContextBuilder().stack.peek().node;
            ReferenceBinding[] referenceBindingArray = referenceBindings = node.resolvedType == null ? null : node.resolvedType.superInterfaces();
            if (referenceBindings != null && referenceBindings.length > 0) {
                ((CtClass)this.child).setSuperInterfaces(Collections.singleton(this.cloneAsImplicit(newClass.getType())));
            } else if (newClass.getType() != null) {
                ((CtClass)this.child).setSuperclass(this.cloneAsImplicit(newClass.getType()));
            }
            return;
        }
        super.visitCtNewClass(newClass);
    }

    private <T extends CtElement> T cloneAsImplicit(T ele) {
        ele = ele.clone();
        ele.accept(new CtScanner(){

            @Override
            protected void enter(CtElement e) {
                e.setPosition(SourcePosition.NOPOSITION);
            }
        });
        ele.setImplicit(true);
        return (T)ele;
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        if (this.child instanceof CtParameter) {
            lambda.addParameter((CtParameter)this.child);
            return;
        }
        if (this.child instanceof CtBlock) {
            lambda.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtExpression) {
            lambda.setExpression((CtExpression)this.child);
        }
        super.visitCtLambda(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        if (this.child instanceof CtExpression) {
            expression.setTarget((CtExpression)this.child);
        }
        super.visitCtExecutableReferenceExpression(expression);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        if (this.child instanceof CtType) {
            CtType type = (CtType)this.child;
            if (ctPackage.getTypes().contains(type)) {
                ctPackage.removeType(type);
            }
            ctPackage.addType(type);
            CompilationUnit cu = type.getPosition().getCompilationUnit();
            if (cu != null) {
                cu.addDeclaredType(type);
            }
            return;
        }
        super.visitCtPackage(ctPackage);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        if (this.child instanceof CtExpression) {
            returnStatement.setReturnedExpression((CtExpression)this.child);
            return;
        }
        super.visitCtReturn(returnStatement);
    }

    @Override
    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        if (switchStatement.getSelector() == null && this.child instanceof CtExpression) {
            switchStatement.setSelector((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtCase) {
            switchStatement.addCase((CtCase)this.child);
            this.child.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition((CtCase)this.child));
            return;
        }
        super.visitCtSwitch(switchStatement);
    }

    @Override
    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
        if (switchExpression.getSelector() == null && this.child instanceof CtExpression) {
            switchExpression.setSelector((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtCase) {
            switchExpression.addCase((CtCase)this.child);
            this.child.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition((CtCase)this.child));
            return;
        }
        super.visitCtSwitchExpression(switchExpression);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        if (synchro.getExpression() == null && this.child instanceof CtExpression) {
            synchro.setExpression((CtExpression)this.child);
            return;
        }
        if (synchro.getBlock() == null && this.child instanceof CtBlock) {
            synchro.setBlock((CtBlock)this.child);
            return;
        }
        super.visitCtSynchronized(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        if (throwStatement.getThrownExpression() == null && this.child instanceof CtExpression) {
            throwStatement.setThrownExpression((CtExpression)this.child);
            return;
        }
        super.visitCtThrow(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        if (this.child instanceof CtBlock) {
            CtBlock childBlock = (CtBlock)this.child;
            CtCatch lastCatcher = this.getLastCatcher(tryBlock);
            if (lastCatcher != null && lastCatcher.getBody() == null) {
                lastCatcher.setBody(childBlock);
                lastCatcher.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(lastCatcher));
            } else if (tryBlock.getBody() != null && tryBlock.getFinalizer() == null) {
                tryBlock.setFinalizer(childBlock);
            } else {
                tryBlock.setBody(childBlock);
            }
            return;
        }
        if (this.child instanceof CtCatch) {
            tryBlock.addCatcher((CtCatch)this.child);
            return;
        }
        super.visitCtTry(tryBlock);
    }

    private CtCatch getLastCatcher(CtTry tryBlock) {
        List<CtCatch> catchers = tryBlock.getCatchers();
        int nrCatchers = catchers.size();
        if (nrCatchers > 0) {
            return catchers.get(nrCatchers - 1);
        }
        return null;
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        if (this.child instanceof CtLocalVariable) {
            tryWithResource.addResource((CtLocalVariable)this.child);
        }
        super.visitCtTryWithResource(tryWithResource);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        if (operator.getOperand() == null && this.child instanceof CtExpression) {
            operator.setOperand((CtExpression)this.child);
            return;
        }
        super.visitCtUnaryOperator(operator);
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference e) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            e.setBoundingType(((CtTypeAccess)this.child).getAccessedType());
        }
        super.visitCtWildcardReference(e);
    }

    @Override
    public void visitCtYieldStatement(CtYieldStatement e) {
        if (this.child instanceof CtExpression) {
            e.setExpression((CtExpression)this.child);
            if (e.isImplicit()) {
                e.setPosition(this.child.getPosition());
            }
            return;
        }
        super.visitCtYieldStatement(e);
    }
}

