/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Messages;
import spoon.support.compiler.jdt.JDTConstants;

class TreeBuilderCompiler
extends Compiler {
    TreeBuilderCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, ICompilerRequestor requestor, IProblemFactory problemFactory, PrintWriter out, CompilationProgress progress) {
        super(environment, policy, options, requestor, problemFactory, out, progress);
    }

    private void sortModuleDeclarationsFirst(ICompilationUnit[] sourceUnits) {
        Arrays.sort(sourceUnits, (u1, u2) -> {
            boolean isMod2;
            char[] fn1 = u1.getFileName();
            char[] fn2 = u2.getFileName();
            boolean isMod1 = CharOperation.endsWith(fn1, JDTConstants.MODULE_INFO_FILE_NAME) || CharOperation.endsWith(fn1, JDTConstants.MODULE_INFO_CLASS_NAME);
            boolean bl = isMod2 = CharOperation.endsWith(fn2, JDTConstants.MODULE_INFO_FILE_NAME) || CharOperation.endsWith(fn2, JDTConstants.MODULE_INFO_CLASS_NAME);
            if (isMod1 == isMod2) {
                return 0;
            }
            return isMod1 ? -1 : 1;
        });
    }

    protected CompilationUnitDeclaration[] buildUnits(CompilationUnit[] sourceUnits) {
        this.reportProgress(Messages.compilation_beginningToCompile);
        this.sortModuleDeclarationsFirst(sourceUnits);
        this.beginToCompile(sourceUnits);
        for (int i2 = 0; i2 < this.totalUnits; ++i2) {
            CompilationUnitDeclaration unit = this.unitsToProcess[i2];
            this.reportProgress(Messages.bind(Messages.compilation_processing, new String(unit.getFileName())));
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
            }
            if (unit.scope != null) {
                unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
            }
            unit.resolve();
            unit.analyseCode();
            unit.ignoreFurtherInvestigation = false;
            this.requestor.acceptResult(unit.compilationResult);
            this.reportWorked(1, i2);
        }
        ArrayList<CompilationUnitDeclaration> unitsToReturn = new ArrayList<CompilationUnitDeclaration>();
        for (CompilationUnitDeclaration cud : this.unitsToProcess) {
            if (cud == null) continue;
            unitsToReturn.add(cud);
        }
        return unitsToReturn.toArray(new CompilationUnitDeclaration[0]);
    }
}

