/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CaseKind;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtCaseImpl<E>
extends CtStatementImpl
implements CtCase<E> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.EXPRESSION})
    CtExpression<E> caseExpression;
    @MetamodelPropertyField(role={CtRole.EXPRESSION})
    List<CtExpression<E>> caseExpressions = CtCaseImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.STATEMENT})
    List<CtStatement> statements = CtCaseImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.CASE_KIND})
    CaseKind caseKind = CaseKind.COLON;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtCase(this);
    }

    @Override
    public CtExpression<E> getCaseExpression() {
        return this.caseExpression;
    }

    @Override
    public List<CtStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <T extends CtCase<E>> T setCaseExpression(CtExpression<E> caseExpression) {
        if (caseExpression != null) {
            caseExpression.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.CASE, caseExpression, this.caseExpression);
        this.caseExpression = caseExpression;
        return (T)this;
    }

    @Override
    public List<CtExpression<E>> getCaseExpressions() {
        return this.caseExpressions;
    }

    @Override
    public <T extends CtCase<E>> T setCaseExpressions(List<CtExpression<E>> caseExpressions) {
        if (caseExpressions == null || caseExpressions.isEmpty()) {
            this.caseExpressions = CtElementImpl.emptyList();
            return (T)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.CASE, caseExpressions, this.caseExpressions);
        this.caseExpressions.clear();
        for (CtExpression<E> expr : caseExpressions) {
            this.addCaseExpression(expr);
        }
        return (T)this;
    }

    @Override
    public <T extends CtCase<E>> T addCaseExpression(CtExpression<E> caseExpression) {
        if (caseExpression == null) {
            return (T)this;
        }
        this.ensureModifiableCaseExpressionsList();
        if (this.getCaseExpression() == null) {
            this.setCaseExpression(caseExpression);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.CASE, this.caseExpressions, this.caseExpressions);
        this.caseExpressions.add(caseExpression);
        return (T)this;
    }

    @Override
    public CaseKind getCaseKind() {
        return this.caseKind;
    }

    @Override
    public <T extends CtCase<E>> T setCaseKind(CaseKind kind) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.CASE_KIND, (Object)kind, (Object)this.caseKind);
        this.caseKind = kind;
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T setStatements(List<CtStatement> statements) {
        if (statements == null || statements.isEmpty()) {
            this.statements = CtElementImpl.emptyList();
            return (T)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.STATEMENT, this.statements, new ArrayList<CtStatement>(this.statements));
        this.statements.clear();
        for (CtStatement stmt : statements) {
            this.addStatement(stmt);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T addStatement(CtStatement statement) {
        return this.addStatement(this.statements.size(), statement);
    }

    private void ensureModifiableStatementsList() {
        if (this.statements == CtElementImpl.emptyList()) {
            this.statements = new ArrayList<CtStatement>(2);
        }
    }

    private void ensureModifiableCaseExpressionsList() {
        if (this.caseExpressions == CtElementImpl.emptyList()) {
            this.caseExpressions = new ArrayList<CtExpression<E>>(1);
        }
    }

    @Override
    public <T extends CtStatementList> T addStatement(int index, CtStatement statement) {
        if (statement == null) {
            return (T)this;
        }
        this.ensureModifiableStatementsList();
        statement.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.STATEMENT, this.statements, index, statement);
        this.statements.add(index, statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBegin(CtStatement statement) {
        this.ensureModifiableStatementsList();
        statement.setParent(this);
        this.addStatement(0, statement);
        if (this.isImplicit() && this.statements.size() > 1) {
            this.setImplicit(false);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBegin(CtStatementList statements) {
        this.ensureModifiableStatementsList();
        for (CtStatement statement : statements.getStatements()) {
            statement.setParent(this);
            this.addStatement(0, statement);
        }
        if (this.isImplicit() && this.statements.size() > 1) {
            this.setImplicit(false);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertEnd(CtStatement statement) {
        this.ensureModifiableStatementsList();
        this.addStatement(statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertEnd(CtStatementList statements) {
        ArrayList<CtStatement> tobeInserted = new ArrayList<CtStatement>(statements.getStatements());
        statements.setStatements(null);
        for (CtStatement s : tobeInserted) {
            this.insertEnd(s);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatement> T getStatement(int i2) {
        return (T)this.statements.get(i2);
    }

    @Override
    public <T extends CtStatement> T getLastStatement() {
        return (T)this.statements.get(this.statements.size() - 1);
    }

    @Override
    public void removeStatement(CtStatement statement) {
        if (this.statements == CtElementImpl.emptyList()) {
            return;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.STATEMENT, this.statements, this.statements.indexOf(statement), statement);
        this.statements.remove(statement);
    }

    @Override
    public Iterator<CtStatement> iterator() {
        return this.getStatements().iterator();
    }

    @Override
    public CtCase<E> clone() {
        return (CtCase)super.clone();
    }
}

