/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.reflect.code.CtCodeElementImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtStatementListImpl<R>
extends CtCodeElementImpl
implements CtStatementList {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.STATEMENT})
    List<CtStatement> statements = CtStatementListImpl.emptyList();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtStatementList(this);
    }

    @Override
    public List<CtStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <T extends CtStatementList> T setStatements(List<CtStatement> stmts) {
        if (stmts == null || stmts.isEmpty()) {
            this.statements = CtElementImpl.emptyList();
            return (T)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.STATEMENT, this.statements, new ArrayList<CtStatement>(this.statements));
        this.statements.clear();
        for (CtStatement stmt : stmts) {
            this.addStatement(stmt);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T addStatement(CtStatement statement) {
        return this.addStatement(this.statements.size(), statement);
    }

    @Override
    public <T extends CtStatementList> T addStatement(int index, CtStatement statement) {
        if (statement == null) {
            return (T)this;
        }
        if (this.statements == CtElementImpl.emptyList()) {
            this.statements = new ArrayList<CtStatement>(3);
        }
        statement.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.STATEMENT, this.statements, index, statement);
        this.statements.add(index, statement);
        return (T)this;
    }

    private void ensureModifiableStatementsList() {
        if (this.statements == CtElementImpl.emptyList()) {
            this.statements = new ArrayList<CtStatement>(3);
        }
    }

    @Override
    public <T extends CtStatementList> T insertBegin(CtStatementList statements) {
        this.ensureModifiableStatementsList();
        for (CtStatement statement : statements.getStatements()) {
            statement.setParent(this);
            this.addStatement(0, statement);
        }
        if (this.isImplicit() && this.statements.size() > 1) {
            this.setImplicit(false);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBegin(CtStatement statement) {
        this.ensureModifiableStatementsList();
        statement.setParent(this);
        this.addStatement(0, statement);
        if (this.isImplicit() && this.statements.size() > 1) {
            this.setImplicit(false);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertEnd(CtStatement statement) {
        this.ensureModifiableStatementsList();
        this.addStatement(statement);
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertEnd(CtStatementList statements) {
        ArrayList<CtStatement> tobeInserted = new ArrayList<CtStatement>(statements.getStatements());
        statements.setStatements(null);
        for (CtStatement s : tobeInserted) {
            this.insertEnd(s);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertAfter(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertAfter(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatement statement) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statement);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatementList> T insertBefore(Filter<? extends CtStatement> insertionPoints, CtStatementList statements) {
        for (CtStatement ctStatement : Query.getElements(this, insertionPoints)) {
            ctStatement.insertBefore(statements);
        }
        return (T)this;
    }

    @Override
    public <T extends CtStatement> T getStatement(int i2) {
        return (T)this.statements.get(i2);
    }

    @Override
    public <T extends CtStatement> T getLastStatement() {
        return (T)this.statements.get(this.statements.size() - 1);
    }

    @Override
    public void removeStatement(CtStatement statement) {
        if (this.statements == CtElementImpl.emptyList()) {
            return;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.STATEMENT, this.statements, this.statements.indexOf(statement), statement);
        this.statements.remove(statement);
    }

    @Override
    public <E extends CtElement> E setPosition(SourcePosition position) {
        for (CtStatement s : this.statements) {
            s.setPosition(position);
        }
        return (E)this;
    }

    @Override
    public Iterator<CtStatement> iterator() {
        return this.statements.iterator();
    }

    @Override
    public CtStatementList clone() {
        return (CtStatementList)super.clone();
    }

    public CtStatementList getSubstitution(CtType<?> targetType) {
        return this.clone();
    }
}

