/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import spoon.refactoring.Refactoring;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.filter.AllTypeMembersFunction;
import spoon.support.reflect.CtExtendedModifier;
import spoon.support.reflect.CtModifierHandler;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtExecutableImpl;
import spoon.support.visitor.ClassTypingContext;

public class CtMethodImpl<T>
extends CtExecutableImpl<T>
implements CtMethod<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.TYPE})
    CtTypeReference<T> returnType;
    @MetamodelPropertyField(role={CtRole.IS_DEFAULT})
    boolean defaultMethod = false;
    @MetamodelPropertyField(role={CtRole.TYPE_PARAMETER})
    List<CtTypeParameter> formalCtTypeParameters = CtMethodImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.MODIFIER})
    private CtModifierHandler modifierHandler = new CtModifierHandler(this);
    @MetamodelPropertyField(role={CtRole.IS_SHADOW})
    boolean isShadow;

    @Override
    public void accept(CtVisitor v) {
        v.visitCtMethod(this);
    }

    @Override
    public CtTypeReference<T> getType() {
        return this.returnType;
    }

    @Override
    public <C extends CtTypedElement> C setType(CtTypeReference<T> type) {
        if (type != null) {
            type.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.TYPE, type, this.returnType);
        this.returnType = type;
        return (C)this;
    }

    @Override
    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    @Override
    public <C extends CtMethod<T>> C setDefaultMethod(boolean defaultMethod) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_DEFAULT, defaultMethod, this.defaultMethod);
        this.defaultMethod = defaultMethod;
        return (C)this;
    }

    @Override
    public List<CtTypeParameter> getFormalCtTypeParameters() {
        return this.formalCtTypeParameters;
    }

    public <C extends CtFormalTypeDeclarer> C setFormalCtTypeParameters(List<CtTypeParameter> formalTypeParameters) {
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.TYPE_PARAMETER, this.formalCtTypeParameters, new ArrayList<CtTypeParameter>(this.formalCtTypeParameters));
        if (formalTypeParameters == null || formalTypeParameters.isEmpty()) {
            this.formalCtTypeParameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        this.formalCtTypeParameters.clear();
        for (CtTypeParameter formalTypeParameter : formalTypeParameters) {
            this.addFormalCtTypeParameter(formalTypeParameter);
        }
        return (C)this;
    }

    public <C extends CtFormalTypeDeclarer> C addFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        if (formalTypeParameter == null) {
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.TYPE_PARAMETER, this.formalCtTypeParameters, formalTypeParameter);
        formalTypeParameter.setParent(this);
        this.formalCtTypeParameters.add(formalTypeParameter);
        return (C)this;
    }

    @Override
    public boolean removeFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.TYPE_PARAMETER, this.formalCtTypeParameters, this.formalCtTypeParameters.indexOf(formalTypeParameter), formalTypeParameter);
        return this.formalCtTypeParameters.remove(formalTypeParameter);
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifierHandler.getModifiers();
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        this.modifierHandler.setModifiers(modifiers);
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        this.modifierHandler.addModifier(modifier);
        return (C)this;
    }

    public <C extends CtModifiable> C removeModifier(ModifierKind modifier) {
        this.modifierHandler.removeModifier(modifier);
        return (C)this;
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        this.modifierHandler.setVisibility(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        return this.modifierHandler.getVisibility();
    }

    @Override
    public Set<CtExtendedModifier> getExtendedModifiers() {
        return this.modifierHandler.getExtendedModifiers();
    }

    public <C extends CtModifiable> C setExtendedModifiers(Set<CtExtendedModifier> extendedModifiers) {
        this.modifierHandler.setExtendedModifiers(extendedModifiers);
        return (C)this;
    }

    @Override
    public boolean isOverriding(CtMethod<?> superMethod) {
        return new ClassTypingContext(this.getDeclaringType()).isOverriding(this, superMethod);
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_SHADOW, isShadow, this.isShadow);
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtMethod<T> clone() {
        return (CtMethod)super.clone();
    }

    @Override
    public Collection<CtMethod<?>> getTopDefinitions() {
        ArrayList s = new ArrayList();
        ClassTypingContext context = new ClassTypingContext(this.getDeclaringType());
        this.getDeclaringType().map(new AllTypeMembersFunction(CtMethod.class)).forEach(m -> {
            if (m != this && context.isOverriding(this, (CtMethod<?>)m)) {
                s.add(m);
            }
        });
        ArrayList finalMeths = new ArrayList(s);
        for (CtMethod m1 : s) {
            boolean m1IsIntermediate = false;
            for (CtMethod m2 : s) {
                if (!context.isOverriding(m1, m2)) continue;
                m1IsIntermediate = true;
            }
            if (m1IsIntermediate) continue;
            finalMeths.add(m1);
        }
        return finalMeths;
    }

    @Override
    public boolean isPublic() {
        return this.modifierHandler.isPublic();
    }

    @Override
    public boolean isPrivate() {
        return this.modifierHandler.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.modifierHandler.isProtected();
    }

    @Override
    public boolean isFinal() {
        return this.modifierHandler.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.modifierHandler.isStatic();
    }

    @Override
    public boolean isAbstract() {
        return this.modifierHandler.isAbstract();
    }

    @Override
    public CtMethod<?> copyMethod() {
        return Refactoring.copyMethod(this);
    }
}

