/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.eval;

import java.lang.reflect.Array;
import java.util.List;
import spoon.SpoonException;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.reference.CtVariableReference;

public class EvalHelper {
    private EvalHelper() {
    }

    public static Object convertElementToRuntimeObject(CtElement value) {
        if (value instanceof CtExpression) {
            CtExpression evaled = (CtExpression)((CtExpression)value).partiallyEvaluate();
            return EvalHelper.getCorrespondingRuntimeObject(evaled);
        }
        throw new SpoonException("not possible to convert to runtime object " + value);
    }

    public static Object getCorrespondingRuntimeObject(CtExpression<?> value) {
        if (value instanceof CtNewArray) {
            return EvalHelper.toArray((CtNewArray)value);
        }
        if (value instanceof CtAnnotation) {
            return ((CtAnnotation)value).getActualAnnotation();
        }
        if (value instanceof CtLiteral) {
            return ((CtLiteral)value).getValue();
        }
        if (value instanceof CtFieldRead) {
            CtVariableReference fieldRef = ((CtFieldRead)value).getVariable();
            Class<?> c = fieldRef.getDeclaringType().getActualClass();
            CtField field = fieldRef.getFieldDeclaration();
            if (Enum.class.isAssignableFrom(c)) {
                return Enum.valueOf(c, fieldRef.getSimpleName());
            }
            if (field.getDefaultExpression() instanceof CtLiteral) {
                return ((CtLiteral)field.getDefaultExpression()).getValue();
            }
        }
        throw new SpoonException("not possible to transform to expression \"" + value + "\" (" + value.getClass().getName() + ")");
    }

    private static Object toArray(CtNewArray value) {
        CtNewArray arrayExpression = value;
        Class<?> componentType = arrayExpression.getType().getActualClass().getComponentType();
        List<CtExpression<?>> elements = arrayExpression.getElements();
        Object array = Array.newInstance(componentType, elements.size());
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            Array.set(array, i2, EvalHelper.convertElementToRuntimeObject(elements.get(i2)));
        }
        return array;
    }

    public static boolean isKnownAtCompileTime(CtExpression<?> exp) {
        try {
            CtExpression evaled = (CtExpression)exp.partiallyEvaluate();
            EvalHelper.getCorrespondingRuntimeObject(evaled);
            return true;
        }
        catch (SpoonException e) {
            return false;
        }
    }
}

