/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.Array;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.reflect.reference.CtTypeReferenceImpl;

public class CtArrayTypeReferenceImpl<T>
extends CtTypeReferenceImpl<T>
implements CtArrayTypeReference<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.TYPE})
    CtTypeReference<?> componentType;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtArrayTypeReference(this);
    }

    @Override
    public CtTypeReference<?> getComponentType() {
        if (this.componentType == null) {
            this.componentType = this.getFactory().Type().objectType();
            this.componentType.setParent(this);
        }
        return this.componentType;
    }

    @Override
    public CtTypeReference<?> getArrayType() {
        return this.getLastComponentTypeReference(this.componentType);
    }

    private CtTypeReference<?> getLastComponentTypeReference(CtTypeReference<?> component) {
        return component instanceof CtArrayTypeReference ? this.getLastComponentTypeReference(((CtArrayTypeReference)component).getComponentType()) : component;
    }

    @Override
    public <C extends CtArrayTypeReference<T>> C setComponentType(CtTypeReference<?> componentType) {
        if (componentType != null) {
            componentType.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.TYPE, componentType, this.componentType);
        this.componentType = componentType;
        return (C)this;
    }

    @Override
    public String getSimpleName() {
        return this.getComponentType().getSimpleName() + "[]";
    }

    @Override
    public <T extends CtReference> T setSimpleName(String simplename) {
        return (T)this;
    }

    @Override
    public String getQualifiedName() {
        return this.getComponentType().getQualifiedName() + "[]";
    }

    @Override
    public Class<T> getActualClass() {
        Class<?> c = this.getComponentType().getActualClass();
        if (c == null) {
            throw new SpoonClassNotFoundException("you should never call getActualClass! (" + this.getComponentType().getQualifiedName() + " not found in the classpath)", null);
        }
        return Array.newInstance(c, 0).getClass();
    }

    @Override
    public int getDimensionCount() {
        if (this.getComponentType() instanceof CtArrayTypeReference) {
            return ((CtArrayTypeReference)this.getComponentType()).getDimensionCount() + 1;
        }
        return 1;
    }

    @Override
    public CtTypeReference<?> getTypeErasure() {
        CtTypeReference<?> erasedCT;
        CtTypeReference<?> originCT = this.getComponentType();
        if (originCT == (erasedCT = originCT.getTypeErasure())) {
            return this;
        }
        CtTypeReference erased = this.clone();
        erased.setComponentType(erasedCT);
        return erased;
    }

    @Override
    public CtArrayTypeReference<T> clone() {
        return (CtArrayTypeReference)super.clone();
    }

    @Override
    public boolean isSimplyQualified() {
        if (this.componentType != null) {
            return this.componentType.isSimplyQualified();
        }
        return false;
    }

    @Override
    public CtArrayTypeReferenceImpl<T> setSimplyQualified(boolean isSimplyQualified) {
        if (this.componentType != null) {
            this.componentType.setSimplyQualified(isSimplyQualified);
        }
        return this;
    }
}

