/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.filter.NamedElementFilter;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtReferenceImpl;
import spoon.support.reflect.reference.CtTypeReferenceImpl;
import spoon.support.util.RtHelper;
import spoon.support.visitor.ClassTypingContext;
import spoon.support.visitor.SignaturePrinter;

public class CtExecutableReferenceImpl<T>
extends CtReferenceImpl
implements CtExecutableReference<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.IS_STATIC})
    boolean stat = false;
    @MetamodelPropertyField(role={CtRole.TYPE_ARGUMENT})
    List<CtTypeReference<?>> actualTypeArguments = CtElementImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.TYPE})
    CtTypeReference<?> declaringType;
    @MetamodelPropertyField(role={CtRole.TYPE})
    CtTypeReference<T> type;
    @MetamodelPropertyField(role={CtRole.ARGUMENT_TYPE})
    List<CtTypeReference<?>> parameters = CtElementImpl.emptyList();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtExecutableReference(this);
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public boolean isConstructor() {
        return this.getSimpleName().equals("<init>");
    }

    @Override
    public CtExecutable<T> getDeclaration() {
        CtTypeReference<?> typeRef = this.getDeclaringType();
        if (typeRef == null || typeRef.getDeclaration() == null) {
            return null;
        }
        return this.getCtExecutable((CtType<?>)typeRef.getDeclaration());
    }

    @Override
    public CtExecutable<T> getExecutableDeclaration() {
        CtTypeReference<?> declaringType = this.getDeclaringType();
        if (declaringType == null) {
            return null;
        }
        if (declaringType instanceof CtArrayTypeReference && this.isConstructor()) {
            CtConstructor<?> constructor = this.getFactory().createInvisibleArrayConstructor();
            constructor.setType(declaringType);
            return constructor;
        }
        return this.getCtExecutable(declaringType.getTypeDeclaration());
    }

    private CtExecutable<T> getCtExecutable(CtType<?> typeDecl) {
        if (typeDecl == null) {
            return null;
        }
        CtTypeReference[] arrayParameters = this.parameters.toArray(new CtTypeReferenceImpl[0]);
        CtMethod method = typeDecl.getMethod(this.getSimpleName(), arrayParameters);
        if (method == null && typeDecl instanceof CtClass && this.isConstructor()) {
            try {
                CtClass zeClass = (CtClass)typeDecl;
                CtConstructor constructor = zeClass.getConstructor(arrayParameters);
                return constructor;
            }
            catch (ClassCastException e) {
                Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else if (method == null && this.getSimpleName().startsWith("lambda$")) {
            List<CtLambda> elements = typeDecl.getElements(new NamedElementFilter<CtLambda>(CtLambda.class, this.getSimpleName()));
            if (elements.isEmpty()) {
                return null;
            }
            return elements.get(0);
        }
        return method;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public CtTypeReference<T> getType() {
        return this.type;
    }

    @Override
    public List<CtTypeReference<?>> getParameters() {
        return CtExecutableReferenceImpl.unmodifiableList(this.parameters);
    }

    @Override
    public <C extends CtExecutableReference<T>> C setParameters(List<CtTypeReference<?>> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList();
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.ARGUMENT_TYPE, this.parameters, new ArrayList(this.parameters));
        this.parameters.clear();
        for (CtTypeReference<?> parameter : parameters) {
            this.addParameter(parameter);
        }
        return (C)this;
    }

    private boolean addParameter(CtTypeReference<?> parameter) {
        if (parameter == null) {
            return false;
        }
        this.checkMethodParameterTypeRef(parameter);
        parameter.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.ARGUMENT_TYPE, this.parameters, parameter);
        return this.parameters.add(parameter);
    }

    private void checkMethodParameterTypeRef(CtTypeReference<?> parameterType) {
        if (parameterType instanceof CtTypeParameterReference && !(parameterType instanceof CtWildcardReference)) {
            throw new SpoonException("CtExecutableReference cannot use CtTypeParameterReference. Use boundingType of CtTypeParameterReference instead.");
        }
        if (parameterType instanceof CtArrayTypeReference) {
            this.checkMethodParameterTypeRef(((CtArrayTypeReference)parameterType).getComponentType());
        }
    }

    @Override
    public <S extends T> CtExecutableReference<S> getOverridingExecutable(CtTypeReference<?> subType) {
        if (subType == null || subType.equals(this.getDeclaringType())) {
            return null;
        }
        CtElement t = subType.getDeclaration();
        if (t == null) {
            return null;
        }
        if (!(t instanceof CtClass)) {
            return null;
        }
        CtClass c = (CtClass)t;
        for (CtMethod<?> m : c.getMethods()) {
            if (!m.getReference().isOverriding(this)) continue;
            return m.getReference();
        }
        return this.getOverridingExecutable(c.getSuperclass());
    }

    @Override
    public boolean isOverriding(CtExecutableReference<?> executable) {
        CtExecutable<?> exec = executable.getExecutableDeclaration();
        CtExecutable<T> thisExec = this.getExecutableDeclaration();
        if (exec == null || thisExec == null) {
            boolean isSame;
            boolean bl = isSame = this.getSimpleName().equals(executable.getSimpleName()) && this.getParameters().equals(executable.getParameters()) && this.getActualTypeArguments().equals(executable.getActualTypeArguments());
            if (!isSame) {
                return false;
            }
            CtTypeReference<?> declaringType = this.getDeclaringType();
            return declaringType != null && declaringType.isSubtypeOf(executable.getDeclaringType());
        }
        if (exec instanceof CtMethod && thisExec instanceof CtMethod) {
            return new ClassTypingContext(((CtTypeMember)((Object)thisExec)).getDeclaringType()).isOverriding((CtMethod)thisExec, (CtMethod)exec);
        }
        return exec == this.getDeclaration();
    }

    public <C extends CtActualTypeContainer> C setActualTypeArguments(List<? extends CtTypeReference<?>> actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.isEmpty()) {
            this.actualTypeArguments = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList();
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.TYPE_ARGUMENT, this.actualTypeArguments, new ArrayList(this.actualTypeArguments));
        this.actualTypeArguments.clear();
        for (CtTypeReference<?> actualTypeArgument : actualTypeArguments) {
            this.addActualTypeArgument(actualTypeArgument);
        }
        return (C)this;
    }

    @Override
    public <C extends CtExecutableReference<T>> C setDeclaringType(CtTypeReference<?> declaringType) {
        if (declaringType != null) {
            declaringType.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.DECLARING_TYPE, declaringType, this.declaringType);
        this.declaringType = declaringType;
        return (C)this;
    }

    @Override
    public <C extends CtExecutableReference<T>> C setType(CtTypeReference<T> type) {
        if (type != null) {
            type.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.TYPE, type, this.type);
        this.type = type;
        return (C)this;
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        if (this.isConstructor()) {
            return this.getActualConstructor();
        }
        return this.getActualMethod();
    }

    @Override
    public Method getActualMethod() {
        List<CtTypeReference<?>> parameters = this.getParameters();
        CtTypeReference<?> declaringType = this.getDeclaringType();
        if (declaringType == null) {
            return null;
        }
        block0: for (Method m : declaringType.getActualClass().getDeclaredMethods()) {
            if (!m.getDeclaringClass().isSynthetic() && m.isSynthetic() || !m.getName().equals(this.getSimpleName()) || m.getParameterTypes().length != parameters.size()) continue;
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                Class<?> currentParameterType;
                Class<?> methodParameterType = m.getParameterTypes()[i2];
                if (methodParameterType != (currentParameterType = parameters.get(i2).getActualClass())) continue block0;
            }
            return m;
        }
        return null;
    }

    @Override
    public Constructor<?> getActualConstructor() {
        List<CtTypeReference<?>> parameters = this.getParameters();
        CtTypeReference<?> declaringType = this.getDeclaringType();
        if (declaringType == null) {
            return null;
        }
        block0: for (Constructor<?> c : declaringType.getActualClass().getDeclaredConstructors()) {
            if (c.getParameterTypes().length != parameters.size()) continue;
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                if (c.getParameterTypes()[i2] != parameters.get(i2).getActualClass()) continue block0;
            }
            return c;
        }
        return null;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public <C extends CtExecutableReference<T>> C setStatic(boolean stat) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IS_STATIC, stat, this.stat);
        this.stat = stat;
        return (C)this;
    }

    @Override
    public boolean isFinal() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            if (e instanceof CtMethod) {
                return ((CtMethod)e).hasModifier(ModifierKind.FINAL);
            }
            if (e instanceof CtConstructor) {
                return ((CtConstructor)e).hasModifier(ModifierKind.FINAL);
            }
            return false;
        }
        Method m = this.getActualMethod();
        return m != null && Modifier.isFinal(m.getModifiers());
    }

    public Set<ModifierKind> getModifiers() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            if (e instanceof CtMethod) {
                return ((CtMethod)e).getModifiers();
            }
            if (e instanceof CtConstructor) {
                return ((CtConstructor)e).getModifiers();
            }
            return CtElementImpl.emptySet();
        }
        Method m = this.getActualMethod();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        Constructor<?> c = this.getActualConstructor();
        if (c != null) {
            return RtHelper.getModifiers(c.getModifiers());
        }
        return Collections.emptySet();
    }

    @Override
    public CtExecutableReference<?> getOverridingExecutable() {
        CtTypeReference<Object> objectType = this.getFactory().Type().OBJECT;
        CtTypeReference<?> declaringType = this.getDeclaringType();
        if (declaringType == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        CtTypeReference<?> st = declaringType.getSuperclass();
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(st, objectType);
    }

    private CtExecutableReference<?> getOverloadedExecutable(CtTypeReference<?> t, CtTypeReference<Object> objectType) {
        if (t == null) {
            return null;
        }
        for (CtExecutableReference<?> e : t.getDeclaredExecutables()) {
            if (!this.isOverriding(e)) continue;
            return e;
        }
        if (t.equals(objectType)) {
            return null;
        }
        CtTypeReference<?> st = t.getSuperclass();
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(t.getSuperclass(), objectType);
    }

    public <C extends CtActualTypeContainer> C addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (actualTypeArgument == null) {
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList(2);
        }
        actualTypeArgument.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.TYPE_ARGUMENT, this.actualTypeArguments, actualTypeArgument);
        this.actualTypeArguments.add(actualTypeArgument);
        return (C)this;
    }

    @Override
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.TYPE_ARGUMENT, this.actualTypeArguments, this.actualTypeArguments.indexOf(actualTypeArgument), actualTypeArgument);
        return this.actualTypeArguments.remove(actualTypeArgument);
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public CtExecutableReference<T> clone() {
        return (CtExecutableReference)super.clone();
    }
}

