/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.SpoonException;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtComment;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.declaration.CtElementImpl;

public abstract class CtReferenceImpl
extends CtElementImpl
implements CtReference,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Collection<String> keywords = CtReferenceImpl.fillWithKeywords();
    @MetamodelPropertyField(role={CtRole.NAME})
    protected String simplename = "";

    protected abstract AnnotatedElement getActualAnnotatedElement();

    @Override
    public String getSimpleName() {
        return this.simplename;
    }

    @Override
    public <T extends CtReference> T setSimpleName(String simplename) {
        Factory factory = this.getFactory();
        this.checkIdentiferForJLSCorrectness(simplename);
        if (factory == null) {
            this.simplename = simplename;
            return (T)this;
        }
        if (factory instanceof FactoryImpl) {
            simplename = ((FactoryImpl)factory).dedup(simplename);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.NAME, simplename, this.simplename);
        this.simplename = simplename;
        return (T)this;
    }

    @Override
    @UnsettableProperty
    public <E extends CtElement> E setComments(List<CtComment> comments) {
        return (E)this;
    }

    @Override
    public abstract void accept(CtVisitor var1);

    @Override
    public CtReference clone() {
        return (CtReference)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CtReference) {
            CtReference ref = (CtReference)o;
            if (!Objects.equals(this.getSimpleName(), ref.getSimpleName())) {
                return false;
            }
            return super.equals(o);
        }
        return false;
    }

    private void checkIdentiferForJLSCorrectness(String simplename) {
        String[] splittedSimplename;
        if (!simplename.matches("<.*>|\\d.*|^.{0}$") && this.checkAllParts(splittedSimplename = simplename.split("\\.|<|>"))) {
            throw new SpoonException("Not allowed javaletter or keyword in identifier found. See JLS for correct identifier. Identifier: " + simplename);
        }
    }

    private boolean isKeyword(String simplename) {
        return keywords.contains(simplename);
    }

    private boolean checkAllParts(String[] simplenameParts) {
        for (String simpleName : simplenameParts) {
            if (this.isWildCard(simpleName = simpleName.replaceAll("\\[\\]|@", ""))) {
                return false;
            }
            if (!this.isKeyword(simpleName) && !this.checkIdentifierChars(simpleName)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIdentifierChars(String simplename) {
        if (simplename.length() == 0) {
            return false;
        }
        return !Character.isJavaIdentifierStart(simplename.charAt(0)) || simplename.chars().anyMatch(letter -> !Character.isJavaIdentifierPart(letter));
    }

    private static Collection<String> fillWithKeywords() {
        return Stream.of("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "do", "goto", "private", "this", "break", "implements", "protected", "throw", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "try", "final", "interface", "static", "finally", "strictfp", "volatile", "const", "native", "super", "while", "_").collect(Collectors.toCollection(HashSet::new));
    }

    private boolean isWildCard(String name) {
        return name.equals("?");
    }
}

